/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class JRResultSetDataSource
implements JRDataSource {
    private ResultSet resultSet = null;
    private Map columnIndexMap = new HashMap();

    public JRResultSetDataSource(ResultSet rs) {
        this.resultSet = rs;
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.resultSet != null) {
            try {
                boolean bl = hasNext = !this.resultSet.isLast();
                if (hasNext) {
                    this.resultSet.next();
                }
            }
            catch (SQLException e) {
                throw new JRException("Unable to get next record.", e);
            }
        }
        return hasNext;
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        Object objValue;
        block45: {
            objValue = null;
            if (field != null && this.resultSet != null) {
                Integer columnIndex = this.getColumnIndex(field.getName());
                Class clazz = field.getValueClass();
                try {
                    if (clazz.equals(Boolean.class)) {
                        objValue = this.resultSet.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
                        break block45;
                    }
                    if (clazz.equals(Byte.class)) {
                        objValue = new Byte(this.resultSet.getByte(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(Date.class)) {
                        objValue = this.resultSet.getDate(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(Timestamp.class)) {
                        objValue = this.resultSet.getTimestamp(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(Time.class)) {
                        objValue = this.resultSet.getTime(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(Double.class)) {
                        objValue = new Double(this.resultSet.getDouble(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(Float.class)) {
                        objValue = new Float(this.resultSet.getFloat(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(Integer.class)) {
                        objValue = new Integer(this.resultSet.getInt(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(InputStream.class)) {
                        byte[] bytes = this.readBytes(columnIndex);
                        objValue = bytes == null ? null : new ByteArrayInputStream(bytes);
                        break block45;
                    }
                    if (clazz.equals(Array.class)) {
                        objValue = this.resultSet.getObject(field.getName());
                        objValue = this.resultSet.wasNull() ? null : String.valueOf((char[])objValue);
                        break block45;
                    }
                    if (clazz.equals(Long.class)) {
                        objValue = new Long(this.resultSet.getLong(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(Short.class)) {
                        objValue = new Short(this.resultSet.getShort(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(BigDecimal.class)) {
                        objValue = this.resultSet.getBigDecimal(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block45;
                    }
                    if (clazz.equals(String.class)) {
                        int columnType;
                        try {
                            columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        }
                        catch (Exception e) {
                            columnType = 12;
                        }
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                }
                                objValue = this.clobToString(clob);
                                break;
                            }
                            default: {
                                objValue = this.resultSet.getString(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                }
                                break block45;
                            }
                        }
                        break block45;
                    }
                    if (clazz.equals(Clob.class)) {
                        objValue = this.resultSet.getClob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else if (clazz.equals(Reader.class)) {
                        Reader reader = null;
                        long size = -1L;
                        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) break;
                                reader = clob.getCharacterStream();
                                size = clob.length();
                                break;
                            }
                            default: {
                                reader = this.resultSet.getCharacterStream(columnIndex);
                                if (!this.resultSet.wasNull()) break;
                                reader = null;
                            }
                        }
                        objValue = reader == null ? null : this.getArrayReader(reader, size);
                    } else if (clazz.equals(Blob.class)) {
                        objValue = this.resultSet.getBlob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else {
                        byte[] bytes;
                        objValue = clazz.equals(Image.class) ? ((bytes = this.readBytes(columnIndex)) == null ? null : JRImageLoader.loadImage(bytes)) : this.resultSet.getObject(columnIndex);
                    }
                }
                catch (Exception e) {
                    throw new JRException("Unable to get value for field '" + field.getName() + "' of class '" + clazz.getName() + "'", e);
                }
            }
        }
        return objValue;
    }

    private Integer getColumnIndex(String fieldName) throws JRException {
        Integer columnIndex = (Integer)this.columnIndexMap.get(fieldName);
        if (columnIndex == null) {
            block6: {
                try {
                    ResultSetMetaData metadata = this.resultSet.getMetaData();
                    for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                        if (!fieldName.equalsIgnoreCase(metadata.getColumnName(i))) continue;
                        columnIndex = new Integer(i);
                        break;
                    }
                    if (columnIndex != null) break block6;
                    if (fieldName.startsWith("COLUMN_")) {
                        columnIndex = new Integer(fieldName.substring(7));
                        if (columnIndex <= 0 || columnIndex > this.resultSet.getMetaData().getColumnCount()) {
                            throw new JRException("Column index out of range : " + columnIndex);
                        }
                        break block6;
                    }
                    throw new JRException("Unknown column name : " + fieldName);
                }
                catch (SQLException e) {
                    throw new JRException("Unable to retrieve result set metadata.", e);
                }
            }
            this.columnIndexMap.put(fieldName, columnIndex);
        }
        return columnIndex;
    }

    protected String clobToString(Clob clob) throws JRException {
        try {
            int bufSize = 8192;
            char[] buf = new char[bufSize];
            BufferedReader reader = new BufferedReader(clob.getCharacterStream(), bufSize);
            StringBuffer str = new StringBuffer((int)clob.length());
            int read = reader.read(buf);
            while (read > 0) {
                str.append(buf, 0, read);
                read = reader.read(buf);
            }
            return str.toString();
        }
        catch (SQLException e) {
            throw new JRException("Unable to read clob value", e);
        }
        catch (IOException e) {
            throw new JRException("Unable to read clob value", e);
        }
    }

    protected CharArrayReader getArrayReader(Reader reader, long size) throws IOException {
        char[] buf = new char[8192];
        CharArrayWriter bufWriter = new CharArrayWriter(size > 0L ? (int)size : 8192);
        BufferedReader bufReader = new BufferedReader(reader, 8192);
        int read = bufReader.read(buf);
        while (read > 0) {
            bufWriter.write(buf, 0, read);
            read = bufReader.read(buf);
        }
        bufWriter.flush();
        return new CharArrayReader(bufWriter.toCharArray());
    }

    protected byte[] readBytes(Integer columnIndex) throws SQLException, IOException {
        InputStream is = null;
        long size = -1L;
        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
        switch (columnType) {
            case 2004: {
                try {
                    Blob blob = this.resultSet.getBlob(columnIndex);
                    if (this.resultSet.wasNull()) break;
                    is = blob.getBinaryStream();
                    size = blob.length();
                    break;
                }
                catch (Exception blob) {
                    // empty catch block
                }
            }
            default: {
                is = this.resultSet.getBinaryStream(columnIndex);
                if (!this.resultSet.wasNull()) break;
                is = null;
            }
        }
        byte[] bytes = null;
        if (is != null) {
            bytes = this.readBytes(is, size);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(InputStream is, long size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size > 0L ? (int)size : 1000);
        byte[] bytes = new byte[1000];
        int ln = 0;
        try {
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }
}

