/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.pdf.core.PDFDocException;
import coldfusion.vfs.VFSFileFactory;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.RandomAccessFileByteReader;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class PDFDocUtil {
    public static final String CFPDF = "CFPDF";
    public static final String CFPDFPARAM = "CFPDFPARAM";
    public static final String POPULATE = "POPULATE";
    public static final String ADDWATERMARK = "ADDWATERMARK";
    public static final String ADDHEADER = "ADDHEADER";
    public static final String ADDFOOTER = "ADDFOOTER";
    public static final String ARCHIVE = "ARCHIVE";
    public static final String UNSIGN = "UNSIGN";
    public static final String VALIDATESIGNATURE = "VALIDATESIGNATURE";
    public static final String READSIGNATUREFIELDS = "READSIGNATUREFIELDS";
    public static final String ALIGN_LEFT = "LEFT";
    public static final String ALIGN_CENTER = "CENTER";
    public static final String ALIGN_RIGHT = "RIGHT";
    public static final String FORMAT_ROMAN_UCASE = "UPPERCASEROMAN";
    public static final String FORMAT_ROMAN_LCASE = "LOWERCASEROMAN";
    public static final String FORMAT_NUMERIC = "NUMERIC";
    public static final String MERGE = "MERGE";
    public static final String MODIFY = "MODIFY";
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String SIGN = "SIGN";
    public static final String CREATESIGNATUREFIELD = "CREATESIGNATUREFIELD";
    public static final String ADDSIGNATUREFIELD = "ADDSIGNATUREFIELD";
    public static final String REMOVESIGNATURE = "REMOVESIGNATURE";
    public static final String VERIFYSIGNATURE = "VERIFYSIGNATURE";
    public static final String ENCRYPT = "ENCRYPT";
    public static final String PROTECT = "PROTECT";
    public static final String DECRYPT = "DECRYPT";
    public static final String USAGERIGHTS = "USAGERIGHTS";
    public static final String GETINFO = "GETINFO";
    public static final String SETINFO = "SETINFO";
    public static final String LIST = "LIST";
    public static final String REMOVEWATERMARK = "REMOVEWATERMARK";
    public static final String REMOVEHEADERFOOTER = "REMOVEHEADERFOOTER";
    public static final String DELETEPAGES = "DELETEPAGES";
    public static final String PROCESSDDX = "PROCESSDDX";
    public static final String THUMBNAIL = "THUMBNAIL";
    public static final String OPTIMIZE = "OPTIMIZE";
    public static final String TRANSFORM = "TRANSFORM";
    public static final String EXTRACTTEXT = "EXTRACTTEXT";
    public static final String EXTRACTIMAGE = "EXTRACTIMAGE";
    public static final String PAGELABEL = "_PAGELABEL";
    public static final String LAST_PAGELABEL = "_LASTPAGELABEL";
    public static final String PAGENUMBER = "_PAGENUMBER";
    public static final String PAGENUMBER2 = "_CURRENTPAGENUMBER";
    public static final String LAST_PAGENUMBER = "_LASTPAGENUMBER";
    public static final String LAST_PAGENUMBER2 = "_TOTALPAGECOUNT";
    public static final String IMAGE_DIR = "images";
    public static final String IMAGE_PREFIX = "cf";
    public static final String TYPE_XML = "XML";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_COMMENT = "COMMENT";
    public static final String TYPE_METADATA = "METADATA";
    public static final String PAGE_HEADER_START = "----- PAGE ";
    public static final String PAGE_HEADER_END = " -----";
    public static final String BILINEAR = "BILINEAR";
    public static final String BICUBIC = "BICUBIC";
    public static final String NEAREST_NEIGHBOUR = "NEAREST_NEIGHBOUR";
    public static final String BOOKMARK = "BOOKMARK";
    public static final String ATTACHMENT = "ATTACHMENT";
    public static final String WATERMARK = "WATERMARK";
    public static final String LINK = "LINK";
    public static final String TEXT = "TEXT";
    public static final String IMAGE = "IMAGE";
    public static final String TYPE = "TYPE";
    public static final String NAME = "NAME";
    public static final String TIME = "TIME";
    public static final String SOURCE = "source";
    public static final String DIRECTORY = "directory";
    public static final String DESTINATION = "destination";
    public static final String PAGES = "pages";
    public static final String FULL = "FULL";
    public static final String LINEAR = "LINEAR";
    public static final String INCREMENTAL = "INCREMENTAL";
    public static final String ALLOW_PRINT_HIGH = "AllowPrinting";
    public static final String ALLOW_PRINT_LOW = "AllowDegradedPrinting";
    public static final String ALLOW_MODIFY = "AllowModifyContents";
    public static final String ALLOW_COPY = "AllowCopy";
    public static final String ALLOW_ADD = "AllowModifyAnnotations";
    public static final String ALLOW_SECURE = "AllowSecure";
    public static final String ALLOW_ASSEMBLE = "AllowAssembly";
    public static final String ALLOW_EXTRACT = "AllowScreenReaders";
    public static final String ALLOW_FILLIN = "AllowFillIn";
    public static final String ALL = "ALL";
    public static final String NONE = "NONE";
    public static final String ENCRYPT_RC4_40 = "RC4_40";
    public static final String ENCRYPT_RC4_128 = "RC4_128";
    public static final String ENCRYPT_RC4_128M = "RC4_128M";
    public static final String ENCRYPT_AES_128 = "AES_128";
    public static final String ENCRYPT_AES_256R5 = "AES_256R5";
    public static final String ENCRYPT_AES_256R6 = "AES_256R6";
    public static final String ENCRYPT_NONE = "NONE";
    public static final String restrictedDDX = "coldfusion/pdf/coldfusion_ddx.xsd";
    public static final String restrictedDDXforStandard = "coldfusion/pdf/coldfusion_standard_ddx.xsd";
    public static final String xmlSchema = "coldfusion/pdf/xml.xsd";
    public static final String acroScript_AForm = "coldfusion/pdf/scripts/AForm.js";
    public static final String acroScript_Annots = "coldfusion/pdf/scripts/Annots.js";
    public static final String FORMAT_JPEG = "jpeg";
    public static final String FORMAT_JPG = "jpg";
    public static final String FORMAT_PNG = "png";
    public static final String FORMAT_TIFF = "tiff";
    public static final String FORMAT_TIF = "tif";
    public static final String FORMAT_DEFAULT = "jpg";
    public static final int SCALE_DEFAULT = 25;
    public static final String RESOLUTION_LOW = "low";
    public static final String RESOLUTION_HIGH = "high";
    public static final String RESOLUTION_DEFAULT = "high";
    public static final String THUMBNAIL_DIR = "thumbnails";
    public static final String THUMBNAIL_IMAGE_PREFIX = "thumbnail";
    public static final String UTF8 = "UTF-8";
    public static final String SIGNATUREFIELD = "FIELDNAME";
    public static final String ISIGNED = "SIGNED";
    public static final String ISAUTHORED = "AUTHORED";
    public static final String ISSIGNPERMITTED = "CAN_BE_SIGNED";
    public static final String ISCERTPERMITTED = "CAN_BE_AUTHORED";
    public static final String DATE = "DATE";
    public static final String SUBJECT = "SUBJECT";
    public static final String VISIBLE = "VISIBLE";
    public static final String[] SignatureColumnsNames = new String[]{"FIELDNAME", "SIGNED", "AUTHORED", "CAN_BE_SIGNED", "CAN_BE_AUTHORED", "VISIBLE"};
    public static final String[] SignatureColumnTypes = new String[]{"CF_SQL_VARCHAR", "CF_SQL_VARCHAR", "CF_SQL_VARCHAR", "CF_SQL_VARCHAR", "CF_SQL_VARCHAR", "CF_SQL_VARCHAR"};
    public static final String REDACT = "REDACT";
    public static final String COORDINATE = "COORDINATE";
    public static final String ICONNAME = "ICONNAME";
    public static final String SANITIZE = "SANITIZE";
    public static final String ADDSTAMP = "ADDSTAMP";
    public static final String IMPORT = "IMPORT";
    public static final String EXPORT = "EXPORT";
    public static final String ADDATTACHMENTS = "ADDATTACHMENTS";
    public static final String GETATTACHMENTS = "GETATTACHMENTS";
    public static final String IMPORTFROM = "IMPORTFROM";
    public static final String STANDARD2B = "2b";
    public static final String STANDARD3B = "3b";
    public static final String STANDARD1B = "1b";

    public static ByteReader getRAFByteReader(String relativeFileName) {
        RandomAccessFile raf = PDFDocUtil.getRandomAccessFile(relativeFileName);
        return new RandomAccessFileByteReader(raf);
    }

    public static ByteReader getInputStreamByteReader(String relativeFileName) {
        InputStreamByteReader reader = null;
        try {
            InputStream fstream = VFSFileFactory.getInputStream((String)relativeFileName);
            DataInputStream in = new DataInputStream(fstream);
            reader = new InputStreamByteReader((InputStream)in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reader;
    }

    public static RandomAccessFile getRandomAccessFile(String relativePathname) {
        RandomAccessFile rslt;
        try {
            rslt = new RandomAccessFile(relativePathname, "r");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rslt;
    }

    public static String romanNumeral(int value) throws PDFDocException {
        StringBuffer var_StringBuffer = new StringBuffer("");
        if (value > 4999) {
            throw new PDFDocException((Throwable)new Exception("value greater than 4999"));
        }
        int valueNumberOfThousands = value / 1000;
        int valueFragmentOfThousands = value % 1000;
        int valueNumberOfHundreds = valueFragmentOfThousands / 100;
        int valueFragmentOfHundreds = valueFragmentOfThousands % 100;
        int valueNumberOfTens = valueFragmentOfHundreds / 10;
        int valueFragmentOfTens = valueFragmentOfHundreds % 10;
        switch (valueNumberOfThousands) {
            case 4: {
                var_StringBuffer.append("mmmm");
                break;
            }
            case 3: {
                var_StringBuffer.append("mmm");
                break;
            }
            case 2: {
                var_StringBuffer.append("mm");
                break;
            }
            case 1: {
                var_StringBuffer.append("m");
                break;
            }
            case 0: {
                break;
            }
        }
        switch (valueNumberOfHundreds) {
            case 9: {
                var_StringBuffer.append("cm");
                break;
            }
            case 8: {
                var_StringBuffer.append("dccc");
                break;
            }
            case 7: {
                var_StringBuffer.append("dcc");
                break;
            }
            case 6: {
                var_StringBuffer.append("dc");
                break;
            }
            case 5: {
                var_StringBuffer.append("d");
                break;
            }
            case 4: {
                var_StringBuffer.append("cd");
                break;
            }
            case 3: {
                var_StringBuffer.append("ccc");
                break;
            }
            case 2: {
                var_StringBuffer.append("cc");
                break;
            }
            case 1: {
                var_StringBuffer.append("c");
                break;
            }
        }
        switch (valueNumberOfTens) {
            case 9: {
                var_StringBuffer.append("xc");
                break;
            }
            case 8: {
                var_StringBuffer.append("lxxx");
                break;
            }
            case 7: {
                var_StringBuffer.append("lxx");
                break;
            }
            case 6: {
                var_StringBuffer.append("lx");
                break;
            }
            case 5: {
                var_StringBuffer.append("l");
                break;
            }
            case 4: {
                var_StringBuffer.append("xl");
                break;
            }
            case 3: {
                var_StringBuffer.append("xxx");
                break;
            }
            case 2: {
                var_StringBuffer.append("xx");
                break;
            }
            case 1: {
                var_StringBuffer.append("x");
                break;
            }
        }
        switch (valueFragmentOfTens) {
            case 9: {
                var_StringBuffer.append("ix");
                break;
            }
            case 8: {
                var_StringBuffer.append("viii");
                break;
            }
            case 7: {
                var_StringBuffer.append("vii");
                break;
            }
            case 6: {
                var_StringBuffer.append("vi");
                break;
            }
            case 5: {
                var_StringBuffer.append("v");
                break;
            }
            case 4: {
                var_StringBuffer.append("iv");
                break;
            }
            case 3: {
                var_StringBuffer.append("iii");
                break;
            }
            case 2: {
                var_StringBuffer.append("ii");
                break;
            }
            case 1: {
                var_StringBuffer.append("i");
                break;
            }
        }
        return var_StringBuffer.toString();
    }

    public static String generateLCAlphaNumeralPDF(int in_value) {
        StringBuffer varBuffer = new StringBuffer("");
        int var_charindex = in_value % 26;
        String const_alphabet = "abcdefghijklmnopqrstuvwxyz";
        char InsertChar = "abcdefghijklmnopqrstuvwxyz".charAt(var_charindex);
        for (int i = in_value / 26 + 1; i > 0; --i) {
            varBuffer.append(InsertChar);
        }
        return varBuffer.toString();
    }

    public static final ByteWriter getRAFByteWriter(String fileName) throws IOException {
        File file = new File(fileName);
        return PDFDocUtil.getRAFByteWriter(file);
    }

    public static final ByteWriter getRAFByteWriter(File file) throws IOException {
        RandomAccessFile raf = PDFDocUtil.getRandomAccessFileForWriting(file, true);
        RandomAccessFileByteWriter byteWriter = new RandomAccessFileByteWriter(raf);
        return byteWriter;
    }

    private static final RandomAccessFile getRandomAccessFileForWriting(File file, boolean create) throws IOException {
        RandomAccessFile raf = null;
        if (create) {
            file.delete();
            if (file.exists()) {
                throw new RuntimeException("Failed to delete pre-existing file: \"" + file + "\".");
            }
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            file.createNewFile();
        }
        raf = new RandomAccessFile(file, "rw");
        return raf;
    }
}

