/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.pdf;

public class PdfViewerPreferences {
    public static final int PAGELAYOUT_SINGLE_PAGE = 1;
    public static final int PAGELAYOUT_ONE_COLUMN = 2;
    public static final int PAGELAYOUT_TWO_COLUMN_LEFT = 4;
    public static final int PAGELAYOUT_TWO_COLUMN_RIGHT = 8;
    public static final int PAGELAYOUT_TWO_PAGE_LEFT = 16;
    public static final int PAGELAYOUT_TWO_PAGE_RIGHT = 32;
    public static final int PAGEMODE_USE_NONE = 64;
    public static final int PAGEMODE_USE_OUTLINES = 128;
    public static final int PAGEMODE_USE_THUMBS = 256;
    public static final int PAGEMODE_FULL_SCREEN = 512;
    public static final int PAGEMODE_USE_OPTIONAL_CONTENT = 1024;
    public static final int PAGEMODE_USE_ATTACHMENT = 2048;
    public static final int HIDE_TOOLBAR = 4096;
    public static final int HIDE_MENUBAR = 8192;
    public static final int HIDE_WINDOW = 16384;
    public static final int FIT_WINDOW = 32768;
    public static final int CENTER_WINDOW = 65536;
    public static final int FULLSCEEN_EXIT_MODE_USE_NONE = 262144;
    public static final int FULLSCREEN_EXIT_MODE_USE_OUTLINES = 524288;
    public static final int FULLSCREEN_EXIT_MODE_USE_THUMBS = 0x100000;
    public static final int FULLSCREEN_EXIT_MODE_USE_OC = 0x200000;
    private int layout;
    private int pageMode;
    private int uiPreferences;
    private int nonFullScreenPreference;

    public void setPageLayout(int layout) {
        this.layout = layout;
    }

    public void setPageMode(int pageMode) {
        this.pageMode = pageMode;
    }

    public void hideToolbar() {
        this.uiPreferences |= 0x1000;
    }

    public void hideMenuBar() {
        this.uiPreferences |= 0x2000;
    }

    public void hideWindowControls() {
        this.uiPreferences |= 0x4000;
    }

    public void fitWindow() {
        this.uiPreferences |= 0x8000;
    }

    public void centerWindow() {
        this.uiPreferences |= 0x10000;
    }

    public void setFullScreenExitPageMode(int mode) {
        this.nonFullScreenPreference = mode;
    }

    public int getPreferences() {
        return this.layout | this.pageMode | this.uiPreferences | this.nonFullScreenPreference;
    }
}

