/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.filter.FusionContext;
import coldfusion.jsp.JspWriterIncludeResponse;
import coldfusion.log.CFLogs;
import coldfusion.pdf.PDFDocWrapper;
import coldfusion.pdf.PDFFormCFDocProcessor;
import coldfusion.pdf.PDFFormException;
import coldfusion.pdf.PDFXMLDataObject;
import coldfusion.pdf.XFAXMLtoCFStruct;
import coldfusion.pdf.XFDFXMLtoCFStruct;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.NeoPageContext;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.pdf.PDFFormTag;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.util.XmlUtils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFilePermission;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlProcessor;
import com.adobe.internal.io.ByteArrayByteWriter;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceService;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.spi.APContext;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.fdf.FDFDocument;
import com.adobe.internal.pdftoolkit.services.fdf.FDFService;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.security.SecurityKeyPassword;
import com.adobe.internal.pdftoolkit.services.xdp.XDPOptions;
import com.adobe.internal.pdftoolkit.services.xdp.XDPOptionsSet;
import com.adobe.internal.pdftoolkit.services.xdp.XDPService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfdf.XFDFService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PDFForm {
    public static final int NOT_A_FORM = -1;
    public static final int ACROFORM = 1;
    public static final int XML_FORM = 2;
    public static final int XDP_FORMAT = 1;
    public static final int PDF_FORMAT = 2;
    public static final String XFA_DATASET_START_TAG = "<xfa:datasets xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\">";
    public static final String XFA_DATASET_END_TAG = "</xfa:datasets>";
    public static final String XFA_DATA_START_TAG = "<xfa:data>";
    public static final String XFA_DATA_END_TAG = "</xfa:data>";
    private static final String TEMPPDFNAME = "_temp.pdf";
    private PDFDocument doc = null;
    private int formType = 0;
    private String resolvedFilePath = null;
    private PDFFormTag pdfFormtag;

    public PDFForm(PDFFormTag pdfformtag) {
        this.pdfFormtag = pdfformtag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFDocument readPDFfromByteArray(byte[] srcPdfBytes) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        InputStreamByteReader byteReader = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(srcPdfBytes);
            byteReader = new InputStreamByteReader((InputStream)byteArrayInputStream);
            this.doc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
        }
        finally {
            try {
                byteReader.close();
            }
            catch (Exception exception) {}
        }
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFDocument readSrcPDF(final String srcPdfName) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, IOException {
        PDFDocument doc = null;
        InputStream srcPdfFile = null;
        InputStreamByteReader byteReader = null;
        try {
            srcPdfFile = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    InputStream srcPdfFileTemp = VFSFileFactory.getInputStream((String)srcPdfName);
                    return srcPdfFileTemp;
                }
            });
            byteReader = new InputStreamByteReader(srcPdfFile);
            doc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
        }
        catch (PrivilegedActionException paex) {
            if (paex.getException() instanceof FileNotFoundException) {
                throw new PDFException.FileCouldNotBeFoundException((Throwable)paex.getException(), srcPdfName);
            }
        }
        finally {
            if (srcPdfFile != null) {
                srcPdfFile.close();
            }
            if (byteReader != null) {
                byteReader.close();
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFDocument populateFields(Object src, String destPDFName, PDFXMLDataObject pdfDataObject, JspWriter out, FusionContext fcontext, boolean overwrite, Object dataFile, String name) throws IOException, PDFException {
        InputStream formDataInputStream = null;
        HttpServletResponse response = fcontext.response;
        NeoPageContext pageContext = fcontext.pageContext;
        try {
            boolean bAllowed;
            if (this.doc == null || this.formType == 0) {
                this.formType = this.determineFormType(src, fcontext);
            }
            if (dataFile == null) {
                formDataInputStream = new ByteArrayInputStream(pdfDataObject.getXML());
            } else {
                String fileContent = null;
                try {
                    fileContent = this.readXmlData(dataFile, fcontext);
                }
                catch (Exception ex) {
                    throw new PDFException.XMLDataAttributeValueException((Throwable)ex);
                }
                if (fileContent == null) {
                    fileContent = "";
                    CFLogs.SERVER_LOG.info((Object)"Datafile supplied to <cfpdfform> does not have any content");
                }
                if (this.pdfFormtag.isOverwritedata()) {
                    if (this.formType == 2) {
                        String xfadatapre = "<xfa:datasets xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\"><xfa:data>";
                        String xfadatapost = "</xfa:data></xfa:datasets>";
                        fileContent = this.addXMLNode("xfa:datasets", fileContent, xfadatapre, xfadatapost);
                    } else {
                        String fieldspre = "<fields>";
                        String fieldspost = "</fields>";
                        fileContent = this.addXMLNode(fieldspre, fileContent, fieldspre, fieldspost);
                        String xfdfpre = "<xfdf xmlns=\"http://ns.adobe.com/xfdf/\" xml:space=\"preserve\">";
                        String xfdfpost = "</xfdf>";
                        fileContent = this.addXMLNode("<xfdf", fileContent, xfdfpre, xfdfpost);
                    }
                    formDataInputStream = new ByteArrayInputStream(fileContent.getBytes());
                } else {
                    Map dataStruct;
                    if (this.formType == 2) {
                        dataStruct = XFAXMLtoCFStruct.parseXMLtoCF(fileContent);
                        pdfDataObject.buildFormParamsListFromDataFileStruct(dataStruct, new Vector());
                    } else {
                        dataStruct = XFDFXMLtoCFStruct.parseXMLtoCF(fileContent);
                        pdfDataObject.buildFormParamsListFromDataFileStruct(dataStruct, new Vector());
                    }
                    try {
                        pdfDataObject.createFormXMLData(this.pdfFormtag.isOverwritedata());
                    }
                    catch (Exception ex) {
                        throw new PDFFormException(ex);
                    }
                    formDataInputStream = new ByteArrayInputStream(pdfDataObject.getXML());
                }
            }
            PermissionsManager mgr = PermissionsManager.newInstance((PDFDocument)this.doc);
            boolean bl = bAllowed = mgr.isPermitted(ObjectOperations.FORM_IMPORT) || mgr.isPermitted(ObjectOperations.FORM_FILLIN);
            if (!bAllowed) {
                throw new PDFException.FormFillNotAllowedException();
            }
            if (this.formType == 2) {
                XFAService.importElement((PDFDocument)this.doc, (XFAService.XFAElement)XFAService.XFAElement.DATASETS, (InputStream)formDataInputStream);
            } else {
                XFDFService.importFormData((PDFDocument)this.doc, (InputStream)formDataInputStream);
                APResources apResources = new APResources((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet(), Locale.ROOT, null);
                APContext apContext = new APContext(apResources, true, null);
                TextFormatterImpl textFormatter = new TextFormatterImpl(this.doc);
                AppearanceService.generateAppearances((PDFDocument)this.doc, (APContext)apContext, (TextFormatter)textFormatter);
            }
            if (this.pdfFormtag.isCFDocumentParent()) {
                ((PDFFormCFDocProcessor)this.pdfFormtag.getParentDocumentTag().getPdfCFDocumentProcessor()).setPdfForm(this.doc);
            } else {
                if (destPDFName != null || name != null) {
                    PDFDocument pDFDocument = this.saveDocument(destPDFName, this.doc, overwrite, fcontext);
                    return pDFDocument;
                }
                this.writeToBrowser(src, response, this.doc, out, (PageContext)pageContext);
            }
        }
        finally {
            if (!this.pdfFormtag.isCFDocumentParent() && this.doc != null && name == null) {
                this.doc.close();
            }
            if (formDataInputStream != null) {
                formDataInputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFDocument populateFDFFields(Object src, String destPDFName, PDFXMLDataObject pdfDataObject, JspWriter out, FusionContext fcontext, boolean overwrite, String fdfData, String name) throws IOException, PDFException {
        InputStream formDataInputStream = null;
        HttpServletResponse response = fcontext.response;
        NeoPageContext pageContext = fcontext.pageContext;
        File dataFile = fdfData == null ? null : VFSFileFactory.getFileObject((String)fdfData);
        InputStreamByteReader fdfByteReader = null;
        FDFDocument fdfDoc = null;
        try {
            boolean bAllowed;
            if (this.doc == null || this.formType == 0) {
                this.formType = this.determineFormType(src, fcontext);
            }
            if (this.formType == 2) {
                throw new PDFException.FDFNotAllowedException();
            }
            if (dataFile == null) {
                formDataInputStream = new ByteArrayInputStream(pdfDataObject.getXML());
            } else {
                if (!dataFile.exists()) {
                    throw new PDFException.FileCouldNotBeFoundException(dataFile.getAbsolutePath());
                }
                formDataInputStream = new FileInputStream(dataFile);
            }
            PermissionsManager mgr = PermissionsManager.newInstance((PDFDocument)this.doc);
            boolean bl = bAllowed = mgr.isPermitted(ObjectOperations.FORM_IMPORT) || mgr.isPermitted(ObjectOperations.FORM_FILLIN);
            if (!bAllowed) {
                throw new PDFException.FormFillNotAllowedException();
            }
            fdfByteReader = new InputStreamByteReader(formDataInputStream);
            fdfDoc = FDFDocument.newInstance((ByteReader)fdfByteReader);
            FDFService fdfService = new FDFService(this.doc);
            fdfService.importForm(fdfDoc, (PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet(), Locale.ROOT, false);
            if (this.pdfFormtag.isCFDocumentParent()) {
                ((PDFFormCFDocProcessor)this.pdfFormtag.getParentDocumentTag().getPdfCFDocumentProcessor()).setPdfForm(this.doc);
            } else {
                if (destPDFName != null || name != null) {
                    PDFDocument pDFDocument = this.saveDocument(destPDFName, this.doc, overwrite, fcontext);
                    return pDFDocument;
                }
                this.writeToBrowser(src, response, this.doc, out, (PageContext)pageContext);
            }
        }
        catch (Exception e) {
            System.out.println("e = " + e);
        }
        finally {
            if (!this.pdfFormtag.isCFDocumentParent() && this.doc != null && name == null) {
                this.doc.close();
            }
            if (formDataInputStream != null) {
                formDataInputStream.close();
            }
            if (fdfDoc != null) {
                fdfDoc.close();
            }
            if (fdfByteReader != null) {
                fdfByteReader.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String extractFields(Object sourcePDF, FusionContext fcontext) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFInvalidXMLException, PDFException {
        ByteArrayOutputStream out = null;
        try {
            if (this.doc == null || this.formType == 0) {
                this.formType = this.determineFormType(sourcePDF, fcontext);
            }
            out = new ByteArrayOutputStream();
            if (this.formType == 2) {
                XFAService.exportElement((PDFDocument)this.doc, (XFAService.XFAElement)XFAService.XFAElement.DATASETS, (OutputStream)out);
            } else {
                XFDFService.exportFormData((PDFDocument)this.doc, (OutputStream)out);
            }
        }
        finally {
            if (this.doc != null) {
                this.doc.close();
            }
        }
        byte[] dataBytes = out.toByteArray();
        String dataXML = null;
        try {
            dataXML = new String(dataBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportencodingex) {
            throw unsupportencodingex;
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        return dataXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFDF(Object sourcePDF, String fdfFile, FusionContext fcontext) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFInvalidXMLException, PDFException {
        FDFDocument fdfDoc = null;
        RandomAccessFileByteWriter outputPDF = null;
        try {
            if (this.doc == null || this.formType == 0) {
                this.formType = this.determineFormType(sourcePDF, fcontext);
            }
            if (this.formType == 2) {
                throw new PDFException.FDFNotAllowedException();
            }
            RandomAccessFile outputPDFFile = null;
            try {
                outputPDFFile = new RandomAccessFile(fdfFile, "rw");
            }
            catch (FileNotFoundException fnfe) {
                throw new PDFException.FileCouldNotBeFoundException((Throwable)fnfe, fdfFile);
            }
            outputPDF = new RandomAccessFileByteWriter(outputPDFFile);
            FDFService fdfService = new FDFService(this.doc);
            fdfDoc = fdfService.exportForm(null);
            fdfDoc.save((ByteWriter)outputPDF);
        }
        finally {
            if (this.doc != null) {
                this.doc.close();
            }
            if (outputPDF != null) {
                outputPDF.close();
            }
            if (fdfDoc != null) {
                fdfDoc.close();
            }
        }
    }

    private PDFDocument saveDocument(String fileName, PDFDocument pdfDocument, boolean overwrite, FusionContext fcontext) throws PDFException, IOException {
        String fullFilePath = null;
        if (fileName != null) {
            fullFilePath = Utils.getFileFullPath((String)fileName, (PageContext)fcontext.pageContext, (boolean)true);
            this.checkFileWritePermission(fullFilePath, overwrite);
        }
        int format = 2;
        if (fileName != null && fileName.toLowerCase().endsWith(".pdf")) {
            format = 2;
        } else if (fileName != null && fileName.toLowerCase().endsWith(".xdp")) {
            format = 1;
        } else if (fileName != null) {
            throw new PDFException.InvalidFileNameException(fullFilePath);
        }
        if (format == 1 && this.formType != 2) {
            throw new PDFException.XDPConvertException(this.resolvedFilePath);
        }
        RandomAccessFile outputPDFFile = null;
        ByteArrayByteWriter outputPDF = null;
        if (fullFilePath != null) {
            outputPDFFile = null;
            try {
                outputPDFFile = new RandomAccessFile(fullFilePath, "rw");
            }
            catch (FileNotFoundException fnfe) {
                throw new PDFException.FileCouldNotBeFoundException((Throwable)fnfe, fileName);
            }
            outputPDF = new RandomAccessFileByteWriter(outputPDFFile);
        } else {
            outputPDF = new ByteArrayByteWriter();
        }
        if (format == 1) {
            XDPService.convert((PDFDocument)pdfDocument, (XDPOptions)XDPOptionsSet.kAll, (ByteWriter)outputPDF, null);
        } else {
            PDFForm.savePDF(pdfDocument, (ByteWriter)outputPDF);
        }
        if (outputPDF instanceof ByteArrayByteWriter) {
            return this.readSource(outputPDF.toByteArray(), FusionContext.getCurrent());
        }
        if (outputPDF != null) {
            outputPDF.close();
        }
        if (outputPDFFile != null) {
            outputPDFFile.close();
        }
        return null;
    }

    private String getTempFileName(Object src) {
        return System.identityHashCode(src) + TEMPPDFNAME;
    }

    private void writeToBrowser(Object src, HttpServletResponse response, PDFDocument pdfDocument, JspWriter out, PageContext pageContext) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, IOException, PDFException {
        ByteArrayByteWriter outputPDF = new ByteArrayByteWriter();
        PDFForm.savePDF(pdfDocument, (ByteWriter)outputPDF);
        byte[] pdfbytes = outputPDF.toByteArray();
        String tempFileName = this.getTempFileName(src);
        response.setHeader("Content-disposition", "inline;filename=\"" + tempFileName + "\"");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        HttpServletResponse resp = response;
        while (resp instanceof JspWriterIncludeResponse) {
            resp = ((JspWriterIncludeResponse)resp).getResponse();
        }
        if (out instanceof CFOutput) {
            ((CFOutput)out).clearAll();
        }
        if (pageContext instanceof NeoPageContext) {
            ((NeoPageContext)pageContext).setFlushOutput(false);
        }
        resp.setContentType("application/pdf");
        ServletOutputStream os = resp.getOutputStream();
        response.setContentLength(pdfbytes.length);
        os.write(pdfbytes);
        os.flush();
        if (outputPDF != null) {
            outputPDF.close();
        }
        throw new AbortException();
    }

    private PDFDocument readSource(Object source, FusionContext fContext) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException, PDFException {
        boolean BYTEARRAY = false;
        boolean FILENAME = true;
        int sourceType = -1;
        if (source instanceof PDFDocument) {
            return (PDFDocument)source;
        }
        if (source instanceof byte[]) {
            sourceType = 0;
        } else if (source instanceof String) {
            sourceType = 1;
        } else {
            if (source instanceof PDFDocWrapper) {
                return ((PDFDocWrapper)source).getDoc();
            }
            throw new PDFException.InvalidAttributeValueException2();
        }
        PDFDocument doc = null;
        if (sourceType == 1) {
            this.resolvedFilePath = Utils.getFileFullPath((String)((String)source), (PageContext)fContext.pageContext, (boolean)true);
            doc = this.readSrcPDF(this.resolvedFilePath);
        } else {
            doc = this.readPDFfromByteArray((byte[])source);
        }
        this.checkNUnlock(doc);
        return doc;
    }

    public int determineFormType(Object sourcePDF, FusionContext fcontext) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, IOException, PDFException {
        if (this.doc == null || this.formType == 0) {
            this.doc = this.readSource(sourcePDF, fcontext);
            return PDFForm.determineFormType(this.doc);
        }
        return this.formType;
    }

    public static int determineFormType(PDFDocument doc) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, IOException, PDFException {
        int formType = 0;
        if (doc == null) {
            throw new PDFException.NotAPDFFormException();
        }
        PDFInteractiveForm pdfinteractiveform = doc.getInteractiveForm();
        if (pdfinteractiveform == null) {
            throw new PDFException.NotAPDFFormException();
        }
        formType = pdfinteractiveform.hasXFA() ? 2 : 1;
        return formType;
    }

    private String readTextFile(String fileName, FusionContext fContext) {
        fileName = Utils.getFileFullPath((String)fileName, (PageContext)fContext.pageContext, (boolean)true);
        StringBuffer fileContent = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(VFSFileFactory.getInputStream((String)fileName), "UTF-8"));
            String str = null;
            while ((str = in.readLine()) != null) {
                fileContent.append(str);
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new PDFException.FileCouldNotBeFoundException((Throwable)fnfe, fileName);
        }
        catch (IOException ioe) {
            throw new PDFException.FileIOException(fileName);
        }
        return fileContent.toString();
    }

    private String readUrl(String url) throws IOException {
        try (InputStream inStream = null;){
            HttpURLConnection httpCon = (HttpURLConnection)new URL(url).openConnection();
            inStream = httpCon.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
            StringBuffer strBuf = new StringBuffer();
            String tmp = null;
            while ((tmp = reader.readLine()) != null) {
                strBuf.append(tmp + "\n");
            }
            String string = strBuf.toString();
            return string;
        }
    }

    private String readXmlData(Object xmlSource, FusionContext fcontext) throws IOException {
        String xmlData = null;
        if (xmlSource instanceof XmlNodeList) {
            return ((XmlNodeList)xmlSource).toString();
        }
        if (xmlSource instanceof Document) {
            return XmlUtils.serialize((Node)((Document)xmlSource), (OutputFormat)XmlUtils.createDefaultFormat(), (boolean)true);
        }
        if (xmlSource instanceof Element) {
            return XmlUtils.serialize((Node)((Element)xmlSource), (OutputFormat)XmlUtils.createDefaultFormat(), (boolean)true);
        }
        String xmlSourceString = null;
        try {
            xmlSourceString = (String)xmlSource;
        }
        catch (Exception ex) {
            throw new PDFException.XMLDataAttributeValueException((Throwable)ex);
        }
        if (xmlSourceString.indexOf("<") != -1 && xmlSourceString.indexOf(">") != -1) {
            try {
                XmlProcessor.parse((String)xmlSourceString, (boolean)true);
            }
            catch (Exception ex) {
                throw new PDFException.DataAttributeInvalidXMLException((Throwable)ex);
            }
            return xmlSourceString;
        }
        if (xmlSourceString.trim().toLowerCase().startsWith("http") && xmlSourceString.indexOf("://") != -1) {
            try {
                xmlData = this.readUrl(xmlSourceString);
            }
            catch (IOException ioe) {
                xmlData = this.readTextFile(xmlSourceString, fcontext);
            }
            return xmlData;
        }
        try {
            xmlData = this.readTextFile(xmlSourceString, fcontext);
        }
        catch (PDFException.FileCouldNotBeFoundException e) {
            try {
                xmlData = this.readUrl(xmlSourceString);
            }
            catch (Exception e1) {
                throw e;
            }
        }
        return xmlData;
    }

    public void writeTextFile(String fileName, String content, boolean overwrite) {
        this.checkFileWritePermission(fileName, overwrite);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(VFSFileFactory.getOutputStream((String)fileName), "UTF-8"));
            out.write(content);
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new PDFException.FileCouldNotBeFoundException((Throwable)fnfe, fileName);
        }
        catch (UnsupportedEncodingException ueex) {
            throw new PDFFormException(ueex);
        }
        catch (IOException ioex) {
            throw new PDFFormException(ioex);
        }
    }

    private static void addNoCacheJavaScript(PDFDocument pdfDocument) {
        try {
            PDFNamedJavaScripts js1;
            String jscode = "this.nocache=true;";
            PDFNameDictionary pdfNameDictionary = pdfDocument.requireCatalog().procureNameDictionary();
            PDFNamedJavaScripts pDFNamedJavaScripts = js1 = pdfNameDictionary != null ? pdfNameDictionary.procureNamedJavaScripts() : null;
            if (js1 != null) {
                PDFActionJavaScript js = PDFActionJavaScript.newInstance((PDFDocument)pdfDocument, (PDFText)PDFText.newInstance((PDFDocument)pdfDocument, (String)jscode));
                js1.addEntry((Object)new ASString("nocache"), (Object)js);
            }
        }
        catch (PDFInvalidParameterException jscode) {
        }
        catch (Exception ex) {
            CFLogs.SERVER_LOG.info((Object)"Javascript entry this.nocache=true could not be added", (Throwable)ex);
        }
    }

    public PDFDocument getDoc() {
        return this.doc;
    }

    public int getFormType() {
        return this.formType;
    }

    public String addXMLNode(String searchstring, String fileContent, String pre, String post) {
        StringBuffer modifiedXMLString = new StringBuffer(fileContent);
        if (fileContent.indexOf(searchstring) == -1) {
            int indexOfxml = fileContent.indexOf("<?xml");
            if (indexOfxml == -1) {
                modifiedXMLString.insert(0, pre);
                modifiedXMLString.append(post);
            } else {
                int indexofxmlEnd = fileContent.indexOf("?>");
                modifiedXMLString.insert(indexofxmlEnd + 2, pre);
                modifiedXMLString.append(post);
            }
        }
        return modifiedXMLString.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkFileWritePermission(String fullFilePath, boolean overwrite) {
        File outputFile = VFSFileFactory.getFileObject((String)fullFilePath);
        if (outputFile.isDirectory()) {
            throw new PDFException.TargetFileIsDirectoryException(fullFilePath);
        }
        if (!outputFile.exists()) return;
        if (outputFile.canWrite()) {
            if (!overwrite) throw new PDFException.FileOverwriteException(fullFilePath);
            try {
                if (VFSFileFactory.checkIfVFile((String)outputFile.getAbsolutePath())) {
                    ServiceFactory.getSecurityService().checkPermission((Permission)new VFilePermission(outputFile.getAbsolutePath(), "write"));
                } else {
                    ServiceFactory.getSecurityService().checkPermission((Permission)new FilePermission(outputFile.getAbsolutePath(), "write"));
                }
                outputFile.delete();
                return;
            }
            catch (AccessControlException e) {
                throw new PDFException.FileAccessException(fullFilePath);
            }
        } else {
            if (!outputFile.canRead()) throw new PDFException.FileReadWriteException(fullFilePath);
            throw new PDFException.FileReadOnlyException(fullFilePath);
        }
    }

    static void savePDF(PDFDocument pdfDocument, ByteWriter outputPDF) throws PDFException {
        SignatureManager sigMgr = SignatureManager.newInstance((PDFDocument)pdfDocument);
        if (sigMgr.hasUsageRights() || sigMgr.hasSignatureFields()) {
            pdfDocument.save(outputPDF, (PDFSaveOptions)PDFSaveIncrementalOptions.newInstance());
        } else {
            PDFForm.addNoCacheJavaScript(pdfDocument);
            pdfDocument.save(outputPDF, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
        }
    }

    private void checkNUnlock(PDFDocument doc) {
        if (!doc.isUnlocked()) {
            try {
                SecurityKeyPassword defaultKey = SecurityKeyPassword.newInstance((PDFDocument)doc);
                doc.unlock((SecurityKey)defaultKey);
            }
            catch (PDFException pdfEx) {
                throw new PDFFormException(pdfEx, RB.getString(PDFFormException.class, (String)"cfpdfform.unlock"));
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Class.forName("com.adobe.xfa.Model");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

