/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.netty;

import coldfusion.log.CFLogs;
import coldfusion.tagext.net.websocket.server.core.ClientConnection;
import coldfusion.tagext.net.websocket.server.core.ClientConnectionManager;
import coldfusion.tagext.net.websocket.server.core.WSTaskProcessor;
import coldfusion.util.RB;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;

public class WebSocketClientConnectionInitializer
extends ChannelInboundHandlerAdapter {
    private ClientConnection clientConnection;

    private void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        this.initClientConnection(ctx, req);
        CFLogs.WEBSOCKET_LOG.info((Object)RB.getString(WebSocketClientConnectionInitializer.class, (String)"HANDSHAKE_INITIATED"));
        ctx.fireChannelRead((Object)req);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.channelRead0(ctx, (FullHttpRequest)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.closeClientConnection();
        CFLogs.WEBSOCKET_LOG.info((Object)RB.getString(WebSocketClientConnectionInitializer.class, (String)"CONNECTION_CLOSED"));
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
        CFLogs.WEBSOCKET_LOG.info((Object)RB.getString(WebSocketClientConnectionInitializer.class, (String)"EXCEPTION_CLOSED_CONNECTION", (Object)cause.getLocalizedMessage()));
    }

    private void initClientConnection(ChannelHandlerContext ctx, FullHttpRequest req) {
        this.clientConnection = new ClientConnection(ctx, req.headers());
        ClientConnectionManager.addClientConnection(this.clientConnection);
    }

    private void closeClientConnection() {
        if (this.clientConnection == null) {
            return;
        }
        WSTaskProcessor.getTaskProcessor().connectionClosed(this.clientConnection);
        ClientConnectionManager.removeClientConnection(this.clientConnection.getConnectionId());
    }
}

