/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server;

import coldfusion.log.CFLogs;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketClusterManager;
import coldfusion.tagext.net.websocket.server.netty.WSNettyPipelineFactory;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyServer;
import coldfusion.util.RB;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class WebSocketEngine {
    private boolean isRunning;
    private ChannelFuture serverSocketChannelFuture;
    private ChannelFuture serverSecureSocketChannelFuture;
    private EventLoopGroup parentGroup;
    private EventLoopGroup childGroup;
    private WebSocketService webSocketService;
    private WSProxyServer proxyServer;

    public void start(WebSocketService webSocketService) {
        this.webSocketService = webSocketService;
        if (webSocketService.isProxyEnabled()) {
            this.proxyServer = new WSProxyServer(webSocketService.getPort());
            this.proxyServer.start();
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketEngine.class, (String)"PROXY_SERVER_PORT", (Object)webSocketService.getPort()));
            this.isRunning = true;
            return;
        }
        if (webSocketService.isNormalPortListenerEnabled() && webSocketService.getPort() != 0) {
            this.serverSocketChannelFuture = this.createSocketConnection(this.serverSocketChannelFuture, webSocketService.getPort(), false);
        }
        if (webSocketService.isSSLEnabled() && webSocketService.getSSLPort() != 0) {
            this.serverSecureSocketChannelFuture = this.createSocketConnection(this.serverSecureSocketChannelFuture, webSocketService.getSSLPort(), true);
        }
    }

    public void stop() {
        this.isRunning = false;
        if (Objects.nonNull(this.webSocketService) && this.webSocketService.isProxyEnabled() && Objects.nonNull(this.proxyServer)) {
            this.proxyServer.shutdown();
        }
        if (Objects.nonNull(this.serverSocketChannelFuture)) {
            this.serverSocketChannelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        if (Objects.nonNull(this.serverSecureSocketChannelFuture)) {
            this.serverSecureSocketChannelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.releaseResources();
        if (Objects.nonNull(this.webSocketService) && this.webSocketService.isEnterpriseClusterEnabled()) {
            WebSocketClusterManager clusterManager = WebSocketClusterManager.getInstance();
            clusterManager.stopCluster();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void releaseResources() {
        this.parentGroup.shutdownGracefully();
        this.childGroup.shutdownGracefully();
    }

    private ChannelFuture createSocketConnection(ChannelFuture channelFuture, int port, boolean isSSL) {
        this.parentGroup = Objects.isNull(this.parentGroup) ? new NioEventLoopGroup(0, (Executor)Executors.newCachedThreadPool()) : this.parentGroup;
        this.childGroup = Objects.isNull(this.childGroup) ? new NioEventLoopGroup(0, (Executor)Executors.newCachedThreadPool()) : this.childGroup;
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.parentGroup, this.childGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WSNettyPipelineFactory(isSSL));
        try {
            channelFuture = bootstrap.bind((SocketAddress)new InetSocketAddress(port));
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    future.channel().config().setConnectTimeoutMillis(this.webSocketService.getSocketTimeOut() * 1000);
                    CFLogs.SERVER_LOG.info((Object)("WebSocket " + (isSSL ? "Secure (SSL)" : "") + " Server listens on port: " + port));
                    this.isRunning = true;
                } else {
                    this.isRunning = false;
                    CFLogs.SERVER_LOG.error(future.cause());
                    this.releaseResources();
                }
            }));
        }
        catch (ChannelException ex) {
            if (ex.getCause() instanceof BindException) {
                CFLogs.SERVER_LOG.error((Object)RB.getString(WebSocketEngine.class, (String)"PORT_BIND_EXCEPTION", (Object)port));
            }
            this.releaseResources();
        }
        return channelFuture;
    }
}

