/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sqs;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.sqs.SQSAPIException;
import coldfusion.cloud.aws.sqs.SQSAddPermissionMetadata;
import coldfusion.cloud.aws.sqs.SQSChangeMessageVisibilityBatchMetadata;
import coldfusion.cloud.aws.sqs.SQSChangeMessageVisibilityMetadata;
import coldfusion.cloud.aws.sqs.SQSClient;
import coldfusion.cloud.aws.sqs.SQSCreateQueueMetadata;
import coldfusion.cloud.aws.sqs.SQSDeleteMessageBatchMetadata;
import coldfusion.cloud.aws.sqs.SQSDeleteMessageMetadata;
import coldfusion.cloud.aws.sqs.SQSEditQueueTagsMetadata;
import coldfusion.cloud.aws.sqs.SQSGetQueueAtttributesMetadata;
import coldfusion.cloud.aws.sqs.SQSQueue;
import coldfusion.cloud.aws.sqs.SQSQueueImpl;
import coldfusion.cloud.aws.sqs.SQSReceiveMessageMetadata;
import coldfusion.cloud.aws.sqs.SQSSendMessageBatchMetadata;
import coldfusion.cloud.aws.sqs.SQSSendMessageMetadata;
import coldfusion.cloud.aws.sqs.SQSServiceConfig;
import coldfusion.cloud.aws.sqs.SQSSetQueueAtttributesMetadata;
import coldfusion.cloud.aws.sqs.SQSTagQueueMetadata;
import coldfusion.cloud.aws.sqs.SQSUntagQueueMetadata;
import coldfusion.cloud.aws.sqs.SQSUtils;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.ObjectHandledInvokable;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.AddPermissionResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.TagQueueRequest;
import software.amazon.awssdk.services.sqs.model.TagQueueResponse;
import software.amazon.awssdk.services.sqs.model.UntagQueueRequest;
import software.amazon.awssdk.services.sqs.model.UntagQueueResponse;
import software.amazon.awssdk.utils.StringUtils;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class SQSClientImpl
implements SQSClient,
ObjectHandledInvokable,
NamedInvokable {
    private Logger logger = CFLogs.SERVER_LOG;
    SqsClient sqsClient;
    SqsClientBuilder sqsClientBuilder = SqsClient.builder();
    private TagAttributeList tagAttributeList;
    private static InvokeNamedMethodInvocationMap<SQSClientImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public SQSClientImpl(AWSCredential credential, SQSServiceConfig config) {
        this.logger.debug((Object)"creating sqs client");
        if (StringUtils.isNotBlank((CharSequence)credential.getAccessKeyId())) {
            this.sqsClientBuilder.credentialsProvider(SQSUtils.getAWSCredential(credential));
        }
        if (StringUtils.isNotBlank((CharSequence)credential.getRegion())) {
            this.sqsClientBuilder.region(Region.of((String)credential.getRegion()));
        }
        SQSUtils.configureSQSClientBuilder(this.sqsClientBuilder, config);
        this.sqsClient = (SqsClient)this.sqsClientBuilder.build();
        this.tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.SQS.name());
    }

    @Override
    public SQSQueue createQueue(String queueName) {
        SQSQueueImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createQueue", (boolean)true);
        String statusCode = "Success";
        CreateQueueRequest createQueueRequest = (CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build();
        try {
            CreateQueueResponse createQueueResponse = this.sqsClient.createQueue(createQueueRequest);
            this.logger.debug((Object)("SQS : queue with name " + queueName + " created."));
            res = new SQSQueueImpl(this, createQueueResponse.queueUrl());
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"CreateQueueError", (Object)queueName), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createQueue", null, (Object)statusCode, (String)queueName, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public SQSQueue createQueue(String queueName, Map queueAttributes) {
        SQSQueueImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createQueue", (boolean)true);
        String statusCode = "Success";
        CreateQueueRequest.Builder createQueueRequestBuilder = CreateQueueRequest.builder().queueName(queueName);
        ValidatorFiller.INSTANCE.fillObject((Object)createQueueRequestBuilder, (Map)((Struct)queueAttributes), SQSCreateQueueMetadata.getInstance().getConsumerMap());
        try {
            CreateQueueResponse createQueueResponse = this.sqsClient.createQueue((CreateQueueRequest)createQueueRequestBuilder.build());
            this.logger.debug((Object)("SQS : queue with name " + queueName + " created."));
            res = new SQSQueueImpl(this, createQueueResponse.queueUrl());
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"CreateQueueError", (Object)queueName), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createQueue", null, (Object)statusCode, (String)queueName, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct addPermission(String queueUrl, Map permission) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"addPermission", (boolean)true);
        String statusCode = "Success";
        AddPermissionRequest.Builder addPermissionRequestBuilder = AddPermissionRequest.builder().queueUrl(queueUrl);
        try {
            ValidatorFiller.INSTANCE.fillObject((Object)addPermissionRequestBuilder, (Map)((Struct)permission), SQSAddPermissionMetadata.getInstance().getConsumerMap());
            AddPermissionResponse addPermissionResponse = this.sqsClient.addPermission((AddPermissionRequest)addPermissionRequestBuilder.build());
            this.logger.debug((Object)("SQS : queue " + queueUrl + " added permission."));
            res = this.prepareAddPermissionReponse(addPermissionResponse);
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"AddPermissionError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"addPermission", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareAddPermissionReponse(AddPermissionResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct removePermission(String queueUrl, String permissionLabel) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"removePermission", (boolean)true);
        String statusCode = "Success";
        RemovePermissionRequest removePermissionRequest = (RemovePermissionRequest)RemovePermissionRequest.builder().queueUrl(queueUrl).label(permissionLabel).build();
        try {
            RemovePermissionResponse removePermissionResponse = this.sqsClient.removePermission(removePermissionRequest);
            this.logger.debug((Object)("SQS : queue " + queueUrl + " revoked permission."));
            res = this.prepareRemovePermissionReponse(removePermissionResponse);
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"RemovePermissionError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"removePermission", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareRemovePermissionReponse(RemovePermissionResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct deleteQueue(String queueUrl) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteQueue", (boolean)true);
        String statusCode = "Success";
        DeleteQueueRequest deleteQueueRequest = (DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(queueUrl).build();
        try {
            DeleteQueueResponse deleteQueueResponse = this.sqsClient.deleteQueue(deleteQueueRequest);
            this.logger.debug((Object)("SQS : queue " + queueUrl + " deleted."));
            res = this.prepareDeleteQueueReponse(deleteQueueResponse);
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"DeleteQueueError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteQueue", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareDeleteQueueReponse(DeleteQueueResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct sendMessage(String queueUrl, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"sendMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SendMessageRequest.Builder sendMessageRequestBuilder = SendMessageRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)sendMessageRequestBuilder, (Map)((Struct)message), SQSSendMessageMetadata.getInstance().getConsumerMap());
            SendMessageResponse response = this.sqsClient.sendMessage((SendMessageRequest)sendMessageRequestBuilder.build());
            res = this.prepareSendMessageResponse(response);
            this.logger.debug((Object)("SQS : message sent for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"SendMessageError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"sendMessage", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    public Struct prepareSendMessageResponse(SendMessageResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct receiveMessage(String queueUrl, Map receiveMessageOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"receiveMessage", (boolean)true);
        String statusCode = "Success";
        Struct structResponse = new Struct();
        try {
            ReceiveMessageRequest.Builder receiveMessageRequestBuilder = ReceiveMessageRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)receiveMessageRequestBuilder, (Map)((Struct)receiveMessageOptions), SQSReceiveMessageMetadata.getInstance().getConsumerMap());
            ReceiveMessageResponse response = this.sqsClient.receiveMessage((ReceiveMessageRequest)receiveMessageRequestBuilder.build());
            structResponse = this.prepareReceiveMessageResponse(response);
            this.logger.debug((Object)("SQS : message received from " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"ReceiveMessageError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"receiveMessage", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return structResponse;
    }

    public Struct prepareReceiveMessageResponse(ReceiveMessageResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct purgeQueue(String queueUrl) {
        RequestMonitorEventProcessor.onFunctionStart((String)"purgeQueue", (boolean)true);
        String statusCode = "Success";
        Struct res = new Struct();
        try {
            PurgeQueueRequest.Builder purgeQueueRequestBuilder = PurgeQueueRequest.builder().queueUrl(queueUrl);
            PurgeQueueResponse response = this.sqsClient.purgeQueue((PurgeQueueRequest)purgeQueueRequestBuilder.build());
            res = this.preparePurgeQueueResponse(response);
            this.logger.debug((Object)("SQS : queue purged " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"PurgeQueueError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"purgeQueue", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct preparePurgeQueueResponse(PurgeQueueResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct deleteMessage(String queueUrl, Map message) {
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteMessage", (boolean)true);
        String statusCode = "Success";
        Struct res = new Struct();
        try {
            DeleteMessageRequest.Builder deleteMessageRequestBuilder = DeleteMessageRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)deleteMessageRequestBuilder, (Map)((Struct)message), SQSDeleteMessageMetadata.getInstance().getConsumerMap());
            DeleteMessageResponse response = this.sqsClient.deleteMessage((DeleteMessageRequest)deleteMessageRequestBuilder.build());
            res = this.prepareDeleteMessageResponse(response);
            this.logger.debug((Object)("SQS : message deleted from " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"DeleteMessageError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteMessage", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareDeleteMessageResponse(DeleteMessageResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct sendMessageBatch(String queueUrl, List<Map> messages) {
        RequestMonitorEventProcessor.onFunctionStart((String)"sendMessageBatch", (boolean)true);
        String statusCode = "Success";
        Boolean isBadRequest = false;
        Struct res = new Struct();
        try {
            SendMessageBatchRequest.Builder sendMessageBatchRequestBuilder = SendMessageBatchRequest.builder().queueUrl(queueUrl);
            if (messages != null) {
                ArrayList sendMessageBatchRequestEntries = new ArrayList();
                messages.forEach(entry -> {
                    SendMessageBatchRequestEntry.Builder builder = SendMessageBatchRequestEntry.builder();
                    ValidatorFiller.INSTANCE.fillObject((Object)builder, entry, SQSSendMessageBatchMetadata.getInstance().getConsumerMap());
                    sendMessageBatchRequestEntries.add(builder.build());
                });
                sendMessageBatchRequestBuilder.entries(sendMessageBatchRequestEntries);
                SendMessageBatchResponse response = this.sqsClient.sendMessageBatch((SendMessageBatchRequest)sendMessageBatchRequestBuilder.build());
                res = this.prepareSendMessageBatchResponse(response);
                this.logger.debug((Object)("SQS : sendMessageBatch operation successful for " + queueUrl + "."));
            } else {
                statusCode = "Failure";
                isBadRequest = true;
            }
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"SendMessageBatchError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"sendMessageBatch", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        if (isBadRequest.booleanValue()) {
            throw new FieldValidationFailedException("Field entries cannot be null.");
        }
        return res;
    }

    private Struct prepareSendMessageBatchResponse(SendMessageBatchResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct listQueues() {
        RequestMonitorEventProcessor.onFunctionStart((String)"listQueues", (boolean)true);
        String statusCode = "Success";
        Struct res = new Struct();
        try {
            ListQueuesResponse response = this.sqsClient.listQueues();
            res = this.prepareListQueuesResponse(response);
            this.logger.debug((Object)"SQS : listQueues operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"ListQueuesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listQueues", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct listQueues(String queueNamePrefix) {
        RequestMonitorEventProcessor.onFunctionStart((String)"listQueues", (boolean)true);
        String statusCode = "Success";
        Struct res = new Struct();
        try {
            ListQueuesRequest listQueuesRequest = (ListQueuesRequest)ListQueuesRequest.builder().queueNamePrefix(queueNamePrefix).build();
            ListQueuesResponse response = this.sqsClient.listQueues(listQueuesRequest);
            res = this.prepareListQueuesResponse(response);
            this.logger.debug((Object)"SQS : listQueues operation successful.");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"ListQueuesError"), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listQueues", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListQueuesResponse(ListQueuesResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct deleteMessageBatch(String queueUrl, List<Map> messages) {
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteMessageBatch", (boolean)true);
        String statusCode = "Success";
        Boolean isBadRequest = false;
        Struct res = new Struct();
        try {
            ArrayList deleteMessageBatchRequestEntries = new ArrayList();
            DeleteMessageBatchRequest.Builder deleteMessageBatchRequestBuilder = DeleteMessageBatchRequest.builder().queueUrl(queueUrl);
            if (messages != null) {
                messages.forEach(entry -> {
                    DeleteMessageBatchRequestEntry.Builder builder = DeleteMessageBatchRequestEntry.builder();
                    ValidatorFiller.INSTANCE.fillObject((Object)builder, entry, SQSDeleteMessageBatchMetadata.getInstance().getConsumerMap());
                    deleteMessageBatchRequestEntries.add(builder.build());
                });
                deleteMessageBatchRequestBuilder.entries(deleteMessageBatchRequestEntries);
                DeleteMessageBatchResponse response = this.sqsClient.deleteMessageBatch((DeleteMessageBatchRequest)deleteMessageBatchRequestBuilder.build());
                res = this.prepareDeleteMessageBatchResponse(response);
                this.logger.debug((Object)("SQS : deleteMessageBatch operation successful for " + queueUrl + "."));
            } else {
                statusCode = "Failure";
                isBadRequest = true;
            }
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"DeleteMessageBatchError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteMessageBatch", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        if (isBadRequest.booleanValue()) {
            throw new FieldValidationFailedException("Field entries cannot be null.");
        }
        return res;
    }

    private Struct prepareDeleteMessageBatchResponse(DeleteMessageBatchResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct tagQueue(String queueUrl, Map tags) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"tagQueue", (boolean)true);
        String statusCode = "Success";
        try {
            TagQueueRequest.Builder tagQueueRequestBuilder = TagQueueRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)tagQueueRequestBuilder, (Map)((Struct)tags), SQSTagQueueMetadata.getInstance().getConsumerMap());
            TagQueueResponse response = this.sqsClient.tagQueue((TagQueueRequest)tagQueueRequestBuilder.build());
            res = this.prepareTagQueueResponse(response);
            this.logger.debug((Object)("SQS : tagQueue operation successful for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"TagQueueError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"tagQueue", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareTagQueueResponse(TagQueueResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct untagQueue(String queueUrl, Map tags) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"untagQueue", (boolean)true);
        String statusCode = "Success";
        try {
            UntagQueueRequest.Builder untagQueueRequestBuilder = UntagQueueRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)untagQueueRequestBuilder, (Map)((Struct)tags), SQSUntagQueueMetadata.getInstance().getConsumerMap());
            UntagQueueResponse response = this.sqsClient.untagQueue((UntagQueueRequest)untagQueueRequestBuilder.build());
            res = this.prepareUntagQueueResponse(response);
            this.logger.debug((Object)("SQS : untagQueue operation successful for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"UntagQueueError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"untagQueue", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareUntagQueueResponse(UntagQueueResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct listQueueTags(String queueUrl) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listQueueTags", (boolean)true);
        String statusCode = "Success";
        try {
            ListQueueTagsRequest.Builder listQueueTagsRequestBuilder = ListQueueTagsRequest.builder().queueUrl(queueUrl);
            ListQueueTagsResponse response = this.sqsClient.listQueueTags((ListQueueTagsRequest)listQueueTagsRequestBuilder.build());
            res = this.prepareListQueueTagsResponse(response);
            this.logger.debug((Object)("SQS : listQueueTags operation successful for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"ListQueueTagsError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listQueueTags", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListQueueTagsResponse(ListQueueTagsResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct changeMessageVisibility(String queueUrl, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"changeMessageVisibility", (boolean)true);
        String statusCode = "Success";
        try {
            ChangeMessageVisibilityRequest.Builder changeMessageVisibilityRequestBuilder = ChangeMessageVisibilityRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)changeMessageVisibilityRequestBuilder, (Map)((Struct)message), SQSChangeMessageVisibilityMetadata.getInstance().getConsumerMap());
            ChangeMessageVisibilityResponse response = this.sqsClient.changeMessageVisibility((ChangeMessageVisibilityRequest)changeMessageVisibilityRequestBuilder.build());
            res = this.prepareChangeMessageVisibilityResponse(response);
            this.logger.debug((Object)("SQS : changeMessageVisibility operation successful for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"ChangeMessageVisibilityError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"changeMessageVisibility", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareChangeMessageVisibilityResponse(ChangeMessageVisibilityResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct changeMessageVisibilityBatch(String queueUrl, List<Map> messages) {
        RequestMonitorEventProcessor.onFunctionStart((String)"changeMessageVisibilityBatch", (boolean)true);
        String statusCode = "Success";
        Boolean isBadRequest = false;
        Struct res = new Struct();
        try {
            ArrayList changeMessageVisibilityBatchRequestEntries = new ArrayList();
            ChangeMessageVisibilityBatchRequest.Builder changeMessageVisibilityRequestBuilder = ChangeMessageVisibilityBatchRequest.builder().queueUrl(queueUrl);
            if (messages != null) {
                messages.forEach(entry -> {
                    ChangeMessageVisibilityBatchRequestEntry.Builder builder = ChangeMessageVisibilityBatchRequestEntry.builder();
                    ValidatorFiller.INSTANCE.fillObject((Object)builder, entry, SQSChangeMessageVisibilityBatchMetadata.getInstance().getConsumerMap());
                    changeMessageVisibilityBatchRequestEntries.add(builder.build());
                });
                changeMessageVisibilityRequestBuilder.entries(changeMessageVisibilityBatchRequestEntries);
                ChangeMessageVisibilityBatchResponse response = this.sqsClient.changeMessageVisibilityBatch((ChangeMessageVisibilityBatchRequest)changeMessageVisibilityRequestBuilder.build());
                res = this.prepareChangeMessageVisibilityBatchResponse(response);
                this.logger.debug((Object)("SQS : changeMessageVisibilityBatch operation successful for " + queueUrl + "."));
            } else {
                statusCode = "Failure";
                isBadRequest = true;
            }
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"ChangeMessageVisibilityBatchError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"changeMessageVisibilityBatch", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        if (isBadRequest.booleanValue()) {
            throw new FieldValidationFailedException("Field entries cannot be null.");
        }
        return res;
    }

    private Struct prepareChangeMessageVisibilityBatchResponse(ChangeMessageVisibilityBatchResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct setQueueAttributes(String queueUrl, Map queueAttributes) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"setQueueAttributes", (boolean)true);
        String statusCode = "Success";
        try {
            SetQueueAttributesRequest.Builder setQueueAttributesRequestBuilder = SetQueueAttributesRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)setQueueAttributesRequestBuilder, (Map)((Struct)queueAttributes), SQSSetQueueAtttributesMetadata.getInstance().getConsumerMap());
            SetQueueAttributesResponse response = this.sqsClient.setQueueAttributes((SetQueueAttributesRequest)setQueueAttributesRequestBuilder.build());
            res = this.prepareSetQueueAttributesResponse(response);
            this.logger.debug((Object)("SQS : setQueueAttributes operation successful for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"SetQueueAttributesError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"setQueueAttributes", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareSetQueueAttributesResponse(SetQueueAttributesResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct getQueueAttributes(String queueUrl, Map queueAttributes) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getQueueAttributes", (boolean)true);
        String statusCode = "Success";
        try {
            GetQueueAttributesRequest.Builder getQueueAttributesRequestBuilder = GetQueueAttributesRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)getQueueAttributesRequestBuilder, (Map)((Struct)queueAttributes), SQSGetQueueAtttributesMetadata.getInstance().getConsumerMap());
            GetQueueAttributesResponse response = this.sqsClient.getQueueAttributes((GetQueueAttributesRequest)getQueueAttributesRequestBuilder.build());
            res = this.prepareGetQueueAttributesResponse(response);
            this.logger.debug((Object)("SQS : getQueueAttributes operation successful for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"GetQueueAttributesError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getQueueAttributes", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareGetQueueAttributesResponse(GetQueueAttributesResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public String getQueueUrl(String queueName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getQueueUrl", (boolean)true);
        String statusCode = "Success";
        String res = null;
        GetQueueUrlRequest getQueueUrlRequest = (GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(queueName).build();
        try {
            GetQueueUrlResponse getQueueUrlResponse = this.sqsClient.getQueueUrl(getQueueUrlRequest);
            this.logger.debug((Object)("SQS : GetQueueUrl() successful for " + queueName + ". created."));
            res = getQueueUrlResponse.queueUrl();
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"GetQueueUrlError", (Object)queueName), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getQueueUrl", null, (Object)statusCode, (String)queueName, (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public String getQueueArn(String queueUrl) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getQueueArn", (boolean)true);
        String statusCode = "Success";
        String res = null;
        GetQueueAttributesRequest getQueueAttributesRequest = (GetQueueAttributesRequest)GetQueueAttributesRequest.builder().queueUrl(queueUrl).attributeNamesWithStrings(new String[]{"QueueArn"}).build();
        try {
            GetQueueAttributesResponse getQueueUrlResponse = this.sqsClient.getQueueAttributes(getQueueAttributesRequest);
            this.logger.debug((Object)("SQS : GetQueueArn() successful for " + queueUrl + ". created."));
            res = (String)getQueueUrlResponse.attributesAsStrings().get("QueueArn");
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"GetQueueArnError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getQueueArn", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    @Override
    public Struct listDeadLetterSourceQueues(String queueUrl) {
        RequestMonitorEventProcessor.onFunctionStart((String)"listDeadLetterSourceQueues", (boolean)true);
        String statusCode = "Success";
        Struct res = null;
        ListDeadLetterSourceQueuesRequest listDLSourceQueuesRequest = (ListDeadLetterSourceQueuesRequest)ListDeadLetterSourceQueuesRequest.builder().queueUrl(queueUrl).build();
        try {
            ListDeadLetterSourceQueuesResponse listDLSourceQueuesResponse = this.sqsClient.listDeadLetterSourceQueues(listDLSourceQueuesRequest);
            this.logger.debug((Object)("SQS : listDeadLetterSourceQueues() successful for " + queueUrl + ". created."));
            res = this.prepareListDLSourceQueuesResponse(listDLSourceQueuesResponse);
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"ListDeadLetterSourceQueuesError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listDeadLetterSourceQueues", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    private Struct prepareListDLSourceQueuesResponse(ListDeadLetterSourceQueuesResponse response) {
        return CloudDeserializationUtil.INSTANCE.beanToStruct((Object)response);
    }

    @Override
    public Struct editTags(String queueUrl, Map tags) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"editTags", (boolean)true);
        String statusCode = "Success";
        try {
            UntagQueueRequest.Builder untagRequest = UntagQueueRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)untagRequest, (Map)((Struct)tags), SQSEditQueueTagsMetadata.getInstance().getConsumerMap());
            UntagQueueResponse untagResponse = this.sqsClient.untagQueue((UntagQueueRequest)untagRequest.build());
            this.logger.debug((Object)("SQS : tagQueue operation successful for " + queueUrl + "."));
            TagQueueRequest.Builder tagQueueRequestBuilder = TagQueueRequest.builder().queueUrl(queueUrl);
            ValidatorFiller.INSTANCE.fillObject((Object)tagQueueRequestBuilder, (Map)((Struct)tags), SQSTagQueueMetadata.getInstance().getConsumerMap());
            TagQueueResponse tagResponse = this.sqsClient.tagQueue((TagQueueRequest)tagQueueRequestBuilder.build());
            res = this.prepareTagQueueResponse(tagResponse);
            this.logger.debug((Object)("SQS : tagQueue operation successful for " + queueUrl + "."));
        }
        catch (SdkException ex) {
            statusCode = "Failure";
            throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"TagQueueError", (Object)queueUrl), ex);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"editTags", null, (Object)statusCode, (String)queueUrl.substring(queueUrl.lastIndexOf("/") + 1), (TagAttributeList)this.tagAttributeList);
        }
        return res;
    }

    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        switch (methodName.toLowerCase()) {
            case "createqueue": {
                if (args != null && args.length == 1) {
                    return this.createQueue(Cast._String((Object)args[0]));
                }
                if (args != null && args.length == 2) {
                    return this.createQueue(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"CreateQueueValidationError"));
            }
            case "deletequeue": {
                if (args != null && args.length == 1) {
                    return this.deleteQueue(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"DeleteQueueValidationError"));
            }
            case "addpermission": {
                if (args != null && args.length == 2) {
                    return this.addPermission(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"AddPermissionValidationError"));
            }
            case "removepermission": {
                if (args != null && args.length == 2) {
                    return this.removePermission(Cast._String((Object)args[0]), Cast._String((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"RemovePermissionValidationError"));
            }
            case "purgequeue": {
                if (args != null && args.length == 1) {
                    return this.purgeQueue(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"PurgeValidationError"));
            }
            case "sendmessage": {
                if (args != null && args.length == 2) {
                    return this.sendMessage(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"SendMessageValidationError"));
            }
            case "receivemessage": {
                if (args != null && args.length == 2) {
                    return this.receiveMessage(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"ReceiveMessageValidationError"));
            }
            case "deletemessage": {
                if (args != null && args.length == 2) {
                    return this.deleteMessage(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"DeleteMessageValidationError"));
            }
            case "sendmessagebatch": {
                if (args != null && args.length == 2) {
                    return this.sendMessageBatch(Cast._String((Object)args[0]), Cast._List((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"SendMessageBatchValidationError"));
            }
            case "listqueues": {
                if (args == null || args.length == 0) {
                    return this.listQueues();
                }
                if (args != null && args.length == 1) {
                    return this.listQueues(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"ListQueuesValidationError"));
            }
            case "deletemessagebatch": {
                if (args != null && args.length == 2) {
                    return this.deleteMessageBatch(Cast._String((Object)args[0]), Cast._List((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"DeleteMessageBatchValidationError"));
            }
            case "tagqueue": {
                if (args != null && args.length == 2) {
                    return this.tagQueue(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"TagQueueValidationError"));
            }
            case "untagqueue": {
                if (args != null && args.length == 2) {
                    return this.untagQueue(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"UntagQueueValidationError"));
            }
            case "listqueuetags": {
                if (args != null && args.length == 1) {
                    return this.listQueueTags(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"ListQueueTagsValidationError"));
            }
            case "changemessagevisibility": {
                if (args != null && args.length == 2) {
                    return this.changeMessageVisibility(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"ChangeMessageVisbilityValidationError"));
            }
            case "changemessagevisibilitybatch": {
                if (args != null && args.length == 2) {
                    return this.changeMessageVisibilityBatch(Cast._String((Object)args[0]), Cast._List((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"ChangeMessageVisbilityBatchValidationError"));
            }
            case "setqueueattributes": {
                if (args != null && args.length == 2) {
                    return this.setQueueAttributes(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"SetQueueAttributesValidationError"));
            }
            case "getqueueattributes": {
                if (args != null && args.length == 2) {
                    return this.getQueueAttributes(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"GetQueueAttributesValidationError"));
            }
            case "getqueueurl": {
                if (args != null && args.length == 1) {
                    return this.getQueueUrl(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"GetQueueUrlValidationError"));
            }
            case "getqueuearn": {
                if (args != null && args.length == 1) {
                    return this.getQueueArn(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"GetQueueArnValidationError"));
            }
            case "listdeadlettersourcequeues": {
                if (args != null && args.length == 1) {
                    return this.listDeadLetterSourceQueues(Cast._String((Object)args[0]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"ListDeadLetterSourceQueuesValidationError"));
            }
            case "edittags": {
                if (args != null && args.length == 2) {
                    return this.editTags(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                }
                throw new IllegalArgumentException(RB.getString(SQSClientImpl.class, (String)"EditTagsValidationError"));
            }
        }
        Object val = super.invoke(methodName, args, pageContext);
        if (val != ObjectHandledInvokable.OBJECT_METHOD_NOT_FOUND) {
            return val;
        }
        throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"MethodNotDefinedError", (Object)methodName));
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"createQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueName"}, args);
                    return obj.createQueue(Cast._String((Object)argColl.get((Object)"queueName")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueName", "queueAttributes"}, args);
                    return obj.createQueue(Cast._String((Object)argColl.get((Object)"queueName")), Cast._Map((Object)argColl.get((Object)"queueAttributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"addPermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "permission"}, args);
                    return obj.addPermission(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"permission")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("addPermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"removePermission", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "permissionLabel"}, args);
                    return obj.removePermission(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._String((Object)argColl.get((Object)"permissionLabel")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("removePermission", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl"}, args);
                    return obj.deleteQueue(Cast._String((Object)argColl.get((Object)"queueUrl")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "message"}, args);
                    return obj.sendMessage(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"prepareSendMessageResponse", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"response"}, args);
                    return obj.prepareSendMessageResponse((SendMessageResponse)Cast._castForInvokeGen((Object)argColl.get((Object)"response"), SendMessageResponse.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("prepareSendMessageResponse", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"receiveMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "receiveMessageOptions"}, args);
                    return obj.receiveMessage(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"receiveMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("receiveMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"prepareReceiveMessageResponse", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"response"}, args);
                    return obj.prepareReceiveMessageResponse((ReceiveMessageResponse)Cast._castForInvokeGen((Object)argColl.get((Object)"response"), ReceiveMessageResponse.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("prepareReceiveMessageResponse", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"purgeQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl"}, args);
                    return obj.purgeQueue(Cast._String((Object)argColl.get((Object)"queueUrl")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("purgeQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "message"}, args);
                    return obj.deleteMessage(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "messages"}, args);
                    return obj.sendMessageBatch(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listQueues", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listQueues();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueNamePrefix"}, args);
                    return obj.listQueues(Cast._String((Object)argColl.get((Object)"queueNamePrefix")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listQueues", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteMessageBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "messages"}, args);
                    return obj.deleteMessageBatch(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteMessageBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"tagQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "tags"}, args);
                    return obj.tagQueue(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("tagQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"untagQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "tags"}, args);
                    return obj.untagQueue(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("untagQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listQueueTags", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl"}, args);
                    return obj.listQueueTags(Cast._String((Object)argColl.get((Object)"queueUrl")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listQueueTags", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"changeMessageVisibility", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "message"}, args);
                    return obj.changeMessageVisibility(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("changeMessageVisibility", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"changeMessageVisibilityBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "messages"}, args);
                    return obj.changeMessageVisibilityBatch(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("changeMessageVisibilityBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setQueueAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "queueAttributes"}, args);
                    return obj.setQueueAttributes(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"queueAttributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setQueueAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getQueueAttributes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "queueAttributes"}, args);
                    return obj.getQueueAttributes(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"queueAttributes")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getQueueAttributes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getQueueUrl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueName"}, args);
                    return obj.getQueueUrl(Cast._String((Object)argColl.get((Object)"queueName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getQueueUrl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getQueueArn", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl"}, args);
                    return obj.getQueueArn(Cast._String((Object)argColl.get((Object)"queueUrl")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getQueueArn", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listDeadLetterSourceQueues", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl"}, args);
                    return obj.listDeadLetterSourceQueues(Cast._String((Object)argColl.get((Object)"queueUrl")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listDeadLetterSourceQueues", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"editTags", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queueUrl", "tags"}, args);
                    return obj.editTags(Cast._String((Object)argColl.get((Object)"queueUrl")), Cast._Map((Object)argColl.get((Object)"tags")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("editTags", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"invoke", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"methodName", "args", "pageContext"}, args);
                    return obj.invoke(Cast._String((Object)argColl.get((Object)"methodName")), (Object[])Cast._castForInvokeGen((Object)argColl.get((Object)"args"), Object[].class), (PageContext)Cast._castForInvokeGen((Object)argColl.get((Object)"pageContext"), PageContext.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("invoke", obj);
        });
    }
}

