/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRXmlSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_XML = ".xml";
    private static final String EXTENSION_JRPXML = ".jrpxml";
    public static final JRXmlSaveContributor INSTANCE = new JRXmlSaveContributor();

    public static JRXmlSaveContributor getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(EXTENSION_XML) || name.endsWith(EXTENSION_JRPXML);
    }

    @Override
    public String getDescription() {
        return "XML (*.jrpxml, *.xml)";
    }

    @Override
    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_XML) && !file.getName().endsWith(EXTENSION_JRPXML)) {
            file = new File(file.getAbsolutePath() + EXTENSION_JRPXML);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName()), ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"), 2)) {
            JRXmlExporter exporter = new JRXmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.setParameter(JRXmlExporterParameter.IS_EMBEDDING_IMAGES, Boolean.FALSE);
            exporter.exportReport();
        }
    }
}

