/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.text.CharacterIterator;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class DigestMD5Properties
extends Properties {
    protected static boolean isLWS(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected static void skipLWS(CharacterIterator ci) throws ParseException {
        char c = ci.current();
        while (c != '\uffff' && DigestMD5Properties.isLWS(c)) {
            c = ci.next();
        }
    }

    protected static String readKey(CharacterIterator ci) throws ParseException {
        StringBuffer sb = new StringBuffer();
        DigestMD5Properties.skipLWS(ci);
        char c = ci.current();
        while (c != '\uffff' && c != '=' && !DigestMD5Properties.isLWS(c)) {
            sb.append(c);
            c = ci.next();
        }
        DigestMD5Properties.skipLWS(ci);
        c = ci.current();
        if (c != '=') {
            throw new ParseException("expected '='", ci.getIndex());
        }
        ci.next();
        DigestMD5Properties.skipLWS(ci);
        return sb.toString();
    }

    protected static String readValue(CharacterIterator ci) throws ParseException {
        StringBuffer sb = new StringBuffer();
        char c = ci.current();
        DigestMD5Properties.skipLWS(ci);
        if (c == '\"') {
            c = ci.next();
            while (c != '\uffff' && c != '\"') {
                if (c == '\\') {
                    c = ci.next();
                    if (c != '\uffff') {
                        sb.append(c);
                    }
                } else {
                    sb.append(c);
                }
                c = ci.next();
            }
            if (c != '\"') {
                throw new ParseException("expected '\"'", ci.getIndex());
            }
            c = ci.next();
        } else {
            sb.append(c);
            c = ci.next();
            while (c != '\uffff' && c != ',' && !DigestMD5Properties.isLWS(c)) {
                sb.append(c);
                c = ci.next();
            }
        }
        DigestMD5Properties.skipLWS(ci);
        c = ci.current();
        if (c != '\uffff' && c != ',') {
            throw new ParseException("expected ','", ci.getIndex());
        }
        ci.next();
        DigestMD5Properties.skipLWS(ci);
        return sb.toString();
    }

    public DigestMD5Properties(String s) throws ParseException {
        StringCharacterIterator ci = new StringCharacterIterator(s);
        while (ci.current() != '\uffff') {
            String key = DigestMD5Properties.readKey(ci);
            String value = DigestMD5Properties.readValue(ci);
            this.put(key, value);
        }
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        String s = this.getProperty(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public List getList(String name) {
        String s = this.getProperty(name);
        if (s == null) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(s, " ,");
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }
}

