/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.DeleteType;
import coldfusion.exchange.webservice.CFConversationFilter;
import coldfusion.tagext.net.exchange.ConversationConstants;
import coldfusion.tagext.net.exchange.ConversationTagHelper;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeFilterable;
import coldfusion.tagext.net.exchange.ExchangeTag;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class ExchangeConversationTag
extends ExchangeTag
implements ExchangeFilterable,
ConversationConstants {
    private static final String action_getConversations = "get";
    private static final String action_copy = "copy";
    private static final String action_move = "move";
    private static final String action_setReadState = "setReadState";
    private static HashMap<String, String> validFilterAttributes = new HashMap();
    private CFConversationFilter filterInfo = new CFConversationFilter();
    private String folderId;
    private String uid;
    private String destinationFolderId;
    private DeleteType deleteType = DeleteType.MoveToDeletedItems;
    private boolean isRead;
    private String conversationFolderId;

    @Override
    public void addFilter(String attribName, HashMap values) {
        if (!this.isValidAttributeKey(attribName, validFilterAttributes)) {
            ExchangeExceptions.throwInvalidFilterAttributeKeyException(attribName, "cfexchangeconversation");
        }
        Object value = values.get("value");
        boolean isStringValue = value instanceof String;
        if (attribName.equalsIgnoreCase("MaxRows")) {
            int tmpInt = ExchangeTag.castInt(value, "MaxRows");
            if (tmpInt <= 0 && tmpInt != -1) {
                ExchangeExceptions.throwNonPositiveValueException("MaxRows");
            }
            this.filterInfo.setMaxRows(tmpInt);
        } else if (attribName.equalsIgnoreCase("Categories")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setCategories(value.toString());
        } else if (attribName.equalsIgnoreCase("FlagStatus")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (!this.validateFlagStatus(value.toString())) {
                ExchangeExceptions.throwInvalidFlagStatusException("FlagStatus");
            }
            this.filterInfo.setFlagStatus(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalCategories")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setGlobalCategories(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalFlagStatus")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (!this.validateFlagStatus(value.toString())) {
                ExchangeExceptions.throwInvalidFlagStatusException("FlagStatus");
            }
            this.filterInfo.setGlobalFlagStatus(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalHasAttachments")) {
            this.filterInfo.setGlobalHasAttachments(ExchangeTag.castBoolean(value, "GlobalHasAttachments"));
        } else if (attribName.equalsIgnoreCase("GlobalImportance")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (!this.validateImportance(value.toString())) {
                ExchangeExceptions.throwInvalidImportanceException("GlobalImportance");
            }
            this.filterInfo.setGlobalImportance(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalItemClasses")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setGlobalItemClasses(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalItemIds")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setGlobalItemIds(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalUniqueRecipients")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setGlobalUniqueRecipients(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalUniqueSenders")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setGlobalUniqueSenders(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalUniqueUnreadSenders")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setGlobalUniqueUnreadSenders(value.toString());
        } else if (attribName.equalsIgnoreCase("hasAttachments")) {
            this.filterInfo.setHasAttachments(ExchangeTag.castBoolean(value, "hasAttachments"));
        } else if (attribName.equalsIgnoreCase("Importance")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            if (!this.validateImportance(value.toString())) {
                ExchangeExceptions.throwInvalidImportanceException("Importance");
            }
            this.filterInfo.setImportance(value.toString());
        } else if (attribName.equalsIgnoreCase("ItemClasses")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setItemClasses(value.toString());
        } else if (attribName.equalsIgnoreCase("ItemIds")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setItemIds(value.toString());
        } else if (attribName.equalsIgnoreCase("Topic")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setTopic(value.toString());
        } else if (attribName.equalsIgnoreCase("UniqueRecipients")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setUniqueRecipients(value.toString());
        } else if (attribName.equalsIgnoreCase("UniqueSenders")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setUniqueSenders(value.toString());
        } else if (attribName.equalsIgnoreCase("UniqueUnreadSenders")) {
            if (!isStringValue) {
                ExchangeExceptions.throwInvalidStringValueException(attribName);
            }
            this.filterInfo.setUniqueUnreadSenders(value.toString());
        } else if (attribName.equalsIgnoreCase("GlobalLastDeliveryTime")) {
            Date fromDate = null;
            Date toDate = null;
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromGlobalLastDeliveryTime(fromDate);
                this.filterInfo.setToGlobalLastDeliveryTime(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("GlobalLastDeliveryTime");
            }
        } else if (attribName.equalsIgnoreCase("GlobalMessageCount")) {
            int from = -1;
            int to = -1;
            if (values.containsKey("from") && (from = ExchangeTag.castInt(values.get("from"), "from")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("GlobalMessageCount");
            }
            if (values.containsKey("to") && (to = ExchangeTag.castInt(values.get("to"), "to")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("GlobalMessageCount");
            }
            if (from > to) {
                ExchangeExceptions.throwInvalidAttributeValueException("GlobalMessageCount");
            }
            if (from != -1 || to != -1) {
                this.filterInfo.setFromGlobalMessageCount(from);
                this.filterInfo.setToGlobalMessageCount(to);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributeKeyException("GlobalMessageCount", "cfexchangeconversation");
                }
                ExchangeExceptions.throwInvalidAttributeValueException("GlobalMessageCount");
            }
        } else if (attribName.equalsIgnoreCase("GlobalSize")) {
            int from = -1;
            int to = -1;
            if (values.containsKey("from") && (from = ExchangeTag.castInt(values.get("from"), "from")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("GlobalSize");
            }
            if (values.containsKey("to") && (to = ExchangeTag.castInt(values.get("to"), "to")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("GlobalSize");
            }
            if (from > to) {
                ExchangeExceptions.throwInvalidAttributeValueException("GlobalSize");
            }
            if (from != -1 || to != -1) {
                this.filterInfo.setFromGlobalSize(from);
                this.filterInfo.setToGlobalSize(to);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributeKeyException("GlobalSize", "cfexchangeconversation");
                }
                ExchangeExceptions.throwInvalidAttributeValueException("GlobalSize");
            }
        } else if (attribName.equalsIgnoreCase("GlobalUnreadCount")) {
            int from = -1;
            int to = -1;
            if (values.containsKey("from") && (from = ExchangeTag.castInt(values.get("from"), "from")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("GlobalUnreadCount");
            }
            if (values.containsKey("to") && (to = ExchangeTag.castInt(values.get("to"), "to")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("GlobalUnreadCount");
            }
            if (from > to) {
                ExchangeExceptions.throwInvalidAttributeValueException("GlobalUnreadCount");
            }
            if (from != -1 || to != -1) {
                this.filterInfo.setFromGlobalUnreadCount(from);
                this.filterInfo.setToGlobalUnreadCount(to);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributeKeyException("GlobalUnreadCount", "cfexchangeconversation");
                }
                ExchangeExceptions.throwInvalidAttributeValueException("GlobalUnreadCount");
            }
        } else if (attribName.equalsIgnoreCase("LastDeliveryTime")) {
            Date fromDate = null;
            Date toDate = null;
            if (values.containsKey("from")) {
                fromDate = ExchangeTag.castDate(values.get("from"), "from");
            }
            if (values.containsKey("to")) {
                toDate = ExchangeTag.castDate(values.get("to"), "to");
            }
            if (fromDate != null && toDate != null && toDate.compareTo(fromDate) < 0) {
                ExchangeExceptions.throwInvalidStartEndTimeException();
            }
            if (fromDate != null || toDate != null) {
                this.filterInfo.setFromLastDeliveryTime(fromDate);
                this.filterInfo.setToLastDeliveryTime(toDate);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributesForDateExcpetion();
                }
                ExchangeExceptions.throwInvalidAttributeValueException("LastDeliveryTime");
            }
        } else if (attribName.equalsIgnoreCase("MessageCount")) {
            int from = -1;
            int to = -1;
            if (values.containsKey("from") && (from = ExchangeTag.castInt(values.get("from"), "from")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("MessageCount");
            }
            if (values.containsKey("to") && (to = ExchangeTag.castInt(values.get("to"), "to")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("MessageCount");
            }
            if (from > to) {
                ExchangeExceptions.throwInvalidAttributeValueException("MessageCount");
            }
            if (from != -1 || to != -1) {
                this.filterInfo.setFromMessageCount(from);
                this.filterInfo.setToMessageCount(to);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributeKeyException("MessageCount", "cfexchangeconversation");
                }
                ExchangeExceptions.throwInvalidAttributeValueException("MessageCount");
            }
        } else if (attribName.equalsIgnoreCase("Size")) {
            int from = -1;
            int to = -1;
            if (values.containsKey("from") && (from = ExchangeTag.castInt(values.get("from"), "from")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("Size");
            }
            if (values.containsKey("to") && (to = ExchangeTag.castInt(values.get("to"), "to")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("Size");
            }
            if (from > to) {
                ExchangeExceptions.throwInvalidAttributeValueException("Size");
            }
            if (from != -1 || to != -1) {
                this.filterInfo.setSize(from);
                this.filterInfo.setToSize(to);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributeKeyException("Size", "cfexchangeconversation");
                }
                ExchangeExceptions.throwInvalidAttributeValueException("Size");
            }
        } else if (attribName.equalsIgnoreCase("UnreadCount")) {
            int from = -1;
            int to = -1;
            if (values.containsKey("from") && (from = ExchangeTag.castInt(values.get("from"), "from")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("UnreadCount");
            }
            if (values.containsKey("to") && (to = ExchangeTag.castInt(values.get("to"), "to")) < 0) {
                ExchangeExceptions.throwNonPositiveValueException("UnreadCount");
            }
            if (from > to) {
                ExchangeExceptions.throwInvalidAttributeValueException("UnreadCount");
            }
            if (from != -1 || to != -1) {
                this.filterInfo.setUnreadCount(from);
                this.filterInfo.setToUnreadCount(to);
            } else {
                if (value != null) {
                    ExchangeExceptions.throwInvalidFilterAttributeKeyException("UnreadCount", "cfexchangeconversation");
                }
                ExchangeExceptions.throwInvalidAttributeValueException("UnreadCount");
            }
        }
    }

    private boolean validateFlagStatus(String flagStatus) {
        return flagStatus.equalsIgnoreCase("flagged") || flagStatus.equalsIgnoreCase("notflagged") || flagStatus.equalsIgnoreCase("complete");
    }

    PageContext getPageContext() {
        return this.pageContext;
    }

    CFConversationFilter getFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        if (this.action.equalsIgnoreCase(action_getConversations)) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            ConversationTagHelper.getConversations(this);
        } else if (this.action.equalsIgnoreCase(action_copy)) {
            ConversationTagHelper.copy(this);
        } else if (this.action.equalsIgnoreCase(action_move)) {
            ConversationTagHelper.move(this);
        } else if (this.action.equalsIgnoreCase(action_setReadState)) {
            ConversationTagHelper.setReadState(this);
        } else if (this.action.equalsIgnoreCase("delete")) {
            ConversationTagHelper.delete(this);
        }
        this.release();
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        super.release();
        this.filterInfo = new CFConversationFilter();
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        if (folderId == null || folderId.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("folderId");
        }
        this.folderId = folderId;
    }

    public String getConversationId() {
        return this.uid;
    }

    @Override
    public void setUid(String uid) {
        if (uid == null || uid.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("uid");
        }
        this.uid = uid;
    }

    public String getDestinationFolderId() {
        return this.destinationFolderId;
    }

    public void setDestinationFolderId(String destinationFolderId) {
        if (destinationFolderId == null || destinationFolderId.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("destinationFolderId");
        }
        this.destinationFolderId = destinationFolderId;
    }

    public void setDeleteType(String deleteType) {
        if (deleteType == null || deleteType.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("deletetype");
        }
        this.deleteType = this.stringToDeleteType(deleteType);
    }

    private DeleteType stringToDeleteType(String deleteType) {
        if (deleteType.equalsIgnoreCase(DeleteType.HardDelete.toString())) {
            return DeleteType.HardDelete;
        }
        if (deleteType.equalsIgnoreCase(DeleteType.SoftDelete.toString())) {
            return DeleteType.SoftDelete;
        }
        if (deleteType.equalsIgnoreCase(DeleteType.MoveToDeletedItems.toString())) {
            return DeleteType.MoveToDeletedItems;
        }
        ExchangeExceptions.throwInvalidAttributeValueException("deletetype");
        return null;
    }

    public DeleteType getDeleteType() {
        return this.deleteType;
    }

    public void setIsRead(String isRead) {
        if (isRead == null || isRead.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("isRead");
        }
        this.isRead = ExchangeTag.castBoolean(isRead, "isRead");
    }

    public boolean isRead() {
        return this.isRead;
    }

    static {
        validFilterAttributes.put("Categories".toUpperCase(), "Categories".toUpperCase());
        validFilterAttributes.put("FlagStatus".toUpperCase(), "FlagStatus".toUpperCase());
        validFilterAttributes.put("GlobalCategories".toUpperCase(), "GlobalCategories".toUpperCase());
        validFilterAttributes.put("GlobalFlagStatus".toUpperCase(), "GlobalFlagStatus".toUpperCase());
        validFilterAttributes.put("GlobalHasAttachments".toUpperCase(), "GlobalHasAttachments".toUpperCase());
        validFilterAttributes.put("GlobalImportance".toUpperCase(), "GlobalImportance".toUpperCase());
        validFilterAttributes.put("GlobalItemClasses".toUpperCase(), "GlobalItemClasses".toUpperCase());
        validFilterAttributes.put("GlobalItemIds".toUpperCase(), "GlobalItemIds".toUpperCase());
        validFilterAttributes.put("GlobalLastDeliveryTime".toUpperCase(), "GlobalLastDeliveryTime".toUpperCase());
        validFilterAttributes.put("GlobalMessageCount".toUpperCase(), "GlobalMessageCount".toUpperCase());
        validFilterAttributes.put("GlobalSize".toUpperCase(), "GlobalSize".toUpperCase());
        validFilterAttributes.put("GlobalUniqueRecipients".toUpperCase(), "GlobalUniqueRecipients".toUpperCase());
        validFilterAttributes.put("GlobalUniqueSenders".toUpperCase(), "GlobalUniqueSenders".toUpperCase());
        validFilterAttributes.put("GlobalUniqueUnreadSenders".toUpperCase(), "GlobalUniqueUnreadSenders".toUpperCase());
        validFilterAttributes.put("GlobalUnreadCount".toUpperCase(), "GlobalUnreadCount".toUpperCase());
        validFilterAttributes.put("hasAttachments".toUpperCase(), "hasAttachments".toUpperCase());
        validFilterAttributes.put("Importance".toUpperCase(), "Importance".toUpperCase());
        validFilterAttributes.put("ItemClasses".toUpperCase(), "ItemClasses".toUpperCase());
        validFilterAttributes.put("ItemIds".toUpperCase(), "ItemIds".toUpperCase());
        validFilterAttributes.put("LastDeliveryTime".toUpperCase(), "LastDeliveryTime".toUpperCase());
        validFilterAttributes.put("MessageCount".toUpperCase(), "MessageCount".toUpperCase());
        validFilterAttributes.put("Size".toUpperCase(), "Size".toUpperCase());
        validFilterAttributes.put("Topic".toUpperCase(), "Topic".toUpperCase());
        validFilterAttributes.put("UniqueRecipients".toUpperCase(), "UniqueRecipients".toUpperCase());
        validFilterAttributes.put("UniqueSenders".toUpperCase(), "UniqueSenders".toUpperCase());
        validFilterAttributes.put("UniqueUnreadSenders".toUpperCase(), "UniqueUnreadSenders".toUpperCase());
        validFilterAttributes.put("UnreadCount".toUpperCase(), "UnreadCount".toUpperCase());
        validFilterAttributes.put("value".toUpperCase(), "value".toUpperCase());
        validFilterAttributes.put("from".toUpperCase(), "from".toUpperCase());
        validFilterAttributes.put("to".toUpperCase(), "to".toUpperCase());
        validFilterAttributes.put("uid".toUpperCase(), "uid".toUpperCase());
        validFilterAttributes.put("MaxRows".toUpperCase(), "MaxRows".toUpperCase());
    }
}

