/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.DeleteType;
import coldfusion.exchange.ExchangeAbstractObject;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.ExchangeFolderInfo;
import coldfusion.exchange.ExchangeLoginInfo;
import coldfusion.exchange.ExchangeMailMeeting;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.webservice.AvailabilityData;
import coldfusion.exchange.webservice.CFConversation;
import coldfusion.exchange.webservice.CFConversationFilter;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.EWSException;
import coldfusion.exchange.webservice.EWSOperationException;
import coldfusion.exchange.webservice.EWSUtils;
import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.log.CFLogs;
import coldfusion.runtime.JSONUtils;
import coldfusion.util.MimeTypeUtils;
import coldfusion.util.RB;
import coldfusion.wddx.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.WebProxy;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.enumeration.misc.error.ServiceError;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.property.MapiPropertyType;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.ComparisonMode;
import microsoft.exchange.webservices.data.core.enumeration.search.ContainmentMode;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceResult;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.response.GetItemResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponseCollection;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.Contact;
import microsoft.exchange.webservices.data.core.service.item.Conversation;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.item.MeetingMessage;
import microsoft.exchange.webservices.data.core.service.item.MeetingRequest;
import microsoft.exchange.webservices.data.core.service.item.Task;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.core.service.schema.ContactSchema;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.FolderSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.core.service.schema.MeetingMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.TaskSchema;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.misc.ITraceListener;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.misc.NameResolution;
import microsoft.exchange.webservices.data.misc.NameResolutionCollection;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.misc.availability.AttendeeInfo;
import microsoft.exchange.webservices.data.misc.availability.GetUserAvailabilityResults;
import microsoft.exchange.webservices.data.misc.availability.TimeWindow;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.complex.AttachmentCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddressCollection;
import microsoft.exchange.webservices.data.property.complex.ExtendedProperty;
import microsoft.exchange.webservices.data.property.complex.FileAttachment;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.CalendarView;
import microsoft.exchange.webservices.data.search.ConversationIndexedItemView;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import org.apache.commons.lang.StringUtils;

public class EWSConnection
extends ExchangeConnection {
    private static final String SEARCH_FOLDERS = "Search Folders";
    private static final String ITEM_FIELD_NAME = "item";
    private ExchangeService service = null;
    private boolean isOpen = false;
    private Mailbox delegateMailbox;
    private static final ExtendedPropertyDefinition isRecurringProperty = new ExtendedPropertyDefinition(UUID.fromString("00062002-0000-0000-C000-000000000046"), 33315, MapiPropertyType.Boolean);
    private static final ExtendedPropertyDefinition folderSizeProperty = new ExtendedPropertyDefinition(3592, MapiPropertyType.Long);
    private static final ExtendedPropertyDefinition htmlBodyDescription = new ExtendedPropertyDefinition(4115, MapiPropertyType.Binary);
    private static final PropertySet attachMentPropSet = new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{ItemSchema.Attachments});
    private static final PropertySet appointmentPropSet = new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{AppointmentSchema.Organizer, AppointmentSchema.Body, AppointmentSchema.RequiredAttendees, AppointmentSchema.OptionalAttendees, AppointmentSchema.Subject, AppointmentSchema.Location, AppointmentSchema.Resources, AppointmentSchema.Start, AppointmentSchema.End, AppointmentSchema.DateTimeReceived, AppointmentSchema.Duration, AppointmentSchema.Importance, AppointmentSchema.Sensitivity, AppointmentSchema.HasAttachments, AppointmentSchema.AppointmentType, AppointmentSchema.IsAllDayEvent, AppointmentSchema.LastModifiedTime, AppointmentSchema.IsFromMe, AppointmentSchema.ReminderMinutesBeforeStart, AppointmentSchema.Categories, AppointmentSchema.DateTimeReceived, isRecurringProperty});
    private static final PropertySet messagePropSet = new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{EmailMessageSchema.From, EmailMessageSchema.DateTimeReceived, EmailMessageSchema.DateTimeSent, EmailMessageSchema.ToRecipients, EmailMessageSchema.CcRecipients, EmailMessageSchema.BccRecipients, EmailMessageSchema.Subject, EmailMessageSchema.Body, EmailMessageSchema.Importance, EmailMessageSchema.Sensitivity, EmailMessageSchema.IsRead, EmailMessageSchema.HasAttachments, MeetingMessageSchema.AssociatedAppointmentId, MeetingMessageSchema.ResponseType, EmailMessageSchema.UniqueBody});
    public static final ExtendedPropertyDefinition internetHeadersProperty = new ExtendedPropertyDefinition(125, MapiPropertyType.String);
    private static final Map<String, WellKnownFolderName> wellKnownFolderNamesMap = new HashMap<String, WellKnownFolderName>();
    private static final String authorization = "Authorization";
    private static final String bearer = "Bearer ";
    private static final String anchorMailBox = "X-AnchorMailbox";
    private static final boolean impersonateUser;

    public EWSConnection(ExchangeLoginInfo loginInfo) throws EWSException {
        super(loginInfo);
        this.service = new ExchangeService();
        if (Boolean.getBoolean("coldfusion.exchange.enabletrace")) {
            this.service.setTraceEnabled(true);
            this.service.setTraceFlags(EnumSet.allOf(TraceFlags.class));
            this.service.setTraceListener(new ITraceListener(){

                public void trace(String traceType, String traceMessage) {
                    System.out.println("Type:" + traceType + " Message:" + traceMessage);
                    CFLogs.SERVER_LOG.info((Object)("Type:" + traceType + " Message:" + traceMessage));
                }
            });
        }
        try {
            URI url = new URI(loginInfo.getExchangeUrl());
            this.service.setUrl(url);
            if (null != loginInfo.getProxyHost() && -1 != loginInfo.getPort()) {
                WebProxy webProxy = new WebProxy(loginInfo.getProxyHost().trim(), loginInfo.getProxyPort());
                this.service.setWebProxy(webProxy);
            }
            this.isOpen = true;
        }
        catch (URISyntaxException e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.InvalidExchangeHost", (Object)loginInfo.getExchangeHost()), e);
        }
    }

    public EWSConnection(ExchangeLoginInfo loginInfo, ExchangeVersion exchangeVersion) {
        super(loginInfo);
        this.service = exchangeVersion != null ? new ExchangeService(exchangeVersion) : new ExchangeService();
        if (Boolean.getBoolean("coldfusion.exchange.enabletrace")) {
            this.service.setTraceEnabled(true);
            this.service.setTraceFlags(EnumSet.allOf(TraceFlags.class));
            this.service.setTraceListener(new ITraceListener(){

                public void trace(String traceType, String traceMessage) {
                    System.out.println("Type:" + traceType + " Message:" + traceMessage);
                    CFLogs.SERVER_LOG.info((Object)("Type:" + traceType + " Message:" + traceMessage));
                }
            });
        }
        try {
            URI url = new URI(loginInfo.getExchangeUrl());
            this.service.setUrl(url);
            if (null != loginInfo.getProxyHost() && -1 != loginInfo.getPort()) {
                WebProxy webProxy = new WebProxy(loginInfo.getProxyHost().trim(), loginInfo.getProxyPort());
                this.service.setWebProxy(webProxy);
            }
            this.isOpen = true;
        }
        catch (URISyntaxException e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.InvalidExchangeHost", (Object)loginInfo.getExchangeHost()), e);
        }
    }

    @Override
    public void addContactAttachments(String uid, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
    }

    @Override
    public void addMessageAttachments(String href, String[] fileNames, Object[] inStreams) throws Throwable {
    }

    @Override
    public void addTaskAttachments(String href, String[] fileNames, Object[] inStreams) throws Throwable {
    }

    @Override
    public void closeConnection() {
        this.isOpen = false;
    }

    @Override
    public void createAppointment(ExchangeAppointment apt, boolean sendNotification) throws Throwable {
        try {
            ArrayList<Item> appointments = new ArrayList<Item>();
            Appointment appointmentItem = EWSUtils.createServerAppointment(this.service, apt);
            appointments.add((Item)appointmentItem);
            FolderId calendarFolderId = this.findCalendar(apt);
            if (sendNotification) {
                this.createItem(apt, appointments, calendarFolderId, MessageDisposition.SaveOnly, SendInvitationsMode.SendOnlyToAll);
            } else {
                this.createItem(apt, appointments, calendarFolderId, MessageDisposition.SaveOnly, SendInvitationsMode.SendToNone);
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCreatingAppointments"), e);
        }
    }

    private FolderId getFolderIdForWellKnownFolderName(WellKnownFolderName wellKnownFolder) {
        FolderId folderId = null;
        folderId = null != this.delegateMailbox ? new FolderId(wellKnownFolder, this.delegateMailbox) : new FolderId(wellKnownFolder);
        return folderId;
    }

    @Override
    public void createAppointment(ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        this.createAppointment(apt, sendNotification);
        Item item = Item.bind((ExchangeService)this.service, (ItemId)new ItemId(apt.getId()));
        this.addItemAttachments(item, attachedFileNames, attachedFileContents);
        item.update(ConflictResolutionMode.AutoResolve);
    }

    @Override
    public void createContact(ExchangeContact contact) throws Throwable {
        try {
            ArrayList<Item> contacts = new ArrayList<Item>();
            Contact contactItem = EWSUtils.createServerContact(this.service, contact);
            contacts.add((Item)contactItem);
            this.createItem(contact, contacts, this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Contacts), MessageDisposition.SaveOnly, SendInvitationsMode.SendToNone);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCreatingContact"), e);
        }
    }

    @Override
    public void createContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        this.createContact(ct);
        Item item = Item.bind((ExchangeService)this.service, (ItemId)new ItemId(ct.getId()));
        this.addItemAttachments(item, attachedFileNames, attachedFileContents);
        item.update(ConflictResolutionMode.AutoResolve);
    }

    private void addItemAttachments(Item item, String[] attachedFileNames, Object[] attachedFileContents) {
        if (null != attachedFileNames && null != attachedFileContents) {
            try {
                if (attachedFileNames.length != attachedFileContents.length) {
                    throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.attachmentCountMismatch", (Object[])new Object[]{attachedFileNames.length, attachedFileContents.length}));
                }
                for (int i = 0; i < attachedFileNames.length; ++i) {
                    if (!(attachedFileContents[i] instanceof byte[])) {
                        throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.attachmentInvalidType", (Object[])new Object[]{attachedFileNames[i], attachedFileContents[i]}));
                    }
                    FileAttachment attachment = item.getAttachments().addFileAttachment(attachedFileNames[i], (byte[])attachedFileContents[i]);
                    String mimeType = MimeTypeUtils.guessMimeType((String)attachedFileNames[i]);
                    if (null == mimeType) continue;
                    attachment.setContentType(mimeType);
                }
            }
            catch (Exception e) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorAddingAttachments"));
            }
        }
    }

    @Override
    public void createMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            if (null == msg.getFolder()) {
                msg.setFolder("Inbox");
            }
            ArrayList<Item> items = new ArrayList<Item>();
            EmailMessage message = EWSUtils.createServerMessage(this.service, msg);
            items.add((Item)message);
            FolderId parentFolder = this.getFolderId(msg);
            this.createItem(msg, items, parentFolder, MessageDisposition.SaveOnly, SendInvitationsMode.SendToNone);
            Item item = Item.bind((ExchangeService)this.service, (ItemId)new ItemId(msg.getId()));
            this.addItemAttachments(item, attachedFileNames, attachedFileContents);
            item.update(ConflictResolutionMode.AutoResolve);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCreatingMessage"), e);
        }
    }

    private void createItem(ExchangeAbstractObject exchangeObject, Collection<Item> items, FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode) throws Exception, EWSOperationException, NoSuchFieldException, IllegalAccessException, ServiceLocalException {
        ServiceResponseCollection responses = this.service.createItems(items, parentFolderId, messageDisposition, sendInvitationsMode);
        ServiceResult overallResult = responses.getOverallResult();
        if (overallResult == ServiceResult.Error) {
            ServiceResponse response = responses.getResponseAtIndex(0);
            String errorMessage = response.getErrorMessage();
            ServiceError errorCode = response.getErrorCode();
            Map errorDetails = response.getErrorDetails();
            throw new EWSOperationException(errorCode, errorMessage, errorDetails);
        }
        if (overallResult == ServiceResult.Warning) {
            CFLogs.APPLICATION_LOG.warn((Object)responses.getResponseAtIndex(0).getErrorMessage());
        }
        ServiceResponse response = responses.getResponseAtIndex(0);
        Field field = response.getClass().getDeclaredField(ITEM_FIELD_NAME);
        field.setAccessible(true);
        Item responseItem = (Item)field.get(response);
        ItemId itemId = responseItem.getId();
        exchangeObject.setId(itemId.getUniqueId());
    }

    @Override
    public void createTask(ExchangeTask task) throws Throwable {
        try {
            ArrayList<Item> items = new ArrayList<Item>();
            Task newTask = EWSUtils.createServerTask(this, this.service, task);
            items.add((Item)newTask);
            this.createItem(task, items, this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Tasks), MessageDisposition.SaveOnly, SendInvitationsMode.SendToNone);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCreatingTask"), e);
        }
    }

    @Override
    public void createTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            this.createTask(task);
            Item item = Item.bind((ExchangeService)this.service, (ItemId)new ItemId(task.getId()));
            this.addItemAttachments(item, attachedFileNames, attachedFileContents);
            item.update(ConflictResolutionMode.AutoResolve);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCreatingTask"), e);
        }
    }

    @Override
    public void deleteAppointment(String href) throws Throwable {
    }

    @Override
    public void deleteAppointmentAttachments(String uid, String[] fileNames) throws Throwable {
        try {
            Appointment apt = Appointment.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)attachMentPropSet);
            this.deleteItemAttachments(fileNames, (Item)apt);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingAttachmentFromAppointments"), e);
        }
    }

    @Override
    public void deleteAppointments(String[] uids, boolean notify, String message) throws Throwable {
        try {
            ArrayList<ItemId> itemIDs = new ArrayList<ItemId>();
            for (String uid : uids) {
                itemIDs.add(new ItemId(uid));
            }
            ServiceResponseCollection responses = this.service.bindToItems(itemIDs, PropertySet.IdOnly);
            this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)responses);
            if (responses.getOverallResult() == ServiceResult.Success || responses.getOverallResult() == ServiceResult.Warning) {
                for (GetItemResponse getItemResponse : responses) {
                    Appointment appoinment = (Appointment)getItemResponse.getItem();
                    if (null != appoinment) {
                        if (notify) {
                            appoinment.delete(DeleteMode.HardDelete, SendCancellationsMode.SendOnlyToAll);
                            continue;
                        }
                        appoinment.delete(DeleteMode.HardDelete, SendCancellationsMode.SendToNone);
                        continue;
                    }
                    CFLogs.APPLICATION_LOG.warn((Object)getItemResponse.getErrorMessage());
                }
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingAppointments"), e);
        }
    }

    @Override
    public void deleteContactAttachments(String uid, String[] fileNames) throws Throwable {
        try {
            Contact contact = Contact.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)attachMentPropSet);
            this.deleteItemAttachments(fileNames, (Item)contact);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingAttachmentsFromContact"), e);
        }
    }

    private void deleteItemAttachments(String[] fileNames, Item item) throws Exception {
        List<Object> attachmentNameList = new ArrayList();
        if (null != fileNames) {
            attachmentNameList = Arrays.asList(fileNames);
        }
        AttachmentCollection attachments = item.getAttachments();
        Iterator iterator = attachments.iterator();
        ArrayList<Attachment> attachmentsToBeRemoved = new ArrayList<Attachment>();
        while (iterator.hasNext()) {
            Attachment attachment = (Attachment)iterator.next();
            if (null != fileNames) {
                if (!attachmentNameList.contains(attachment.getName())) continue;
                attachmentsToBeRemoved.add(attachment);
                continue;
            }
            attachmentsToBeRemoved.add(attachment);
        }
        for (Attachment attachment : attachmentsToBeRemoved) {
            attachments.remove(attachment);
        }
        item.update(ConflictResolutionMode.AutoResolve);
    }

    @Override
    public void deleteContacts(String[] uids) throws Throwable {
        try {
            this.deleteItems(uids);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingContacts"), e);
        }
    }

    private void deleteItems(String[] uids) throws Exception, EWSOperationException {
        ArrayList<ItemId> items = new ArrayList<ItemId>();
        for (String uid : uids) {
            items.add(new ItemId(uid));
        }
        ServiceResponseCollection responses = this.service.deleteItems(items, DeleteMode.HardDelete, SendCancellationsMode.SendToNone, AffectedTaskOccurrence.AllOccurrences);
        ServiceResult overallResult = responses.getOverallResult();
        if (overallResult == ServiceResult.Error) {
            ServiceResponse response = responses.getResponseAtIndex(0);
            String errorMessage = response.getErrorMessage();
            ServiceError errorCode = response.getErrorCode();
            Map errorDetails = response.getErrorDetails();
            throw new EWSOperationException(errorCode, errorMessage, errorDetails);
        }
        if (overallResult == ServiceResult.Warning) {
            CFLogs.APPLICATION_LOG.warn((Object)responses.getResponseAtIndex(0).getErrorMessage());
        }
    }

    @Override
    public void deleteMessageAttachments(String uid, String[] fileNames) throws Throwable {
        try {
            EmailMessage message = EmailMessage.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)attachMentPropSet);
            this.deleteItemAttachments(fileNames, (Item)message);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingAttachmentsFromMessage"), e);
        }
    }

    @Override
    public void deleteMessageAttachments(String uid, String[] fileNames, String messageFolder) throws Throwable {
        this.deleteMessageAttachments(uid, fileNames);
    }

    @Override
    public void deleteMessages(String[] uids) throws Throwable {
        try {
            this.deleteItems(uids);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingMessages"), e);
        }
    }

    @Override
    public void deleteMessages(String[] uids, String messageFolder) throws Throwable {
        this.deleteMessages(uids);
    }

    @Override
    public void deleteTaskAttachments(String uid, String[] fileNames) throws Throwable {
        try {
            Task task = Task.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)attachMentPropSet);
            this.deleteItemAttachments(fileNames, (Item)task);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingAttachmentsFromTask"), e);
        }
    }

    @Override
    public void deleteTasks(String[] uids) throws Throwable {
        try {
            ArrayList<ItemId> items = new ArrayList<ItemId>();
            for (String uid : uids) {
                items.add(new ItemId(uid));
            }
            ServiceResponseCollection responses = this.service.deleteItems(items, DeleteMode.HardDelete, SendCancellationsMode.SendToNone, AffectedTaskOccurrence.AllOccurrences);
            ServiceResult overallResult = responses.getOverallResult();
            if (overallResult == ServiceResult.Error) {
                ServiceResponse response = responses.getResponseAtIndex(0);
                String errorMessage = response.getErrorMessage();
                ServiceError errorCode = response.getErrorCode();
                Map errorDetails = response.getErrorDetails();
                throw new EWSOperationException(errorCode, errorMessage, errorDetails);
            }
            if (overallResult == ServiceResult.Warning) {
                CFLogs.APPLICATION_LOG.warn((Object)responses.getResponseAtIndex(0).getErrorMessage());
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingTasks"), e);
        }
    }

    @Override
    public ArrayList getAppointmentAttachments(String uid, boolean getContent) throws Throwable {
        try {
            if (uid == null) {
                return null;
            }
            Appointment appointment = Appointment.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{AppointmentSchema.Attachments}));
            ArrayList<ExchangeAttachment> result = new ArrayList<ExchangeAttachment>();
            this.getAttachments((Item)appointment, result);
            return result;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingAttachmentsFromAppointment"), e);
        }
    }

    @Override
    public ArrayList getAppointments(AppointmentFilterInfo filter) throws Throwable {
        try {
            ArrayList<ExchangeAppointment> appointments = new ArrayList<ExchangeAppointment>();
            String id = filter.getUids();
            if (null != id) {
                String[] splits;
                ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
                for (String uid : splits = id.split("\\,")) {
                    itemIds.add(new ItemId(uid));
                }
                ServiceResponseCollection collection = this.service.bindToItems(itemIds, appointmentPropSet);
                this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)collection);
                for (GetItemResponse getItemResponse : collection) {
                    Appointment appointment = (Appointment)getItemResponse.getItem();
                    appointments.add(EWSUtils.createCFAppointment(appointment));
                }
            } else {
                SearchFilter.SearchFilterCollection searchFilter = EWSUtils.createSearchFilter(filter);
                if (filter.getMaxRows() == -1) {
                    int defaultPageSize = 100;
                    int offset = 0;
                    FindItemsResults results = null;
                    do {
                        ItemView itemView = new ItemView(defaultPageSize, offset);
                        itemView.setPropertySet(PropertySet.IdOnly);
                        FolderId calendarFolder = this.findCalendar(filter);
                        results = 0 == searchFilter.getCount() ? this.service.findItems(calendarFolder, itemView) : this.service.findItems(calendarFolder, (SearchFilter)searchFilter, itemView);
                        for (Appointment appointment : results) {
                            appointments.add(EWSUtils.createCFAppointment(Appointment.bind((ExchangeService)this.service, (ItemId)appointment.getId(), (PropertySet)appointmentPropSet)));
                        }
                        offset += results.getTotalCount();
                    } while (results.getTotalCount() == defaultPageSize);
                } else {
                    FindItemsResults results = null;
                    ItemView itemView = new ItemView(filter.getMaxRows());
                    FolderId calendarFolder = this.findCalendar(filter);
                    results = 0 == searchFilter.getCount() ? this.service.findItems(calendarFolder, itemView) : this.service.findItems(calendarFolder, (SearchFilter)searchFilter, itemView);
                    for (Appointment appointment : results) {
                        appointments.add(EWSUtils.createCFAppointment(Appointment.bind((ExchangeService)this.service, (ItemId)appointment.getId(), (PropertySet)appointmentPropSet)));
                    }
                }
            }
            return appointments;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingAppointments"), e);
        }
    }

    public FolderId findCalendar(AppointmentFilterInfo filter) throws Exception {
        return this.findCalendar(filter.getCalendarFolderId(), filter.getCalendarFolderPath(), filter.getPathDelimitter());
    }

    public FolderId findCalendar(ExchangeAppointment apt) throws Exception {
        return this.findCalendar(apt.getCalendarFolderId(), apt.getCalendarFolderPath(), apt.getPathDelimitter());
    }

    public FolderId findCalendar(String folderId, String folderPath, String pathRegEx) throws Exception {
        Folder calendarFolder = null;
        String errorMsgKey = "EWSConnection.errorGettingCalendarById";
        String errorMsgArgument = folderId;
        if (folderId != null) {
            calendarFolder = Folder.bind((ExchangeService)this.service, (FolderId)new FolderId(folderId));
        } else if (folderPath != null) {
            calendarFolder = this.getFolder(folderPath, pathRegEx);
            errorMsgKey = "EWSConnection.errorGettingCalendarByPath";
            errorMsgArgument = folderPath;
        }
        if (calendarFolder != null) {
            if (calendarFolder.getFolderClass().equalsIgnoreCase("IPF.Appointment")) {
                return calendarFolder.getId();
            }
            throw new EWSException(RB.getString((Object)this, (String)errorMsgKey, (Object)errorMsgArgument));
        }
        return this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Calendar);
    }

    @Override
    public ArrayList getContactAttachments(String uid, boolean getContent) throws Throwable {
        try {
            if (uid == null) {
                return null;
            }
            Contact contact = Contact.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{ContactSchema.Attachments}));
            ArrayList<ExchangeAttachment> result = new ArrayList<ExchangeAttachment>();
            this.getAttachments((Item)contact, result);
            return result;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingAttachmentsFromContact"), e);
        }
    }

    @Override
    public ArrayList getContacts(ContactFilterInfo filter) throws Throwable {
        try {
            ArrayList<ExchangeContact> contacts = new ArrayList<ExchangeContact>();
            String id = filter.getId();
            PropertySet propertySet = new PropertySet(BasePropertySet.FirstClassProperties, new PropertyDefinitionBase[]{htmlBodyDescription});
            propertySet.setRequestedBodyType(BodyType.Text);
            if (null != id) {
                String[] splits;
                ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
                for (String uid : splits = id.split("\\,")) {
                    itemIds.add(new ItemId(uid));
                }
                ServiceResponseCollection collection = this.service.bindToItems(itemIds, propertySet);
                this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)collection);
                for (GetItemResponse getItemResponse : collection) {
                    Contact contact = (Contact)getItemResponse.getItem();
                    contacts.add(EWSUtils.createCFContact(contact));
                }
            } else {
                SearchFilter.SearchFilterCollection searchFilter = (SearchFilter.SearchFilterCollection)EWSUtils.createSearchFilter(filter);
                if (filter.getMaxRows() == -1) {
                    int defaultPageSize = 100;
                    int newdefaultPageSize = 100;
                    int offset = 0;
                    FindItemsResults results = null;
                    do {
                        if (defaultPageSize < newdefaultPageSize) {
                            defaultPageSize = newdefaultPageSize;
                            contacts = new ArrayList();
                        }
                        ItemView itemView = new ItemView(defaultPageSize, offset);
                        results = 0 == searchFilter.getCount() ? this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Contacts), itemView) : this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Contacts), (SearchFilter)searchFilter, itemView);
                        for (Contact contact : results) {
                            contacts.add(EWSUtils.createCFContact(Contact.bind((ExchangeService)this.service, (ItemId)contact.getId(), (PropertySet)propertySet)));
                        }
                    } while (defaultPageSize < (newdefaultPageSize = results.getTotalCount()));
                } else {
                    FindItemsResults results = null;
                    ItemView itemView = new ItemView(filter.getMaxRows());
                    results = 0 == searchFilter.getCount() ? this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Contacts), itemView) : this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Contacts), (SearchFilter)searchFilter, itemView);
                    for (Contact contact : results) {
                        contacts.add(EWSUtils.createCFContact(Contact.bind((ExchangeService)this.service, (ItemId)contact.getId(), (PropertySet)propertySet)));
                    }
                }
            }
            return contacts;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingContacts"), e);
        }
    }

    private void checkResponseResult(ServiceResponseCollection<GetItemResponse> responses) {
        ServiceResult overallResult = responses.getOverallResult();
        ServiceError errorCode = null;
        Map errorDetails = null;
        if (overallResult == ServiceResult.Error) {
            StringBuilder errorMessage = new StringBuilder();
            for (GetItemResponse response : responses) {
                if (null != response.getItem()) continue;
                errorMessage.append(response.getErrorCode());
                errorMessage.append(" ");
                errorMessage.append(response.getErrorMessage());
                errorCode = response.getErrorCode();
                errorDetails = response.getErrorDetails();
            }
            throw new EWSOperationException(errorCode, errorMessage.toString(), errorDetails);
        }
        if (overallResult == ServiceResult.Warning) {
            CFLogs.APPLICATION_LOG.warn((Object)((GetItemResponse)responses.getResponseAtIndex(0)).getErrorMessage());
        }
    }

    @Override
    public ArrayList getMessageAttachments(String uid, boolean getContent) throws Throwable {
        try {
            if (uid == null) {
                return null;
            }
            EmailMessage message = EmailMessage.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)attachMentPropSet);
            ArrayList<ExchangeAttachment> result = new ArrayList<ExchangeAttachment>();
            this.getAttachments((Item)message, result);
            return result;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingAttachmentsFromMessage"), e);
        }
    }

    private void getAttachments(Item item, ArrayList<ExchangeAttachment> result) throws Exception {
        AttachmentCollection attachments = item.getAttachments();
        for (Attachment attachment : attachments) {
            String contentType;
            String name;
            if (!(attachment instanceof FileAttachment)) continue;
            FileAttachment fileAttachment = (FileAttachment)attachment;
            fileAttachment.load();
            ExchangeAttachment exchangeAttachment = new ExchangeAttachment();
            byte[] content = fileAttachment.getContent();
            if (null != content) {
                exchangeAttachment.setFileContent(new ByteArrayInputStream(content));
                exchangeAttachment.setFileSize(content.length);
            }
            if (null != (name = fileAttachment.getName())) {
                exchangeAttachment.setFileName(name);
            }
            if (null != (contentType = fileAttachment.getContentType())) {
                exchangeAttachment.setMimeType(contentType);
            }
            result.add(exchangeAttachment);
        }
    }

    @Override
    public ArrayList getMessageAttachments(String uid, boolean getContent, String messageFolder) throws Throwable {
        return this.getMessageAttachments(uid, getContent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ArrayList getMessageMeetingInfo(String meetingUID, String mailUID) throws Throwable {
        try {
            ArrayList<ExchangeMailMeeting> messages = new ArrayList<ExchangeMailMeeting>();
            if (null != mailUID) {
                EmailMessage emailMessage = EmailMessage.bind((ExchangeService)this.service, (ItemId)new ItemId(mailUID));
                if (!(emailMessage instanceof MeetingMessage)) throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.mailNotAMeetingMessage", (Object)mailUID));
                MeetingMessage meetingMessage = (MeetingMessage)emailMessage;
                OutParam outParam = new OutParam();
                boolean gotValue = meetingMessage.tryGetProperty((PropertyDefinitionBase)MeetingMessageSchema.AssociatedAppointmentId, outParam);
                if (!gotValue) return messages;
                ItemId associatedCalendarUID = (ItemId)outParam.getParam();
                if (!associatedCalendarUID.getUniqueId().equals(meetingUID)) throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.mailNotAssociatedWithMeetingUID", (Object)meetingUID));
                Appointment associatedAppointment = Appointment.bind((ExchangeService)this.service, (ItemId)new ItemId(meetingUID), (PropertySet)appointmentPropSet);
                messages.add(EWSUtils.createCFExchangeMailMeeting(associatedAppointment));
                return messages;
            } else {
                int defaultPageSize = 100;
                int offset = 0;
                FindItemsResults results = null;
                do {
                    ItemView itemView = new ItemView(defaultPageSize, offset);
                    results = this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Inbox), itemView);
                    Iterator iterator = results.iterator();
                    while (iterator.hasNext()) {
                        EmailMessage emailMessage = EmailMessage.bind((ExchangeService)this.service, (ItemId)((Item)iterator.next()).getId());
                        if (!(emailMessage instanceof MeetingMessage)) continue;
                        MeetingMessage meetingMessage = (MeetingMessage)emailMessage;
                        OutParam outParam = new OutParam();
                        try {
                            ItemId associatedCalendarUID;
                            boolean gotValue = meetingMessage.tryGetProperty((PropertyDefinitionBase)MeetingMessageSchema.AssociatedAppointmentId, outParam);
                            if (!gotValue || !(associatedCalendarUID = (ItemId)outParam.getParam()).getUniqueId().equals(meetingUID)) continue;
                            Appointment associatedAppointment = Appointment.bind((ExchangeService)this.service, (ItemId)new ItemId(meetingUID), (PropertySet)appointmentPropSet);
                            messages.add(EWSUtils.createCFExchangeMailMeeting(associatedAppointment));
                        }
                        catch (Throwable t) {
                            if (!meetingMessage.getAssociatedAppointmentId().getUniqueId().equals(meetingUID)) continue;
                            Appointment associatedAppointment = Appointment.bind((ExchangeService)this.service, (ItemId)new ItemId(meetingUID), (PropertySet)appointmentPropSet);
                            messages.add(EWSUtils.createCFExchangeMailMeeting(associatedAppointment));
                        }
                    }
                    offset += results.getTotalCount();
                } while (results.getTotalCount() == defaultPageSize);
            }
            return messages;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingMeetingMessages"), e);
        }
    }

    @Override
    public ArrayList getMessages(MessageFilterInfo filter) throws Throwable {
        PropertySet messagePropSet = new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{EmailMessageSchema.From, EmailMessageSchema.DateTimeReceived, EmailMessageSchema.DateTimeSent, EmailMessageSchema.ToRecipients, EmailMessageSchema.CcRecipients, EmailMessageSchema.BccRecipients, EmailMessageSchema.Subject, EmailMessageSchema.Body, EmailMessageSchema.Importance, EmailMessageSchema.Sensitivity, EmailMessageSchema.IsRead, EmailMessageSchema.HasAttachments, MeetingMessageSchema.AssociatedAppointmentId, MeetingMessageSchema.ResponseType, EmailMessageSchema.UniqueBody});
        try {
            ArrayList<ExchangeMessage> messages = new ArrayList<ExchangeMessage>();
            String id = filter.getId();
            if (filter.getGetHeaders()) {
                messagePropSet.add((PropertyDefinitionBase)internetHeadersProperty);
            }
            if (null != id) {
                String[] splits;
                ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
                for (String uid : splits = id.split("\\,")) {
                    itemIds.add(new ItemId(uid));
                }
                ServiceResponseCollection collection = this.service.bindToItems(itemIds, messagePropSet);
                this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)collection);
                for (GetItemResponse getItemResponse : collection) {
                    EmailMessage message = (EmailMessage)getItemResponse.getItem();
                    messages.add(EWSUtils.createCFMessage(message));
                }
            } else {
                SearchFilter.SearchFilterCollection searchFilter = EWSUtils.createSearchFilter(filter);
                FolderId parentFolder = this.getFolderId(filter);
                if (filter.getMaxRows() == -1) {
                    int defaultPageSize = 100;
                    int offset = 0;
                    FindItemsResults results = null;
                    do {
                        ItemView itemView = new ItemView(defaultPageSize, offset);
                        results = 0 == searchFilter.getCount() ? this.service.findItems(parentFolder, itemView) : this.service.findItems(parentFolder, (SearchFilter)searchFilter, itemView);
                        for (EmailMessage message : results) {
                            messages.add(EWSUtils.createCFMessage(EmailMessage.bind((ExchangeService)this.service, (ItemId)message.getId(), (PropertySet)messagePropSet)));
                        }
                        offset += results.getTotalCount();
                    } while (results.getTotalCount() == defaultPageSize);
                } else {
                    FindItemsResults results = null;
                    ItemView itemView = new ItemView(filter.getMaxRows().intValue());
                    results = 0 == searchFilter.getCount() ? this.service.findItems(parentFolder, itemView) : this.service.findItems(parentFolder, (SearchFilter)searchFilter, itemView);
                    for (EmailMessage message : results) {
                        messages.add(EWSUtils.createCFMessage(EmailMessage.bind((ExchangeService)this.service, (ItemId)message.getId(), (PropertySet)messagePropSet)));
                    }
                }
            }
            return messages;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingMessages"), e);
        }
    }

    private FolderId getFolderId(ExchangeMessage filter) throws Exception {
        String folderId = filter.getFolderId();
        if (null != folderId) {
            return new FolderId(folderId);
        }
        String folderPath = filter.getFolder();
        if (null == folderPath) {
            return this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Inbox);
        }
        return this.getFolderId(folderPath, "/");
    }

    private FolderId getFolderId(String folder, String pathSeparatorRegex) throws Exception {
        Folder parentFolder = this.getFolder(folder, pathSeparatorRegex);
        return parentFolder.getId();
    }

    private Folder getFolder(String folder, String pathSeparatorRegex) throws Exception {
        FolderId wellKnownFolderId = null;
        wellKnownFolderId = this.checkAndGetWellKnownFolderId(folder);
        if (wellKnownFolderId != null) {
            return Folder.bind((ExchangeService)this.service, (FolderId)wellKnownFolderId);
        }
        if (folder.toUpperCase().startsWith(SEARCH_FOLDERS.toUpperCase() + pathSeparatorRegex)) {
            String[] folderNames = folder.split(pathSeparatorRegex);
            Folder parentFolder = Folder.bind((ExchangeService)this.service, (FolderId)this.getFolderIdForWellKnownFolderName(WellKnownFolderName.SearchFolders));
            for (int i = 1; i < folderNames.length; ++i) {
                String folderName = folderNames[i];
                parentFolder = this.getSpecifiedSubFolder(parentFolder, folderName);
            }
            return parentFolder;
        }
        String[] folderNames = folder.split(pathSeparatorRegex);
        Folder parentFolder = Folder.bind((ExchangeService)this.service, (FolderId)this.getFolderIdForWellKnownFolderName(WellKnownFolderName.MsgFolderRoot));
        for (String folderName : folderNames) {
            parentFolder = this.getSpecifiedSubFolder(parentFolder, folderName);
        }
        return parentFolder;
    }

    private FolderId checkAndGetWellKnownFolderId(String folderName) {
        WellKnownFolderName wellKnownFolderName;
        if (StringUtils.isNotBlank((String)folderName) && (wellKnownFolderName = wellKnownFolderNamesMap.get(folderName = folderName.trim().toUpperCase())) != null) {
            return this.getFolderIdForWellKnownFolderName(wellKnownFolderName);
        }
        return null;
    }

    private Folder getSpecifiedSubFolder(Folder parentFolder, String folderName) throws Exception, ServiceLocalException {
        FolderView view = new FolderView(1);
        FindFoldersResults findFoldersResults = parentFolder.findFolders(this.createSubFolderDisplayNameFilter(folderName.trim()), view);
        if (0 == findFoldersResults.getTotalCount()) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorInvalidFolderPath", (Object[])new Object[]{folderName, parentFolder.getDisplayName()}));
        }
        return (Folder)findFoldersResults.getFolders().get(0);
    }

    private SearchFilter createSubFolderDisplayNameFilter(String folderName) {
        SearchFilter.ContainsSubstring filter = new SearchFilter.ContainsSubstring();
        filter.setPropertyDefinition((PropertyDefinitionBase)FolderSchema.DisplayName);
        filter.setValue(folderName);
        filter.setComparisonMode(ComparisonMode.IgnoreCase);
        filter.setContainmentMode(ContainmentMode.FullString);
        return filter;
    }

    @Override
    public ArrayList getSubFolders(String folderName, boolean recurse) throws Throwable {
        try {
            FolderId folderId = null == folderName || 0 == folderName.trim().length() ? (null != this.delegateMailbox ? new FolderId(WellKnownFolderName.MsgFolderRoot, this.delegateMailbox) : new FolderId(WellKnownFolderName.MsgFolderRoot)) : this.getFolderId(folderName, "/");
            return this.getSubFolders(folderName, folderId, recurse);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingSubFolders"), e);
        }
    }

    private ArrayList getSubFolders(String folderName, FolderId folderId, boolean recurse) throws Exception {
        ArrayList<ExchangeFolderInfo> exchangeFolders = new ArrayList<ExchangeFolderInfo>();
        Folder serverFolder = Folder.bind((ExchangeService)this.service, (FolderId)folderId);
        FindFoldersResults foldersResults = serverFolder.findFolders(new FolderView(100));
        ArrayList folders = foldersResults.getFolders();
        for (Folder folder : folders) {
            ExchangeFolderInfo folderInfo = new ExchangeFolderInfo();
            folderInfo.setFolderName(folder.getDisplayName());
            String folderPath = null != folderName && folderName.trim().length() > 0 ? folderName + "/" + folder.getDisplayName() : folder.getDisplayName();
            folderInfo.setFolderPath(folderPath);
            Folder folderForSize = Folder.bind((ExchangeService)this.service, (FolderId)folder.getId(), (PropertySet)new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{folderSizeProperty}));
            folderInfo.setFolderSize(Integer.parseInt(String.valueOf(((ExtendedProperty)folderForSize.getExtendedPropertiesForService().getPropertyAtIndex(0)).getValue())));
            if (recurse && folder.getChildFolderCount() > 0) {
                folderInfo.setSubFolders(this.getSubFolders(folderPath, folder.getId(), true));
            }
            exchangeFolders.add(folderInfo);
        }
        return exchangeFolders;
    }

    @Override
    public ArrayList getTaskAttachments(String uid, boolean getContent) throws Throwable {
        try {
            if (uid == null) {
                return null;
            }
            Task task = Task.bind((ExchangeService)this.service, (ItemId)new ItemId(uid), (PropertySet)new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{TaskSchema.Attachments}));
            ArrayList<ExchangeAttachment> result = new ArrayList<ExchangeAttachment>();
            this.getAttachments((Item)task, result);
            return result;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingAttachmentsFromTask"), e);
        }
    }

    @Override
    public ArrayList getTasks(TaskFilterInfo filter) throws Throwable {
        try {
            ArrayList<ExchangeTask> tasks = new ArrayList<ExchangeTask>();
            String id = filter.getId();
            if (null != id) {
                String[] splits;
                ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
                for (String uid : splits = id.split("\\,")) {
                    itemIds.add(new ItemId(uid));
                }
                ServiceResponseCollection collection = this.service.bindToItems(itemIds, PropertySet.FirstClassProperties);
                this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)collection);
                for (GetItemResponse getItemResponse : collection) {
                    Task task = (Task)getItemResponse.getItem();
                    tasks.add(EWSUtils.createCFTask(this, task));
                }
            } else {
                SearchFilter.SearchFilterCollection searchFilter = (SearchFilter.SearchFilterCollection)EWSUtils.createSearchFilter(filter);
                if (filter.getMaxRows() == -1) {
                    int defaultPageSize = 100;
                    int offset = 0;
                    FindItemsResults results = null;
                    do {
                        ItemView itemView = new ItemView(defaultPageSize, offset);
                        results = 0 == searchFilter.getCount() ? this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Tasks), itemView) : this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Tasks), (SearchFilter)searchFilter, itemView);
                        for (Task task : results) {
                            tasks.add(EWSUtils.createCFTask(this, Task.bind((ExchangeService)this.service, (ItemId)task.getId())));
                        }
                        offset += results.getTotalCount();
                    } while (results.getTotalCount() == defaultPageSize);
                } else {
                    ItemView itemView = new ItemView(filter.getMaxRows());
                    FindItemsResults results = 0 == searchFilter.getCount() ? this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Tasks), itemView) : this.service.findItems(this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Tasks), (SearchFilter)searchFilter, itemView);
                    for (Task task : results) {
                        tasks.add(EWSUtils.createCFTask(this, Task.bind((ExchangeService)this.service, (ItemId)task.getId())));
                    }
                }
            }
            return tasks;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingTasks"), e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void login() throws Throwable {
        ExchangeLoginInfo loginInfo = this.getLoginInfo();
        String mailBoxName = loginInfo.getMailBoxName();
        String mailId = loginInfo.getMailId();
        String userPassword = loginInfo.getUserPassword();
        String[] passwordParts = userPassword.split("\\.");
        if (passwordParts.length == 3) {
            String base64decoded = "";
            boolean secondaryOauth = false;
            try {
                base64decoded = new String(Base64Encoder.decode((String)passwordParts[0]));
                if (JSONUtils.isJSON((Object)base64decoded)) {
                    secondaryOauth = true;
                }
            }
            catch (Exception e) {
                secondaryOauth = false;
            }
            if (secondaryOauth) {
                this.service.getHttpHeaders().put(authorization, bearer + loginInfo.getUserPassword());
                this.service.getHttpHeaders().put(anchorMailBox, mailId);
                if (impersonateUser) {
                    this.service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.SmtpAddress, mailId));
                }
            } else {
                this.service.setCredentials((ExchangeCredentials)new WebCredentials(mailId, userPassword));
            }
        } else {
            this.service.setCredentials((ExchangeCredentials)new WebCredentials(mailId, userPassword));
        }
        int indexOf = mailId.indexOf("\\");
        try {
            if (-1 == indexOf && !mailBoxName.equalsIgnoreCase(mailId) || -1 != indexOf && !mailId.substring(indexOf + 1).equals(mailBoxName)) {
                NameResolutionCollection collection = this.service.resolveName(mailBoxName);
                if (0 == collection.getCount()) {
                    throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.delegateMailBoxIdCannotBeResolved", (Object[])new Object[]{loginInfo.getMailBoxName()}));
                }
                NameResolution nameResolution = collection.nameResolutionCollection(0);
                this.delegateMailbox = new Mailbox(nameResolution.getMailbox().getAddress(), nameResolution.getMailbox().getRoutingType());
            }
            if (this.delegateMailbox == null) {
                Folder.bind((ExchangeService)this.service, (FolderId)this.getFolderIdForWellKnownFolderName(WellKnownFolderName.Inbox), (PropertySet)PropertySet.IdOnly);
            }
        }
        catch (EWSHttpException e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.Connectionrefused", (Object[])new Object[]{loginInfo.getExchangeHost()}), e);
        }
        catch (ServiceRequestException e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.AccessDenied"), e);
        }
        catch (EWSException e) {
            throw e;
        }
        catch (Exception e) {
            if (mailBoxName != null && mailBoxName.length() == 0 && e.getMessage() != null && e.getMessage().equals("Argument nameToResolve not valid")) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.invalidCredentials"), new RuntimeException("Verify server name, username, and password"));
            }
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.invalidCredentials"), e);
        }
    }

    @Override
    public void logoff() {
        this.service.setCredentials(null);
    }

    @Override
    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, boolean sendNotification) throws Throwable {
        try {
            if (apt == null || apt.getId() == null) {
                return;
            }
            Appointment appointment = Appointment.bind((ExchangeService)this.service, (ItemId)new ItemId(apt.getId()), (PropertySet)appointmentPropSet);
            EWSUtils.setNonNullValues(appointment, apt);
            if (sendNotification) {
                appointment.update(ConflictResolutionMode.AutoResolve, SendInvitationsOrCancellationsMode.SendOnlyToAll);
            } else {
                appointment.update(ConflictResolutionMode.AutoResolve, SendInvitationsOrCancellationsMode.SendToNone);
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingAppointment"), e);
        }
    }

    @Override
    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        this.modifyAppointments(filterInfo, new String[]{apt.getId()}, apt, attachedFileNames, attachedFileContents, sendNotification);
    }

    @Override
    public void modifyAppointments(AppointmentFilterInfo filterInfo, String[] uids, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        try {
            ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
            for (String uid : uids) {
                itemIds.add(new ItemId(uid));
            }
            PropertySet propSet = new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{AppointmentSchema.Organizer, AppointmentSchema.Body, AppointmentSchema.RequiredAttendees, AppointmentSchema.OptionalAttendees, AppointmentSchema.Subject, AppointmentSchema.Location, AppointmentSchema.Resources, AppointmentSchema.Start, AppointmentSchema.End, AppointmentSchema.DateTimeReceived, AppointmentSchema.Duration, AppointmentSchema.Importance, AppointmentSchema.Sensitivity, AppointmentSchema.HasAttachments, AppointmentSchema.AppointmentType, AppointmentSchema.IsAllDayEvent, AppointmentSchema.LastModifiedTime, AppointmentSchema.IsFromMe, AppointmentSchema.ReminderMinutesBeforeStart, AppointmentSchema.Categories, AppointmentSchema.DateTimeReceived, isRecurringProperty, AppointmentSchema.Attachments});
            ServiceResponseCollection results = this.service.bindToItems(itemIds, propSet);
            this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)results);
            for (GetItemResponse response : results) {
                Appointment oldApt = (Appointment)response.getItem();
                EWSUtils.setNonNullValues(oldApt, apt);
                this.addItemAttachments((Item)oldApt, attachedFileNames, attachedFileContents);
                if (sendNotification) {
                    oldApt.update(ConflictResolutionMode.AutoResolve, SendInvitationsOrCancellationsMode.SendOnlyToAll);
                    continue;
                }
                oldApt.update(ConflictResolutionMode.AutoResolve, SendInvitationsOrCancellationsMode.SendToNone);
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingAppointments"), e);
        }
    }

    @Override
    public void modifyContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            Contact oldContact = Contact.bind((ExchangeService)this.service, (ItemId)new ItemId(ct.getId()));
            EWSUtils.setNonNullValues(oldContact, ct);
            this.addItemAttachments((Item)oldContact, attachedFileNames, attachedFileContents);
            oldContact.update(ConflictResolutionMode.AutoResolve);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingContact"), e);
        }
    }

    @Override
    public void modifyContacts(String[] uids, ExchangeContact contact) throws Throwable {
        try {
            ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
            for (String uid : uids) {
                itemIds.add(new ItemId(uid));
            }
            ServiceResponseCollection results = this.service.bindToItems(itemIds, PropertySet.FirstClassProperties);
            this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)results);
            for (GetItemResponse response : results) {
                Contact oldContact = (Contact)response.getItem();
                EWSUtils.setNonNullValues(oldContact, contact);
                oldContact.update(ConflictResolutionMode.AutoResolve);
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingContacts"), e);
        }
    }

    @Override
    public void modifyMessage(ExchangeMessage msg) throws Throwable {
        try {
            if (null == msg || null == msg.getId()) {
                return;
            }
            EmailMessage message = EmailMessage.bind((ExchangeService)this.service, (ItemId)new ItemId(msg.getId()), (PropertySet)messagePropSet);
            if (null == message) {
                throw new EWSException("Could not find the message with UID : " + msg.getId());
            }
            EWSUtils.setNonNullValues(message, msg);
            message.update(ConflictResolutionMode.AutoResolve);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingMessage"), e);
        }
    }

    @Override
    public void modifyMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            if (null == msg || null == msg.getId()) {
                return;
            }
            EmailMessage message = EmailMessage.bind((ExchangeService)this.service, (ItemId)new ItemId(msg.getId()), (PropertySet)messagePropSet);
            if (null == message) {
                throw new EWSException("Could not find the message with UID : " + msg.getId());
            }
            EWSUtils.setNonNullValues(message, msg);
            this.addItemAttachments((Item)message, attachedFileNames, attachedFileContents);
            message.update(ConflictResolutionMode.AutoResolve);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingMessage"), e);
        }
    }

    @Override
    public void modifyTask(ExchangeTask task) throws Throwable {
        try {
            String[] uids;
            String id = task.getId();
            if (null == id || id.trim().length() == 0) {
                return;
            }
            ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
            for (String uid : uids = id.split("\\,")) {
                itemIds.add(new ItemId(uid));
            }
            ServiceResponseCollection tasks = this.service.bindToItems(itemIds, PropertySet.FirstClassProperties);
            this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)tasks);
            for (GetItemResponse getItemResponse : tasks) {
                Task serverTask = (Task)getItemResponse.getItem();
                EWSUtils.setNonNullValues(this, serverTask, task);
                serverTask.update(ConflictResolutionMode.AutoResolve);
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingTask"), e);
        }
    }

    @Override
    public void modifyTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            String[] uids;
            String id = task.getId();
            if (null == id || id.trim().length() == 0) {
                return;
            }
            ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
            for (String uid : uids = id.split("\\,")) {
                itemIds.add(new ItemId(uid));
            }
            ServiceResponseCollection tasks = this.service.bindToItems(itemIds, PropertySet.FirstClassProperties);
            this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)tasks);
            for (GetItemResponse getItemResponse : tasks) {
                Task serverTask = (Task)getItemResponse.getItem();
                EWSUtils.setNonNullValues(this, serverTask, task);
                this.addItemAttachments((Item)serverTask, attachedFileNames, attachedFileContents);
                serverTask.update(ConflictResolutionMode.AutoResolve);
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingTasks"), e);
        }
    }

    @Override
    public void moveMessages(MessageFilterInfo filter, String destinationFolder) throws Throwable {
        try {
            FolderId folderId = this.getFolderId(destinationFolder, "/");
            ArrayList<EmailMessage> messages = new ArrayList<EmailMessage>();
            String id = filter.getId();
            if (null != id) {
                String[] splits;
                ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
                for (String uid : splits = id.split("\\,")) {
                    itemIds.add(new ItemId(uid));
                }
                ServiceResponseCollection collection = this.service.bindToItems(itemIds, PropertySet.IdOnly);
                this.checkResponseResult((ServiceResponseCollection<GetItemResponse>)collection);
                for (GetItemResponse getItemResponse : collection) {
                    EmailMessage message = (EmailMessage)getItemResponse.getItem();
                    messages.add(message);
                }
            } else {
                SearchFilter.SearchFilterCollection searchFilter = EWSUtils.createSearchFilter(filter);
                FolderId parentFolder = this.getFolderId(filter);
                if (filter.getMaxRows() == -1) {
                    int defaultPageSize = 100;
                    int offset = 0;
                    FindItemsResults results = null;
                    do {
                        ItemView itemView = new ItemView(defaultPageSize, offset);
                        itemView.setPropertySet(PropertySet.IdOnly);
                        results = 0 == searchFilter.getCount() ? this.service.findItems(parentFolder, itemView) : this.service.findItems(parentFolder, (SearchFilter)searchFilter, itemView);
                        for (EmailMessage message : results) {
                            messages.add(message);
                        }
                        offset += results.getTotalCount();
                    } while (results.getTotalCount() == defaultPageSize);
                } else {
                    FindItemsResults results = null;
                    ItemView itemView = new ItemView(filter.getMaxRows().intValue());
                    itemView.setPropertySet(PropertySet.IdOnly);
                    results = 0 == searchFilter.getCount() ? this.service.findItems(parentFolder, itemView) : this.service.findItems(parentFolder, (SearchFilter)searchFilter, itemView);
                    for (EmailMessage message : results) {
                        messages.add(message);
                    }
                }
            }
            for (EmailMessage emailMessage : messages) {
                emailMessage.move(folderId);
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorMovingMessages"), e);
        }
    }

    @Override
    public void responseToMeetingRequest(String uid, int responseCode, boolean sendResponse, String responseMessage) throws Throwable {
        try {
            Appointment appointment = Appointment.bind((ExchangeService)this.service, (ItemId)new ItemId(uid));
            if (sendResponse) {
                appointment.setBody(MessageBody.getMessageBodyFromText((String)responseMessage));
            }
            switch (responseCode) {
                case 2: {
                    appointment.acceptTentatively(sendResponse);
                    break;
                }
                case 4: {
                    appointment.decline(sendResponse);
                    break;
                }
                default: {
                    appointment.accept(sendResponse);
                    break;
                }
            }
        }
        catch (Exception ee) {
            try {
                MeetingRequest appointment = MeetingRequest.bind((ExchangeService)this.service, (ItemId)new ItemId(uid));
                if (sendResponse) {
                    appointment.setBody(MessageBody.getMessageBodyFromText((String)responseMessage));
                }
                switch (responseCode) {
                    case 2: {
                        appointment.acceptTentatively(sendResponse);
                        break;
                    }
                    case 4: {
                        appointment.decline(sendResponse);
                        break;
                    }
                    default: {
                        appointment.accept(sendResponse);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorRespondingToRequest"), e);
            }
        }
    }

    @Override
    public void createFolder(String parentFolderId, ExchangeFolderExtendedInfo folder) throws Throwable {
        try {
            Folder serverFolder = EWSUtils.createServerFolder(this.service, folder);
            FolderId parentFolderId2 = new FolderId(parentFolderId);
            serverFolder.save(parentFolderId2);
            folder.setId(serverFolder.getId().getUniqueId());
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCreatingFolder", (Object[])new Object[]{folder.getDisplayName()}), e);
        }
    }

    @Override
    public ExchangeFolder getExchangeFolderInfo(String folderIdentifier, boolean needsResolution, String pathSeparatorRegex) {
        try {
            FolderId uid = null;
            uid = needsResolution ? this.getFolderId(folderIdentifier, pathSeparatorRegex) : new FolderId(folderIdentifier);
            Folder folder = Folder.bind((ExchangeService)this.service, (FolderId)uid);
            return EWSUtils.createCFFolderInfo(this.service, folder);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingFolder", (Object[])new Object[]{folderIdentifier}), e);
        }
    }

    @Override
    public ExchangeFolderExtendedInfo getExchangeExtendedFolderInfo(String folderIdentifier, boolean needsResolution, String pathSeparatorRegex) {
        FolderId uid = null;
        try {
            uid = needsResolution ? this.getFolderId(folderIdentifier, pathSeparatorRegex) : new FolderId(folderIdentifier);
            Folder folder = Folder.bind((ExchangeService)this.service, (FolderId)uid);
            return EWSUtils.createCFExtendedFolderInfo(this.service, folder);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingFolder", (Object[])new Object[]{folderIdentifier}), e);
        }
    }

    @Override
    public ArrayList getSubFolders(String parentFolderId, FolderFilterInfo filter) {
        ArrayList<ExchangeFolderExtendedInfo> subFolders = new ArrayList<ExchangeFolderExtendedInfo>();
        SearchFilter.SearchFilterCollection searchFilter = EWSUtils.createSearchFilter(filter);
        try {
            if (filter.getMaxRows() == -1) {
                FindFoldersResults results;
                int defaultPageSize = 100;
                int offset = 0;
                do {
                    FolderView itemView = new FolderView(defaultPageSize, offset);
                    results = 0 == searchFilter.getCount() ? this.service.findFolders(new FolderId(parentFolderId), itemView) : this.service.findFolders(new FolderId(parentFolderId), (SearchFilter)searchFilter, itemView);
                    for (Folder folder : results) {
                        subFolders.add(EWSUtils.createCFExtendedFolderInfo(this.service, Folder.bind((ExchangeService)this.service, (FolderId)folder.getId())));
                    }
                    offset += results.getTotalCount();
                } while (results.getTotalCount() == defaultPageSize);
            } else {
                FolderView itemView = new FolderView(filter.getMaxRows());
                FindFoldersResults results = 0 == searchFilter.getCount() ? this.service.findFolders(new FolderId(parentFolderId), itemView) : this.service.findFolders(new FolderId(parentFolderId), (SearchFilter)searchFilter, itemView);
                for (Folder folder : results) {
                    subFolders.add(EWSUtils.createCFExtendedFolderInfo(this.service, Folder.bind((ExchangeService)this.service, (FolderId)folder.getId())));
                }
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingSubFolder"), e);
        }
        return subFolders;
    }

    @Override
    public String copyFolder(String sourceFolderId, String destinationFolderId) {
        try {
            Folder sourceFolder = Folder.bind((ExchangeService)this.service, (FolderId)new FolderId(sourceFolderId));
            sourceFolder.copy(new FolderId(destinationFolderId));
            return sourceFolder.getId().getUniqueId();
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCopyingFolder"), e);
        }
    }

    @Override
    public void deleteFolder(String[] folderIds, DeleteType type) {
        for (String folderId : folderIds) {
            try {
                Folder folder = Folder.bind((ExchangeService)this.service, (FolderId)new FolderId(folderId));
                switch (type) {
                    case HardDelete: {
                        folder.delete(DeleteMode.HardDelete);
                        break;
                    }
                    case SoftDelete: {
                        folder.delete(DeleteMode.SoftDelete);
                        break;
                    }
                    case MoveToDeletedItems: {
                        folder.delete(DeleteMode.MoveToDeletedItems);
                        break;
                    }
                    default: {
                        folder.delete(DeleteMode.MoveToDeletedItems);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingFolder"), e);
            }
        }
    }

    @Override
    public String moveFolder(String sourceFolderId, String destinationFolderId) {
        try {
            Folder sourceFolder = Folder.bind((ExchangeService)this.service, (FolderId)new FolderId(sourceFolderId));
            sourceFolder.move(new FolderId(destinationFolderId));
            return sourceFolder.getId().getUniqueId();
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorMovingFolder"), e);
        }
    }

    @Override
    public void updateFolder(String folderId, ExchangeFolderExtendedInfo folder) {
        try {
            Folder serverFolder = Folder.bind((ExchangeService)this.service, (FolderId)new FolderId(folderId));
            EWSUtils.setNonNullValues(serverFolder, folder);
            serverFolder.update();
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorModifyingFolder"), e);
        }
    }

    @Override
    public void emptyFolder(String folderId, DeleteType type, boolean deleteSubFolder) {
        try {
            Folder folder = Folder.bind((ExchangeService)this.service, (FolderId)new FolderId(folderId));
            switch (type) {
                case HardDelete: {
                    folder.empty(DeleteMode.HardDelete, deleteSubFolder);
                    break;
                }
                case SoftDelete: {
                    folder.empty(DeleteMode.SoftDelete, deleteSubFolder);
                    break;
                }
                case MoveToDeletedItems: {
                    folder.empty(DeleteMode.MoveToDeletedItems, deleteSubFolder);
                    break;
                }
                default: {
                    folder.empty(DeleteMode.SoftDelete, deleteSubFolder);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorEmptyingFolder"), e);
        }
    }

    @Override
    public ArrayList getRoomList() {
        ArrayList<EmailAddress> roomList = new ArrayList<EmailAddress>();
        try {
            EmailAddressCollection roomLists = this.service.getRoomLists();
            for (microsoft.exchange.webservices.data.property.complex.EmailAddress emailAddress : roomLists) {
                roomList.add(EWSUtils.createCFEmailAddress(emailAddress));
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingRoomList"), e);
        }
        return roomList;
    }

    @Override
    public ArrayList getRooms(EmailAddress emailAddress) {
        ArrayList<EmailAddress> roomList = new ArrayList<EmailAddress>();
        try {
            microsoft.exchange.webservices.data.property.complex.EmailAddress serverEmailAddress = EWSUtils.createServerEmailAddress(emailAddress);
            Collection rooms = this.service.getRooms(serverEmailAddress);
            for (microsoft.exchange.webservices.data.property.complex.EmailAddress serverAddress : rooms) {
                roomList.add(EWSUtils.createCFEmailAddress(serverAddress));
            }
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingRooms", (Object[])new Object[]{emailAddress.getAddress()}), e);
        }
        return roomList;
    }

    @Override
    public CFUserAvailability getUserAvailability(List<String> attendees, Date startDate, Date endDate, AvailabilityData type) {
        ArrayList<AttendeeInfo> meetingAttendees = new ArrayList<AttendeeInfo>();
        for (String attendee : attendees) {
            meetingAttendees.add(AttendeeInfo.getAttendeeInfoFromString((String)attendee));
        }
        TimeWindow timeWindow = new TimeWindow(startDate, endDate);
        try {
            GetUserAvailabilityResults userAvailability;
            switch (type) {
                case FreeBusy: {
                    userAvailability = this.service.getUserAvailability(meetingAttendees, timeWindow, microsoft.exchange.webservices.data.core.enumeration.availability.AvailabilityData.FreeBusy);
                    break;
                }
                case Suggestions: {
                    userAvailability = this.service.getUserAvailability(meetingAttendees, timeWindow, microsoft.exchange.webservices.data.core.enumeration.availability.AvailabilityData.Suggestions);
                    break;
                }
                case FreeBusyAndSuggestions: {
                    userAvailability = this.service.getUserAvailability(meetingAttendees, timeWindow, microsoft.exchange.webservices.data.core.enumeration.availability.AvailabilityData.FreeBusyAndSuggestions);
                    break;
                }
                default: {
                    userAvailability = this.service.getUserAvailability(meetingAttendees, timeWindow, microsoft.exchange.webservices.data.core.enumeration.availability.AvailabilityData.FreeBusy);
                }
            }
            return EWSUtils.createCFUserAvailability(userAvailability);
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingUserAvailability", (Object[])new Object[]{attendees.toString()}), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ArrayList getConversations(String folderId, CFConversationFilter filter) {
        ArrayList<CFConversation> cfConversations = new ArrayList<CFConversation>();
        try {
            FolderId uid = new FolderId(folderId);
            int defaultPageSize = 100;
            int offset = 0;
            Collection conversations = null;
            boolean recievedReqdNoOfConversations = false;
            do {
                ConversationIndexedItemView view = new ConversationIndexedItemView(defaultPageSize, offset);
                conversations = this.service.findConversation(view, uid);
                for (Conversation conversation : conversations) {
                    CFConversation cfConversation = EWSUtils.createCFConversation(conversation);
                    if (cfConversation.matchFilter(filter)) {
                        cfConversations.add(cfConversation);
                    }
                    if (filter.getMaxRows() == -1 || cfConversations.size() != filter.getMaxRows()) continue;
                    recievedReqdNoOfConversations = true;
                    break;
                }
                if (recievedReqdNoOfConversations) return cfConversations;
                offset += conversations.size();
            } while (conversations.size() == defaultPageSize);
            return cfConversations;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingConversations"), e);
        }
    }

    @Override
    public void copyConversations(String conversationFolderId, String destinationFolderId, String conversationId) {
        CFConversationFilter conversationFilter = new CFConversationFilter();
        conversationFilter.setId(conversationId);
        ArrayList conversations = this.getConversations(conversationFolderId, conversationFilter);
        for (CFConversation conversation : conversations) {
            try {
                conversation.getConversation().copyItemsInConversation(new FolderId(conversationFolderId), new FolderId(destinationFolderId));
            }
            catch (Exception e) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorCopyingConversations"), e);
            }
        }
    }

    @Override
    public void moveConversations(String conversationFolderId, String destinationFolderId, String conversationId) {
        CFConversationFilter conversationFilter = new CFConversationFilter();
        conversationFilter.setId(conversationId);
        ArrayList conversations = this.getConversations(conversationFolderId, conversationFilter);
        for (CFConversation conversation : conversations) {
            try {
                conversation.getConversation().moveItemsInConversation(new FolderId(conversationFolderId), new FolderId(destinationFolderId));
            }
            catch (Exception e) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorMovingConversations"), e);
            }
        }
    }

    @Override
    public void setReadStateToConversations(String conversationFolderId, String conversationId, boolean read) {
        CFConversationFilter conversationFilter = new CFConversationFilter();
        conversationFilter.setId(conversationId);
        ArrayList conversations = this.getConversations(conversationFolderId, conversationFilter);
        for (CFConversation conversation : conversations) {
            try {
                conversation.getConversation().setReadStateForItemsInConversation(new FolderId(conversationFolderId), read);
            }
            catch (Exception e) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorSettingReadStateToConversations"), e);
            }
        }
    }

    @Override
    public void deleteConversations(String conversationFolderId, String conversationId, DeleteType deleteType) {
        CFConversationFilter conversationFilter = new CFConversationFilter();
        conversationFilter.setId(conversationId);
        ArrayList conversations = this.getConversations(conversationFolderId, conversationFilter);
        for (CFConversation conversation : conversations) {
            try {
                switch (deleteType) {
                    case HardDelete: {
                        conversation.getConversation().deleteItems(new FolderId(conversationFolderId), DeleteMode.HardDelete);
                        break;
                    }
                    case SoftDelete: {
                        conversation.getConversation().deleteItems(new FolderId(conversationFolderId), DeleteMode.SoftDelete);
                        break;
                    }
                    case MoveToDeletedItems: {
                        conversation.getConversation().deleteItems(new FolderId(conversationFolderId), DeleteMode.MoveToDeletedItems);
                        break;
                    }
                    default: {
                        conversation.getConversation().deleteItems(new FolderId(conversationFolderId), DeleteMode.MoveToDeletedItems);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorDeletingConversations"), e);
            }
        }
    }

    @Override
    public ArrayList getAppointmentOccurences(AppointmentFilterInfo filter) throws Throwable {
        try {
            ArrayList<ExchangeAppointment> appointments = new ArrayList<ExchangeAppointment>();
            Date startDate = filter.getFromStartTime();
            startDate = EWSUtils.normalizeDate("local2utc", startDate);
            Date endDate = filter.getFromEndTime();
            endDate = EWSUtils.normalizeDate("local2utc", endDate);
            CalendarView calendarView = new CalendarView(startDate, endDate);
            FolderId calendarFolderId = this.findCalendar(filter);
            FindItemsResults allOccurences = this.service.findAppointments(calendarFolderId, calendarView);
            Iterator iterator = allOccurences.iterator();
            PropertySet appointmentPropSet = new PropertySet(BasePropertySet.IdOnly, new PropertyDefinitionBase[]{AppointmentSchema.Organizer, AppointmentSchema.Body, AppointmentSchema.RequiredAttendees, AppointmentSchema.OptionalAttendees, AppointmentSchema.Subject, AppointmentSchema.Location, AppointmentSchema.Resources, AppointmentSchema.Start, AppointmentSchema.End, AppointmentSchema.DateTimeReceived, AppointmentSchema.Duration, AppointmentSchema.Importance, AppointmentSchema.Sensitivity, AppointmentSchema.HasAttachments, AppointmentSchema.AppointmentType, AppointmentSchema.IsAllDayEvent, AppointmentSchema.LastModifiedTime, AppointmentSchema.IsFromMe, AppointmentSchema.ReminderMinutesBeforeStart, AppointmentSchema.Categories, AppointmentSchema.DateTimeReceived, AppointmentSchema.ICalRecurrenceId, isRecurringProperty});
            while (iterator.hasNext()) {
                Appointment appointment = (Appointment)iterator.next();
                appointments.add(EWSUtils.createCFAppointment(Appointment.bind((ExchangeService)this.service, (ItemId)appointment.getId(), (PropertySet)appointmentPropSet)));
            }
            return appointments;
        }
        catch (Exception e) {
            throw new EWSException(RB.getString((Object)this, (String)"EWSConnection.errorGettingAppointments"), e);
        }
    }

    static {
        wellKnownFolderNamesMap.put("CALENDAR", WellKnownFolderName.Calendar);
        wellKnownFolderNamesMap.put("CONTACTS", WellKnownFolderName.Contacts);
        wellKnownFolderNamesMap.put("DELETEDITEMS", WellKnownFolderName.DeletedItems);
        wellKnownFolderNamesMap.put("DELETED ITEMS", WellKnownFolderName.DeletedItems);
        wellKnownFolderNamesMap.put("DRAFTS", WellKnownFolderName.Drafts);
        wellKnownFolderNamesMap.put("INBOX", WellKnownFolderName.Inbox);
        wellKnownFolderNamesMap.put("JOURNAL", WellKnownFolderName.Journal);
        wellKnownFolderNamesMap.put("NOTES", WellKnownFolderName.Notes);
        wellKnownFolderNamesMap.put("OUTBOX", WellKnownFolderName.Outbox);
        wellKnownFolderNamesMap.put("SENTITEMS", WellKnownFolderName.SentItems);
        wellKnownFolderNamesMap.put("SENT ITEMS", WellKnownFolderName.SentItems);
        wellKnownFolderNamesMap.put("TASKS", WellKnownFolderName.Tasks);
        wellKnownFolderNamesMap.put("JUNKEMAIL", WellKnownFolderName.JunkEmail);
        wellKnownFolderNamesMap.put("JUNK EMAIL", WellKnownFolderName.JunkEmail);
        wellKnownFolderNamesMap.put("SEARCHFOLDERS", WellKnownFolderName.SearchFolders);
        wellKnownFolderNamesMap.put("SEARCH FOLDERS", WellKnownFolderName.SearchFolders);
        impersonateUser = Boolean.getBoolean("coldfusion.exchange.setImpersonatedUser");
    }
}

