/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.config;

import coldfusion.azure.blob.ContainerReference;
import coldfusion.azure.blob.config.BlobRetryType;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.util.RB;
import java.util.Objects;

public class RetryConfig {
    BlobRetryType retryPolicyType;
    protected Integer deltaBackoffIntervalInMs;
    protected Integer maximumAttempts;
    private Integer resolvedMaxBackoff;
    private Integer resolvedMinBackoff;

    public BlobRetryType getRetryPolicyType() {
        return this.retryPolicyType;
    }

    public void setRetryPolicyType(BlobRetryType retryPolicyType) {
        this.retryPolicyType = retryPolicyType;
    }

    public void setDeltaBackoffIntervalInMs(int deltaBackoffIntervalInMs) {
        this.deltaBackoffIntervalInMs = deltaBackoffIntervalInMs;
    }

    public void setMaximumAttempts(int maximumAttempts) {
        this.maximumAttempts = maximumAttempts;
    }

    public void setResolvedMaxBackoff(int resolvedMaxBackoff) {
        this.resolvedMaxBackoff = resolvedMaxBackoff;
    }

    public void setResolvedMinBackoff(int resolvedMinBackoff) {
        this.resolvedMinBackoff = resolvedMinBackoff;
    }

    public Integer getDeltaBackoffIntervalInMs() {
        return this.deltaBackoffIntervalInMs;
    }

    public Integer getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public Integer getResolvedMaxBackoff() {
        return this.resolvedMaxBackoff;
    }

    public Integer getResolvedMinBackoff() {
        return this.resolvedMinBackoff;
    }

    public boolean validate() {
        switch (this.retryPolicyType) {
            case NONE: {
                if (!Objects.nonNull(this.deltaBackoffIntervalInMs) && !Objects.nonNull(this.maximumAttempts) && !Objects.nonNull(this.resolvedMaxBackoff) && !Objects.nonNull(this.resolvedMinBackoff)) break;
                throw new ValidationException("deltaBackoffIntervalInMs".concat(",").concat("maximumAttempts").concat(",").concat("resolvedMinBackoff").concat(",").concat("resolvedMaxBackoff").concat(" none of them are required."));
            }
            case EXPONENTIAL: {
                if (RetryConfig.isNonZero(this.resolvedMaxBackoff) && !RetryConfig.isNonZero(this.resolvedMinBackoff)) {
                    throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidRetryBackoff"));
                }
                if (!RetryConfig.isNonZero(this.resolvedMaxBackoff) && RetryConfig.isNonZero(this.resolvedMinBackoff)) {
                    throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidRetryBackoff"));
                }
                if (RetryConfig.isNonZero(this.resolvedMaxBackoff) && RetryConfig.isNonZero(this.resolvedMinBackoff) && this.resolvedMaxBackoff < this.resolvedMinBackoff) {
                    throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidRetryBackoff"));
                }
            }
            case LINEAR: {
                if (RetryConfig.isNonZero(this.deltaBackoffIntervalInMs) && !RetryConfig.isNonZero(this.maximumAttempts)) {
                    throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidDeltaBackoff"));
                }
                if (RetryConfig.isNonZero(this.deltaBackoffIntervalInMs) || !RetryConfig.isNonZero(this.maximumAttempts)) break;
                throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidDeltaBackoff"));
            }
        }
        return true;
    }

    public static boolean isNonZero(Integer value) {
        return Objects.nonNull(value) && value > 0;
    }
}

