/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.provider.newhope;

import java.io.IOException;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.interfaces.NHPublicKey;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;

public class BCNHPublicKey
implements NHPublicKey {
    private static final long serialVersionUID = 1L;
    private final NHPublicKeyParameters params;

    public BCNHPublicKey(NHPublicKeyParameters nHPublicKeyParameters) {
        this.params = nHPublicKeyParameters;
    }

    public BCNHPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.params = new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCNHPublicKey)) {
            return false;
        }
        BCNHPublicKey bCNHPublicKey = (BCNHPublicKey)object;
        return Arrays.areEqual(this.params.getPubData(), bCNHPublicKey.params.getPubData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getPubData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, this.params.getPubData());
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getPublicData() {
        return this.params.getPubData();
    }

    final dda getKeyParams() {
        return this.params;
    }
}

