/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.provider.newhope;

import java.io.IOException;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1OctetString;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DEROctetString;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;
import macromedia.oracleutil.externals.org.bouncycastle.util.Pack;

public class BCNHPrivateKey
implements NHPrivateKey {
    private static final long serialVersionUID = 1L;
    private final NHPrivateKeyParameters params;

    public BCNHPrivateKey(NHPrivateKeyParameters nHPrivateKeyParameters) {
        this.params = nHPrivateKeyParameters;
    }

    public BCNHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.params = new NHPrivateKeyParameters(BCNHPrivateKey.convert(ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets()));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey bCNHPrivateKey = (BCNHPrivateKey)object;
        return Arrays.areEqual(this.params.getSecData(), bCNHPrivateKey.params.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getSecData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = this.params.getSecData();
            byte[] byArray = new byte[sArray.length << 1];
            for (int i2 = 0; i2 != sArray.length; ++i2) {
                Pack.shortToLittleEndian(sArray[i2], byArray, i2 << 1);
            }
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public short[] getSecretData() {
        return this.params.getSecData();
    }

    final dda getKeyParams() {
        return this.params;
    }

    private static short[] convert(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i2 = 0; i2 != sArray.length; ++i2) {
            sArray[i2] = Pack.littleEndianToShort(byArray, i2 << 1);
        }
        return sArray;
    }
}

