/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.Digest;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.Signer;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.MessageSigner;

public class DigestingMessageSigner
implements Signer {
    private final Digest messDigest;
    private final MessageSigner messSigner;
    private boolean forSigning;

    public DigestingMessageSigner(MessageSigner messageSigner, Digest digest) {
        this.messSigner = messageSigner;
        this.messDigest = digest;
    }

    public void init(boolean bl2, dda dda2) {
        this.forSigning = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = dda2 instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)dda2).getParameters() : (AsymmetricKeyParameter)dda2;
        if (bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.messSigner.init(bl2, dda2);
    }

    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray, 0);
        return this.messSigner.generateSignature(byArray);
    }

    public void update(byte by2) {
        this.messDigest.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.messDigest.update(byArray, n2, n3);
    }

    public void reset() {
        this.messDigest.reset();
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray2, 0);
        return this.messSigner.verifySignature(byArray2, byArray);
    }
}

