/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECLookupTable;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.WTauNafMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.custom.sec.SecT239FieldElement;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.custom.sec.SecT239K1Point;
import macromedia.oracleutil.externals.org.bouncycastle.math.raw.Nat256;
import macromedia.oracleutil.externals.org.bouncycastle.util.encoders.Hex;

public class SecT239K1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT239K1_DEFAULT_COORDS = 6;
    protected SecT239K1Point infinity = new SecT239K1Point(this, null, null);

    public SecT239K1Curve() {
        super(239, 158, 0, 0);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decode("2000000000000000000000000000005A79FEC67CB6E91F1C1DA800E478A5"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT239K1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    public int getFieldSize() {
        return 239;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT239FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT239K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT239K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 239;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 158;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        int n4 = 4;
        final long[] lArray = new long[n3 << 2 << 1];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat256.copy64(((SecT239FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n5);
            Nat256.copy64(((SecT239FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n5 += 4);
            n5 += 4;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n3;
            }

            public ECPoint lookup(int n2) {
                long[] lArray3 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    long l2 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 4; ++i3) {
                        int n4 = i3;
                        lArray3[n4] = lArray3[n4] ^ lArray[n32 + i3] & l2;
                        int n5 = i3;
                        lArray2[n5] = lArray2[n5] ^ lArray[n32 + 4 + i3] & l2;
                    }
                    n32 += 8;
                }
                return SecT239K1Curve.this.createRawPoint(new SecT239FieldElement(lArray3), new SecT239FieldElement(lArray2), false);
            }
        };
    }
}

