/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECLookupTable;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.custom.sec.SecP256R1FieldElement;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.custom.sec.SecP256R1Point;
import macromedia.oracleutil.externals.org.bouncycastle.math.raw.Nat256;
import macromedia.oracleutil.externals.org.bouncycastle.util.encoders.Hex;

public class SecP256R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF"));
    private static final int SecP256R1_DEFAULT_COORDS = 2;
    protected SecP256R1Point infinity = new SecP256R1Point(this, null, null);

    public SecP256R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP256R1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP256R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecP256R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecP256R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        int n4 = 8;
        final int[] nArray = new int[n3 << 3 << 1];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat256.copy(((SecP256R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat256.copy(((SecP256R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 8);
            n5 += 8;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n3;
            }

            public ECPoint lookup(int n2) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n5 = i3;
                        nArray3[n5] = nArray3[n5] ^ nArray[n32 + i3] & n4;
                        int n6 = i3;
                        nArray2[n6] = nArray2[n6] ^ nArray[n32 + 8 + i3] & n4;
                    }
                    n32 += 16;
                }
                return SecP256R1Curve.this.createRawPoint(new SecP256R1FieldElement(nArray3), new SecP256R1FieldElement(nArray2), false);
            }
        };
    }
}

