/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.jce.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1OctetString;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DERIA5String;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x509.GeneralName;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x509.GeneralSubtree;
import macromedia.oracleutil.externals.org.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;
import macromedia.oracleutil.externals.org.bouncycastle.util.Integers;
import macromedia.oracleutil.externals.org.bouncycastle.util.Strings;

public class PKIXNameConstraintValidator {
    private Set excludedSubtreesDN = new HashSet();
    private Set excludedSubtreesDNS = new HashSet();
    private Set excludedSubtreesEmail = new HashSet();
    private Set excludedSubtreesURI = new HashSet();
    private Set excludedSubtreesIP = new HashSet();
    private Set permittedSubtreesDN;
    private Set permittedSubtreesDNS;
    private Set permittedSubtreesEmail;
    private Set permittedSubtreesURI;
    private Set permittedSubtreesIP;

    private static boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        for (int i2 = aSN1Sequence2.size() - 1; i2 >= 0; --i2) {
            if (aSN1Sequence2.getObjectAt(i2).equals(aSN1Sequence.getObjectAt(i2))) continue;
            return false;
        }
        return true;
    }

    public void checkPermittedDN(ASN1Sequence aSN1Sequence) throws PKIXNameConstraintValidatorException {
        PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
        pKIXNameConstraintValidator.checkPermittedDN(pKIXNameConstraintValidator.permittedSubtreesDN, aSN1Sequence);
    }

    public void checkExcludedDN(ASN1Sequence aSN1Sequence) throws PKIXNameConstraintValidatorException {
        PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
        pKIXNameConstraintValidator.checkExcludedDN(pKIXNameConstraintValidator.excludedSubtreesDN, aSN1Sequence);
    }

    private final void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) throws PKIXNameConstraintValidatorException {
        if (set == null) {
            return;
        }
        if (set.isEmpty() && aSN1Sequence.size() == 0) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new PKIXNameConstraintValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private final void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) throws PKIXNameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new PKIXNameConstraintValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private final Set intersectDN(Set set, Set set2) {
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(((GeneralSubtree)iterator.next()).getBase().getName().toASN1Primitive());
            if (set == null) {
                if (aSN1Sequence == null) continue;
                hashSet.add(aSN1Sequence);
                continue;
            }
            for (ASN1Sequence aSN1Sequence2 : set) {
                if (PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                    hashSet.add(aSN1Sequence);
                    continue;
                }
                if (!PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
                hashSet.add(aSN1Sequence2);
            }
        }
        return hashSet;
    }

    private final Set unionDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            if (aSN1Sequence == null) {
                return set;
            }
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (PKIXNameConstraintValidator.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    private final Set intersectEmail(Set set, Set set2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = this.extractNameAsString(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string == null) continue;
                hashSet.add(string);
                continue;
            }
            for (String string2 : set) {
                this.intersectEmail(string, string2, hashSet);
            }
        }
        return hashSet;
    }

    private final Set unionEmail(Set set, String string) {
        if (set.isEmpty()) {
            if (string == null) {
                return set;
            }
            set.add(string);
            return set;
        }
        HashSet hashSet = new HashSet();
        for (String string2 : set) {
            this.unionEmail(string2, string, hashSet);
        }
        return hashSet;
    }

    private final Set intersectIP(Set set, Set set2) {
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = ASN1OctetString.getInstance(((GeneralSubtree)iterator.next()).getBase().getName()).getOctets();
            if (set == null) {
                if (byArray == null) continue;
                hashSet.add(byArray);
                continue;
            }
            for (byte[] byArray2 : set) {
                hashSet.addAll(this.intersectIPRange(byArray2, byArray));
            }
        }
        return hashSet;
    }

    private final Set unionIP(Set set, byte[] byArray) {
        if (set.isEmpty()) {
            if (byArray == null) {
                return set;
            }
            set.add(byArray);
            return set;
        }
        HashSet hashSet = new HashSet();
        for (byte[] byArray2 : set) {
            hashSet.addAll(this.unionIPRange(byArray2, byArray));
        }
        return hashSet;
    }

    private final Set unionIPRange(byte[] byArray, byte[] byArray2) {
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        if (Arrays.areEqual(byArray, byArray2)) {
            hashSet.add(byArray);
        } else {
            hashSet.add(byArray);
            hashSet.add(byArray2);
        }
        return hashSet;
    }

    private final Set intersectIPRange(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return Collections.EMPTY_SET;
        }
        byte[][] byArray3 = this.extractIPsAndSubnetMasks(byArray, byArray2);
        byte[] byArray4 = byArray3[0];
        byte[] byArray5 = byArray3[1];
        byte[] byArray6 = byArray3[2];
        byte[] byArray7 = byArray3[3];
        byte[][] byArray8 = this.minMaxIPs(byArray4, byArray5, byArray6, byArray7);
        byte[] byArray9 = PKIXNameConstraintValidator.min(byArray8[1], byArray8[3]);
        byte[] byArray10 = PKIXNameConstraintValidator.max(byArray8[0], byArray8[2]);
        if (PKIXNameConstraintValidator.compareTo(byArray10, byArray9) == 1) {
            return Collections.EMPTY_SET;
        }
        byte[] byArray11 = PKIXNameConstraintValidator.or(byArray8[0], byArray8[2]);
        byte[] byArray12 = PKIXNameConstraintValidator.or(byArray5, byArray7);
        return Collections.singleton(this.ipWithSubnetMask(byArray11, byArray12));
    }

    private final byte[] ipWithSubnetMask(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        byte[] byArray3 = new byte[n2 << 1];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        int n3 = n2;
        System.arraycopy(byArray2, 0, byArray3, n3, n3);
        return byArray3;
    }

    private final byte[][] extractIPsAndSubnetMasks(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length / 2;
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray, n2, byArray4, 0, n2);
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray5, 0, n2);
        System.arraycopy(byArray2, n2, byArray6, 0, n2);
        return new byte[][]{byArray3, byArray4, byArray5, byArray6};
    }

    private final byte[][] minMaxIPs(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = byArray.length;
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        byte[] byArray8 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray5[i2] = (byte)(byArray[i2] & byArray2[i2]);
            byArray6[i2] = (byte)(byArray[i2] & byArray2[i2] | ~byArray2[i2]);
            byArray7[i2] = (byte)(byArray3[i2] & byArray4[i2]);
            byArray8[i2] = (byte)(byArray3[i2] & byArray4[i2] | ~byArray4[i2]);
        }
        return new byte[][]{byArray5, byArray6, byArray7, byArray8};
    }

    private final void checkPermittedEmail(Set set, String string) throws PKIXNameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (String string2 : set) {
            if (!this.emailIsConstrained(string, string2)) continue;
            return;
        }
        if (string.length() == 0 && set.size() == 0) {
            return;
        }
        throw new PKIXNameConstraintValidatorException("Subject email address is not from a permitted subtree.");
    }

    private final void checkExcludedEmail(Set set, String string) throws PKIXNameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (String string2 : set) {
            if (!this.emailIsConstrained(string, string2)) continue;
            throw new PKIXNameConstraintValidatorException("Email address is from an excluded subtree.");
        }
    }

    private final void checkPermittedIP(Set set, byte[] byArray) throws PKIXNameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (byte[] byArray2 : set) {
            if (!this.isIPConstrained(byArray, byArray2)) continue;
            return;
        }
        if (byArray.length == 0 && set.size() == 0) {
            return;
        }
        throw new PKIXNameConstraintValidatorException("IP is not from a permitted subtree.");
    }

    private final void checkExcludedIP(Set set, byte[] byArray) throws PKIXNameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (byte[] byArray2 : set) {
            if (!this.isIPConstrained(byArray, byArray2)) continue;
            throw new PKIXNameConstraintValidatorException("IP is from an excluded subtree.");
        }
    }

    private final boolean isIPConstrained(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        if (n2 != byArray2.length / 2) {
            return false;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, n2, byArray3, 0, n2);
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray4[i2] = (byte)(byArray2[i2] & byArray3[i2]);
            byArray5[i2] = (byte)(byArray[i2] & byArray3[i2]);
        }
        return Arrays.areEqual(byArray4, byArray5);
    }

    private final boolean emailIsConstrained(String string, String string2) {
        String string3 = string;
        String string4 = string3.substring(string3.indexOf(64) + 1);
        if (string2.indexOf(64) != -1) {
            if (string.equalsIgnoreCase(string2)) {
                return true;
            }
            if (string4.equalsIgnoreCase(string2.substring(1))) {
                return true;
            }
        } else if (string2.charAt(0) != '.' ? string4.equalsIgnoreCase(string2) : this.withinDomain(string4, string2)) {
            return true;
        }
        return false;
    }

    private final boolean withinDomain(String string, String string2) {
        String string3 = string2;
        if (string3.startsWith(".")) {
            string3 = string3.substring(1);
        }
        String[] stringArray = Strings.split(string3, '.');
        String[] stringArray2 = Strings.split(string, '.');
        if (stringArray2.length <= stringArray.length) {
            return false;
        }
        int n2 = stringArray2.length - stringArray.length;
        for (int i2 = -1; i2 < stringArray.length; ++i2) {
            if (!(i2 == -1 ? stringArray2[i2 + n2].equals("") : !stringArray[i2].equalsIgnoreCase(stringArray2[i2 + n2]))) continue;
            return false;
        }
        return true;
    }

    private final void checkPermittedDNS(Set set, String string) throws PKIXNameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (String string2 : set) {
            if (!this.withinDomain(string, string2) && !string.equalsIgnoreCase(string2)) continue;
            return;
        }
        if (string.length() == 0 && set.size() == 0) {
            return;
        }
        throw new PKIXNameConstraintValidatorException("DNS is not from a permitted subtree.");
    }

    private final void checkExcludedDNS(Set set, String string) throws PKIXNameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (String string2 : set) {
            if (!this.withinDomain(string, string2) && !string.equalsIgnoreCase(string2)) continue;
            throw new PKIXNameConstraintValidatorException("DNS is from an excluded subtree.");
        }
    }

    private final void unionEmail(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string;
            String string4 = string3.substring(string3.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string4, string2)) {
                    set.add(string2);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string4.equalsIgnoreCase(string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string5 = string2.substring(string.indexOf(64) + 1);
                if (this.withinDomain(string5, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string2);
                } else if (this.withinDomain(string2, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (this.withinDomain(string2, string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string6 = string2.substring(string.indexOf(64) + 1);
            if (string6.equalsIgnoreCase(string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.withinDomain(string, string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        } else {
            set.add(string);
            set.add(string2);
        }
    }

    private final void unionURI(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string;
            String string4 = string3.substring(string3.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string4, string2)) {
                    set.add(string2);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string4.equalsIgnoreCase(string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string5 = string2.substring(string.indexOf(64) + 1);
                if (this.withinDomain(string5, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string2);
                } else if (this.withinDomain(string2, string)) {
                    set.add(string);
                } else {
                    set.add(string);
                    set.add(string2);
                }
            } else if (this.withinDomain(string2, string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string6 = string2.substring(string.indexOf(64) + 1);
            if (string6.equalsIgnoreCase(string)) {
                set.add(string);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.withinDomain(string, string2)) {
                set.add(string2);
            } else {
                set.add(string);
                set.add(string2);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        } else {
            set.add(string);
            set.add(string2);
        }
    }

    private final Set intersectDNS(Set set, Set set2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = this.extractNameAsString(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string == null) continue;
                hashSet.add(string);
                continue;
            }
            for (String string2 : set) {
                if (this.withinDomain(string2, string)) {
                    hashSet.add(string2);
                    continue;
                }
                if (!this.withinDomain(string, string2)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    protected Set unionDNS(Set set, String string) {
        if (set.isEmpty()) {
            if (string == null) {
                return set;
            }
            set.add(string);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : set) {
            if (this.withinDomain(string2, string)) {
                hashSet.add(string);
                continue;
            }
            if (this.withinDomain(string, string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string2);
            hashSet.add(string);
        }
        return hashSet;
    }

    private final void intersectEmail(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string;
            String string4 = string3.substring(string3.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string4, string2)) {
                    set.add(string);
                }
            } else if (string4.equalsIgnoreCase(string2)) {
                set.add(string);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string5 = string2.substring(string.indexOf(64) + 1);
                if (this.withinDomain(string5, string)) {
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else if (this.withinDomain(string2, string)) {
                    set.add(string2);
                }
            } else if (this.withinDomain(string2, string)) {
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string6 = string2;
            String string7 = string6.substring(string6.indexOf(64) + 1);
            if (string7.equalsIgnoreCase(string)) {
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.withinDomain(string, string2)) {
                set.add(string);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        }
    }

    private final void checkExcludedURI(Set set, String string) throws PKIXNameConstraintValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (String string2 : set) {
            if (!this.isUriConstrained(string, string2)) continue;
            throw new PKIXNameConstraintValidatorException("URI is from an excluded subtree.");
        }
    }

    private final Set intersectURI(Set set, Set set2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = this.extractNameAsString(((GeneralSubtree)iterator.next()).getBase());
            if (set == null) {
                if (string == null) continue;
                hashSet.add(string);
                continue;
            }
            for (String string2 : set) {
                this.intersectURI(string2, string, hashSet);
            }
        }
        return hashSet;
    }

    private final Set unionURI(Set set, String string) {
        if (set.isEmpty()) {
            if (string == null) {
                return set;
            }
            set.add(string);
            return set;
        }
        HashSet hashSet = new HashSet();
        for (String string2 : set) {
            this.unionURI(string2, string, hashSet);
        }
        return hashSet;
    }

    private final void intersectURI(String string, String string2, Set set) {
        if (string.indexOf(64) != -1) {
            String string3 = string;
            String string4 = string3.substring(string3.indexOf(64) + 1);
            if (string2.indexOf(64) != -1) {
                if (string.equalsIgnoreCase(string2)) {
                    set.add(string);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string4, string2)) {
                    set.add(string);
                }
            } else if (string4.equalsIgnoreCase(string2)) {
                set.add(string);
            }
        } else if (string.startsWith(".")) {
            if (string2.indexOf(64) != -1) {
                String string5 = string2.substring(string.indexOf(64) + 1);
                if (this.withinDomain(string5, string)) {
                    set.add(string2);
                }
            } else if (string2.startsWith(".")) {
                if (this.withinDomain(string, string2) || string.equalsIgnoreCase(string2)) {
                    set.add(string);
                } else if (this.withinDomain(string2, string)) {
                    set.add(string2);
                }
            } else if (this.withinDomain(string2, string)) {
                set.add(string2);
            }
        } else if (string2.indexOf(64) != -1) {
            String string6 = string2;
            String string7 = string6.substring(string6.indexOf(64) + 1);
            if (string7.equalsIgnoreCase(string)) {
                set.add(string2);
            }
        } else if (string2.startsWith(".")) {
            if (this.withinDomain(string, string2)) {
                set.add(string);
            }
        } else if (string.equalsIgnoreCase(string2)) {
            set.add(string);
        }
    }

    private final void checkPermittedURI(Set set, String string) throws PKIXNameConstraintValidatorException {
        if (set == null) {
            return;
        }
        for (String string2 : set) {
            if (!this.isUriConstrained(string, string2)) continue;
            return;
        }
        if (string.length() == 0 && set.size() == 0) {
            return;
        }
        throw new PKIXNameConstraintValidatorException("URI is not from a permitted subtree.");
    }

    private final boolean isUriConstrained(String string, String string2) {
        String string3 = PKIXNameConstraintValidator.extractHostFromURL(string);
        return !string2.startsWith(".") ? string3.equalsIgnoreCase(string2) : this.withinDomain(string3, string2);
    }

    private static String extractHostFromURL(String string) {
        String string2 = string;
        String string3 = string2.substring(string2.indexOf(58) + 1);
        if (string3.indexOf("//") != -1) {
            String string4 = string3;
            string3 = string4.substring(string4.indexOf("//") + 2);
        }
        if (string3.lastIndexOf(58) != -1) {
            string3 = string3.substring(0, string3.lastIndexOf(58));
        }
        String string5 = string3;
        String string6 = string3 = string5.substring(string5.indexOf(58) + 1);
        string3 = string6.substring(string6.indexOf(64) + 1);
        if (string3.indexOf(47) != -1) {
            string3 = string3.substring(0, string3.indexOf(47));
        }
        return string3;
    }

    public void checkPermitted(GeneralName generalName) throws PKIXNameConstraintValidatorException {
        switch (generalName.getTagNo()) {
            case 1: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkPermittedEmail(pKIXNameConstraintValidator.permittedSubtreesEmail, this.extractNameAsString(generalName));
                break;
            }
            case 2: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkPermittedDNS(pKIXNameConstraintValidator.permittedSubtreesDNS, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 4: {
                this.checkPermittedDN(ASN1Sequence.getInstance(generalName.getName().toASN1Primitive()));
                break;
            }
            case 6: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkPermittedURI(pKIXNameConstraintValidator.permittedSubtreesURI, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 7: {
                byte[] byArray = ASN1OctetString.getInstance(generalName.getName()).getOctets();
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkPermittedIP(pKIXNameConstraintValidator.permittedSubtreesIP, byArray);
            }
        }
    }

    public void checkExcluded(GeneralName generalName) throws PKIXNameConstraintValidatorException {
        switch (generalName.getTagNo()) {
            case 1: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkExcludedEmail(pKIXNameConstraintValidator.excludedSubtreesEmail, this.extractNameAsString(generalName));
                break;
            }
            case 2: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkExcludedDNS(pKIXNameConstraintValidator.excludedSubtreesDNS, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 4: {
                this.checkExcludedDN(ASN1Sequence.getInstance(generalName.getName().toASN1Primitive()));
                break;
            }
            case 6: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkExcludedURI(pKIXNameConstraintValidator.excludedSubtreesURI, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 7: {
                byte[] byArray = ASN1OctetString.getInstance(generalName.getName()).getOctets();
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.checkExcludedIP(pKIXNameConstraintValidator.excludedSubtreesIP, byArray);
            }
        }
    }

    public void intersectPermittedSubtree(GeneralSubtree generalSubtree) {
        this.intersectPermittedSubtree(new GeneralSubtree[]{generalSubtree});
    }

    public void intersectPermittedSubtree(GeneralSubtree[] generalSubtreeArray) {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 != generalSubtreeArray.length; ++i2) {
            GeneralSubtree object = generalSubtreeArray[i2];
            Integer n2 = Integers.valueOf(object.getBase().getTagNo());
            if (hashMap.get(n2) == null) {
                hashMap.put(n2, new HashSet());
            }
            ((Set)hashMap.get(n2)).add(object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            switch ((Integer)entry.getKey()) {
                case 1: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesEmail = pKIXNameConstraintValidator.intersectEmail(pKIXNameConstraintValidator.permittedSubtreesEmail, (Set)entry.getValue());
                    break;
                }
                case 2: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesDNS = pKIXNameConstraintValidator.intersectDNS(pKIXNameConstraintValidator.permittedSubtreesDNS, (Set)entry.getValue());
                    break;
                }
                case 4: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesDN = pKIXNameConstraintValidator.intersectDN(pKIXNameConstraintValidator.permittedSubtreesDN, (Set)entry.getValue());
                    break;
                }
                case 6: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesURI = pKIXNameConstraintValidator.intersectURI(pKIXNameConstraintValidator.permittedSubtreesURI, (Set)entry.getValue());
                    break;
                }
                case 7: {
                    PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                    pKIXNameConstraintValidator.permittedSubtreesIP = pKIXNameConstraintValidator.intersectIP(pKIXNameConstraintValidator.permittedSubtreesIP, (Set)entry.getValue());
                }
            }
        }
    }

    private final String extractNameAsString(GeneralName generalName) {
        return DERIA5String.getInstance(generalName.getName()).getString();
    }

    public void intersectEmptyPermittedSubtree(int n2) {
        switch (n2) {
            case 1: {
                this.permittedSubtreesEmail = new HashSet();
                break;
            }
            case 2: {
                this.permittedSubtreesDNS = new HashSet();
                break;
            }
            case 4: {
                this.permittedSubtreesDN = new HashSet();
                break;
            }
            case 6: {
                this.permittedSubtreesURI = new HashSet();
                break;
            }
            case 7: {
                this.permittedSubtreesIP = new HashSet();
            }
        }
    }

    public void addExcludedSubtree(GeneralSubtree generalSubtree) {
        GeneralName generalName = generalSubtree.getBase();
        switch (generalName.getTagNo()) {
            case 1: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.excludedSubtreesEmail = pKIXNameConstraintValidator.unionEmail(pKIXNameConstraintValidator.excludedSubtreesEmail, this.extractNameAsString(generalName));
                break;
            }
            case 2: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.excludedSubtreesDNS = pKIXNameConstraintValidator.unionDNS(pKIXNameConstraintValidator.excludedSubtreesDNS, this.extractNameAsString(generalName));
                break;
            }
            case 4: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.excludedSubtreesDN = pKIXNameConstraintValidator.unionDN(pKIXNameConstraintValidator.excludedSubtreesDN, (ASN1Sequence)generalName.getName().toASN1Primitive());
                break;
            }
            case 6: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.excludedSubtreesURI = pKIXNameConstraintValidator.unionURI(pKIXNameConstraintValidator.excludedSubtreesURI, this.extractNameAsString(generalName));
                break;
            }
            case 7: {
                PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
                pKIXNameConstraintValidator.excludedSubtreesIP = pKIXNameConstraintValidator.unionIP(pKIXNameConstraintValidator.excludedSubtreesIP, ASN1OctetString.getInstance(generalName.getName()).getOctets());
            }
        }
    }

    private static byte[] max(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((byArray[i2] & 0xFFFF) <= (byArray2[i2] & 0xFFFF)) continue;
            return byArray;
        }
        return byArray2;
    }

    private static byte[] min(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((byArray[i2] & 0xFFFF) >= (byArray2[i2] & 0xFFFF)) continue;
            return byArray;
        }
        return byArray2;
    }

    private static int compareTo(byte[] byArray, byte[] byArray2) {
        if (Arrays.areEqual(byArray, byArray2)) {
            return 0;
        }
        if (Arrays.areEqual(PKIXNameConstraintValidator.max(byArray, byArray2), byArray)) {
            return 1;
        }
        return -1;
    }

    private static byte[] or(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] | byArray2[i2]);
        }
        return byArray3;
    }

    public int hashCode() {
        PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator2 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator3 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator4 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator5 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator6 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator7 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator8 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator9 = this;
        PKIXNameConstraintValidator pKIXNameConstraintValidator10 = this;
        return pKIXNameConstraintValidator.hashCollection(pKIXNameConstraintValidator.excludedSubtreesDN) + pKIXNameConstraintValidator2.hashCollection(pKIXNameConstraintValidator2.excludedSubtreesDNS) + pKIXNameConstraintValidator3.hashCollection(pKIXNameConstraintValidator3.excludedSubtreesEmail) + pKIXNameConstraintValidator4.hashCollection(pKIXNameConstraintValidator4.excludedSubtreesIP) + pKIXNameConstraintValidator5.hashCollection(pKIXNameConstraintValidator5.excludedSubtreesURI) + pKIXNameConstraintValidator6.hashCollection(pKIXNameConstraintValidator6.permittedSubtreesDN) + pKIXNameConstraintValidator7.hashCollection(pKIXNameConstraintValidator7.permittedSubtreesDNS) + pKIXNameConstraintValidator8.hashCollection(pKIXNameConstraintValidator8.permittedSubtreesEmail) + pKIXNameConstraintValidator9.hashCollection(pKIXNameConstraintValidator9.permittedSubtreesIP) + pKIXNameConstraintValidator10.hashCollection(pKIXNameConstraintValidator10.permittedSubtreesURI);
    }

    private final int hashCollection(Collection collection) {
        if (collection == null) {
            return 0;
        }
        int n2 = 0;
        for (Object e2 : collection) {
            if (e2 instanceof byte[]) {
                n2 += Arrays.hashCode((byte[])e2);
                continue;
            }
            n2 += e2.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PKIXNameConstraintValidator)) {
            return false;
        }
        PKIXNameConstraintValidator pKIXNameConstraintValidator = (PKIXNameConstraintValidator)object;
        return this.collectionsAreEqual(pKIXNameConstraintValidator.excludedSubtreesDN, this.excludedSubtreesDN) && this.collectionsAreEqual(pKIXNameConstraintValidator.excludedSubtreesDNS, this.excludedSubtreesDNS) && this.collectionsAreEqual(pKIXNameConstraintValidator.excludedSubtreesEmail, this.excludedSubtreesEmail) && this.collectionsAreEqual(pKIXNameConstraintValidator.excludedSubtreesIP, this.excludedSubtreesIP) && this.collectionsAreEqual(pKIXNameConstraintValidator.excludedSubtreesURI, this.excludedSubtreesURI) && this.collectionsAreEqual(pKIXNameConstraintValidator.permittedSubtreesDN, this.permittedSubtreesDN) && this.collectionsAreEqual(pKIXNameConstraintValidator.permittedSubtreesDNS, this.permittedSubtreesDNS) && this.collectionsAreEqual(pKIXNameConstraintValidator.permittedSubtreesEmail, this.permittedSubtreesEmail) && this.collectionsAreEqual(pKIXNameConstraintValidator.permittedSubtreesIP, this.permittedSubtreesIP) && this.collectionsAreEqual(pKIXNameConstraintValidator.permittedSubtreesURI, this.permittedSubtreesURI);
    }

    private final boolean collectionsAreEqual(Collection collection, Collection collection2) {
        if (collection == collection2) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        for (Object e2 : collection) {
            Iterator iterator = collection2.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                if (!this.equals(e2, e3)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private final boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.areEqual((byte[])object, (byte[])object2);
        }
        return object.equals(object2);
    }

    private final String stringifyIP(byte[] byArray) {
        int n2;
        String string = "";
        for (n2 = 0; n2 < byArray.length / 2; ++n2) {
            string = string + Integer.toString(byArray[n2] & 0xFF) + ".";
        }
        string = string.substring(0, string.length() - 1);
        string = string + "/";
        for (n2 = byArray.length / 2; n2 < byArray.length; ++n2) {
            string = string + Integer.toString(byArray[n2] & 0xFF) + ".";
        }
        string = string.substring(0, string.length() - 1);
        return string;
    }

    private final String stringifyIPCollection(Set set) {
        String string = "";
        string = string + "[";
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = string + this.stringifyIP((byte[])iterator.next()) + ",";
        }
        if (string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        string = string + "]";
        return string;
    }

    public String toString() {
        String string = "";
        string = string + "permitted:\n";
        if (this.permittedSubtreesDN != null) {
            string = string + "DN:\n";
            string = string + this.permittedSubtreesDN.toString() + "\n";
        }
        if (this.permittedSubtreesDNS != null) {
            string = string + "DNS:\n";
            string = string + this.permittedSubtreesDNS.toString() + "\n";
        }
        if (this.permittedSubtreesEmail != null) {
            string = string + "Email:\n";
            string = string + this.permittedSubtreesEmail.toString() + "\n";
        }
        if (this.permittedSubtreesURI != null) {
            string = string + "URI:\n";
            string = string + this.permittedSubtreesURI.toString() + "\n";
        }
        if (this.permittedSubtreesIP != null) {
            string = string + "IP:\n";
            PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
            string = string + pKIXNameConstraintValidator.stringifyIPCollection(pKIXNameConstraintValidator.permittedSubtreesIP) + "\n";
        }
        string = string + "excluded:\n";
        if (!this.excludedSubtreesDN.isEmpty()) {
            string = string + "DN:\n";
            string = string + this.excludedSubtreesDN.toString() + "\n";
        }
        if (!this.excludedSubtreesDNS.isEmpty()) {
            string = string + "DNS:\n";
            string = string + this.excludedSubtreesDNS.toString() + "\n";
        }
        if (!this.excludedSubtreesEmail.isEmpty()) {
            string = string + "Email:\n";
            string = string + this.excludedSubtreesEmail.toString() + "\n";
        }
        if (!this.excludedSubtreesURI.isEmpty()) {
            string = string + "URI:\n";
            string = string + this.excludedSubtreesURI.toString() + "\n";
        }
        if (!this.excludedSubtreesIP.isEmpty()) {
            string = string + "IP:\n";
            PKIXNameConstraintValidator pKIXNameConstraintValidator = this;
            string = string + pKIXNameConstraintValidator.stringifyIPCollection(pKIXNameConstraintValidator.excludedSubtreesIP) + "\n";
        }
        return string;
    }
}

