/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.tls;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.CryptoException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.DSA;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.Digest;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.Signer;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.digests.NullDigest;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.signers.DSADigestSigner;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.AbstractTlsSigner;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsUtils;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        if (signatureAndHashAlgorithm == null) {
            signer.update(byArray, 16, 20);
        } else {
            signer.update(byArray, 0, byArray.length);
        }
        return signer.generateSignature();
    }

    public boolean verifyRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, false, asymmetricKeyParameter);
        if (signatureAndHashAlgorithm == null) {
            signer.update(byArray2, 16, 20);
        } else {
            signer.update(byArray2, 0, byArray2.length);
        }
        return signer.verifySignature(byArray);
    }

    public Signer createSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, true, asymmetricKeyParameter);
    }

    public Signer createVerifyer(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, false, asymmetricKeyParameter);
    }

    protected dda makeInitParameters(boolean bl2, dda dda2) {
        return dda2;
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, boolean bl2, boolean bl3, dda dda2) {
        if (signatureAndHashAlgorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short s2 = signatureAndHashAlgorithm == null ? (short)2 : (short)signatureAndHashAlgorithm.getHash();
        Digest digest = bl2 ? new NullDigest() : TlsUtils.createHash(s2);
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(s2), digest);
        dSADigestSigner.init(bl3, this.makeInitParameters(bl3, dda2));
        return dSADigestSigner;
    }

    protected abstract short getSignatureAlgorithm();

    protected abstract DSA createDSAImpl(short var1);
}

