/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.Certificate;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.DTLSRecordLayer;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.MaxFragmentLength;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsFatalAlert;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsProtocol;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsUtils;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;

public abstract class DTLSProtocol {
    protected final SecureRandom secureRandom;

    protected DTLSProtocol(SecureRandom secureRandom) {
        if (secureRandom == null) {
            throw new IllegalArgumentException("'secureRandom' cannot be null");
        }
        this.secureRandom = secureRandom;
    }

    protected void processFinished(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray3 = TlsUtils.readFully(byArray2.length, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
            throw new TlsFatalAlert(40);
        }
    }

    protected static void applyMaxFragmentLengthExtension(DTLSRecordLayer dTLSRecordLayer, short s2) throws IOException {
        if (s2 >= 0) {
            if (!MaxFragmentLength.isValid(s2)) {
                throw new TlsFatalAlert(80);
            }
            int n2 = 1 << 8 + s2;
            dTLSRecordLayer.setPlaintextLimit(n2);
        }
    }

    protected static short evaluateMaxFragmentLengthExtension(boolean bl2, Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        short s3 = TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable2);
        if (s3 >= 0 && (!MaxFragmentLength.isValid(s3) || !bl2 && s3 != TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable))) {
            throw new TlsFatalAlert(s2);
        }
        return s3;
    }

    protected static byte[] generateCertificate(Certificate certificate) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificate.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] generateSupplementalData(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSupplementalData(byteArrayOutputStream, vector);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void validateSelectedCipherSuite(int n2, short s2) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm(n2)) {
            case 1: 
            case 2: {
                throw new TlsFatalAlert(s2);
            }
        }
    }
}

