/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.modes.gcm;

import java.util.Vector;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    public void init(byte[] byArray) {
        long[] lArray = GCMUtil.asLongs(byArray);
        if (this.lookupPowX2 != null && Arrays.areEqual(lArray, (long[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(lArray);
    }

    public void exponentiateX(long l2, byte[] byArray) {
        long[] lArray = GCMUtil.oneAsLongs();
        int n2 = 0;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                this.ensureAvailable(n2);
                GCMUtil.multiply(lArray, (long[])this.lookupPowX2.elementAt(n2));
            }
            ++n2;
            l2 >>>= 1;
        }
        GCMUtil.asBytes(lArray, byArray);
    }

    private final void ensureAvailable(int n2) {
        int n3 = this.lookupPowX2.size();
        if (n3 <= n2) {
            long[] lArray = (long[])this.lookupPowX2.elementAt(n3 - 1);
            do {
                lArray = Arrays.clone(lArray);
                GCMUtil.square(lArray, lArray);
                this.lookupPowX2.addElement(lArray);
            } while (++n3 <= n2);
        }
    }
}

