/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.modes;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.StreamBlockCipher;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.modes.CFBBlockCipher;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithSBox;

public class GCFBBlockCipher
extends StreamBlockCipher {
    private static final byte[] C = new byte[]{105, 0, 114, 34, 100, -55, 4, 35, -115, 58, -37, -106, 70, -23, 42, -60, 24, -2, -84, -108, 0, -19, 7, 18, -64, -122, -36, -62, -17, 76, -87, 43};
    private final CFBBlockCipher cfbEngine;
    private KeyParameter key;
    private long counter = 0L;
    private boolean forEncryption;

    public GCFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        BlockCipher blockCipher2 = blockCipher;
        this.cfbEngine = new CFBBlockCipher(blockCipher2, blockCipher2.getBlockSize() << 3);
    }

    public void init(boolean bl2, dda dda2) throws IllegalArgumentException {
        this.counter = 0L;
        this.cfbEngine.init(bl2, dda2);
        this.forEncryption = bl2;
        if (dda2 instanceof ParametersWithIV) {
            dda2 = ((ParametersWithIV)dda2).getParameters();
        }
        if (dda2 instanceof ParametersWithRandom) {
            dda2 = ((ParametersWithRandom)dda2).getParameters();
        }
        if (dda2 instanceof ParametersWithSBox) {
            dda2 = ((ParametersWithSBox)dda2).getParameters();
        }
        this.key = (KeyParameter)dda2;
    }

    public String getAlgorithmName() {
        String string;
        String string2 = string = this.cfbEngine.getAlgorithmName();
        return string.substring(0, string.indexOf(47)) + "/G" + string2.substring(string2.indexOf(47) + 1);
    }

    public int getBlockSize() {
        return this.cfbEngine.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.cfbEngine.getBlockSize(), byArray2, n3);
        return this.cfbEngine.getBlockSize();
    }

    protected byte calculateByte(byte by2) {
        if (this.counter > 0L && this.counter % 1024L == 0L) {
            BlockCipher blockCipher = this.cfbEngine.getUnderlyingCipher();
            blockCipher.init(false, this.key);
            byte[] byArray = new byte[32];
            blockCipher.processBlock(C, 0, byArray, 0);
            blockCipher.processBlock(C, 8, byArray, 8);
            blockCipher.processBlock(C, 16, byArray, 16);
            blockCipher.processBlock(C, 24, byArray, 24);
            this.key = new KeyParameter(byArray);
            blockCipher.init(true, this.key);
            byte[] byArray2 = this.cfbEngine.getCurrentIV();
            blockCipher.processBlock(byArray2, 0, byArray2, 0);
            this.cfbEngine.init(this.forEncryption, new ParametersWithIV(this.key, byArray2));
        }
        ++this.counter;
        return this.cfbEngine.calculateByte(by2);
    }

    public void reset() {
        this.counter = 0L;
        this.cfbEngine.reset();
    }
}

