/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.macs;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.Mac;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.OutputLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.engines.DSTU7624Engine;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;

public class DSTU7624Mac
implements Mac {
    private static final int BITS_IN_BYTE = 8;
    private byte[] buf;
    private int bufOff;
    private int macSize;
    private int blockSize;
    private DSTU7624Engine engine;
    private byte[] c;
    private byte[] cTemp;
    private byte[] kDelta;

    public DSTU7624Mac(int n2, int n3) {
        this.engine = new DSTU7624Engine(n2);
        this.blockSize = n2 / 8;
        this.macSize = n3 / 8;
        this.c = new byte[this.blockSize];
        this.kDelta = new byte[this.blockSize];
        this.cTemp = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
    }

    public void init(dda dda2) throws IllegalArgumentException {
        if (!(dda2 instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to DSTU7624Mac");
        }
        this.engine.init(true, dda2);
        this.engine.processBlock(this.kDelta, 0, this.kDelta, 0);
    }

    public String getAlgorithmName() {
        return "DSTU7624Mac";
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by2) {
        if (this.bufOff == this.buf.length) {
            DSTU7624Mac dSTU7624Mac = this;
            dSTU7624Mac.processBlock(dSTU7624Mac.buf, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by2;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("can't have a negative input length!");
        }
        int n4 = this.engine.getBlockSize();
        int n5 = n4 - this.bufOff;
        if (n3 > n5) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n5);
            DSTU7624Mac dSTU7624Mac = this;
            dSTU7624Mac.processBlock(dSTU7624Mac.buf, 0);
            this.bufOff = 0;
            n3 -= n5;
            n2 += n5;
            while (n3 > n4) {
                this.processBlock(byArray, n2);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    private final void processBlock(byte[] byArray, int n2) {
        DSTU7624Mac dSTU7624Mac = this;
        dSTU7624Mac.xor(dSTU7624Mac.c, 0, byArray, n2, this.cTemp);
        this.engine.processBlock(this.cTemp, 0, this.c, 0);
    }

    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        if (this.bufOff % this.buf.length != 0) {
            throw new DataLengthException("input must be a multiple of blocksize");
        }
        DSTU7624Mac dSTU7624Mac = this;
        dSTU7624Mac.xor(dSTU7624Mac.c, 0, this.buf, 0, this.cTemp);
        DSTU7624Mac dSTU7624Mac2 = this;
        dSTU7624Mac2.xor(dSTU7624Mac2.cTemp, 0, this.kDelta, 0, this.c);
        this.engine.processBlock(this.c, 0, this.c, 0);
        if (this.macSize + n2 > byArray.length) {
            throw new OutputLengthException("output buffer too short");
        }
        System.arraycopy(this.c, 0, byArray, n2, this.macSize);
        return this.macSize;
    }

    public void reset() {
        Arrays.fill(this.c, (byte)0);
        Arrays.fill(this.cTemp, (byte)0);
        Arrays.fill(this.kDelta, (byte)0);
        Arrays.fill(this.buf, (byte)0);
        this.engine.reset();
        this.engine.processBlock(this.kDelta, 0, this.kDelta, 0);
        this.bufOff = 0;
    }

    private final void xor(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3) {
        if (byArray.length - n2 < this.blockSize || byArray2.length - n3 < this.blockSize || byArray3.length < this.blockSize) {
            throw new IllegalArgumentException("some of input buffers too short");
        }
        for (int i2 = 0; i2 < this.blockSize; ++i2) {
            byArray3[i2] = (byte)(byArray[i2 + n2] ^ byArray2[i2 + n3]);
        }
    }
}

