/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.KeyGenerationParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECDomainParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECConstants;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.WNafUtil;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n2 = bigInteger2.bitLength();
        int n3 = n2 >>> 2;
        while ((bigInteger = new BigInteger(n2, this.random)).compareTo(ECConstants.TWO) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n3) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

