/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.engines;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.Wrapper;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.engines.GOST28147Engine;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.macs.GOST28147Mac;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithSBox;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithUKM;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine cipher = new GOST28147Engine();
    private GOST28147Mac mac = new GOST28147Mac();

    public void init(boolean bl2, dda dda2) {
        dda dda3;
        if (dda2 instanceof ParametersWithRandom) {
            dda3 = (ParametersWithRandom)dda2;
            dda2 = ((ParametersWithRandom)dda3).getParameters();
        }
        dda3 = (ParametersWithUKM)dda2;
        this.cipher.init(bl2, ((ParametersWithUKM)dda3).getParameters());
        KeyParameter keyParameter = ((ParametersWithUKM)dda3).getParameters() instanceof ParametersWithSBox ? (KeyParameter)((ParametersWithSBox)((ParametersWithUKM)dda3).getParameters()).getParameters() : (KeyParameter)((ParametersWithUKM)dda3).getParameters();
        this.mac.init(new ParametersWithIV(keyParameter, ((ParametersWithUKM)dda3).getUKM()));
    }

    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) {
        this.mac.update(byArray, n2, n3);
        byte[] byArray2 = new byte[n3 + this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        this.mac.doFinal(byArray2, n3);
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[n3 - this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[this.mac.getMacSize()];
        System.arraycopy(byArray, n2 + n3 - 4, byArray4, 0, this.mac.getMacSize());
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new IllegalStateException("mac mismatch");
        }
        return byArray2;
    }
}

