/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.ec.ECEncryptor;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.ec.ECPair;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.ec.ECUtil;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECDomainParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECAlgorithms;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.FixedPointCombMultiplier;

public class ECElGamalEncryptor
implements ECEncryptor {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    public void init(dda dda2) {
        if (dda2 instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)dda2;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(dda2 instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)dda2;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public ECPair encrypt(ECPoint eCPoint) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalEncryptor not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = ECUtil.generateK(eCDomainParameters.getN(), this.random);
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger), this.key.getQ().multiply(bigInteger).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPoint))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

