/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.BasicAgreement;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECDomainParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECAlgorithms;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECConstants;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    public void init(dda dda2) {
        this.key = (ECPrivateKeyParameters)dda2;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(dda dda2) {
        ECPoint eCPoint;
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)dda2;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters.getParameters())) {
            throw new IllegalStateException("ECDH public key has wrong domain parameters");
        }
        BigInteger bigInteger = this.key.getD();
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters.getQ());
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDH");
        }
        BigInteger bigInteger2 = eCDomainParameters.getH();
        if (!bigInteger2.equals(ECConstants.ONE)) {
            bigInteger = eCDomainParameters.getHInv().multiply(bigInteger).mod(eCDomainParameters.getN());
            eCPoint2 = ECAlgorithms.referenceMultiply(eCPoint2, bigInteger2);
        }
        if ((eCPoint = eCPoint2.multiply(bigInteger).normalize()).isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

