/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.BasicAgreement;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.DHParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithRandom;

public class DHBasicAgreement
implements BasicAgreement {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    public void init(dda dda2) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (dda2 instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)dda2;
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)dda2;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.dhParams = this.key.getParameters();
    }

    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    public BigInteger calculateAgreement(dda dda2) {
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)dda2;
        if (!dHPublicKeyParameters.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        BigInteger bigInteger = this.dhParams.getP();
        BigInteger bigInteger2 = dHPublicKeyParameters.getY();
        if (bigInteger2 == null || bigInteger2.compareTo(ONE) <= 0 || bigInteger2.compareTo(bigInteger.subtract(ONE)) >= 0) {
            throw new IllegalArgumentException("Diffie-Hellman public key is weak");
        }
        BigInteger bigInteger3 = bigInteger2.modPow(this.key.getX(), bigInteger);
        if (bigInteger3.equals(ONE)) {
            throw new IllegalStateException("Shared key can't be 1");
        }
        return bigInteger3;
    }
}

