/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.asn1.cmp;

import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1EncodableVector;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DERSequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DERTaggedObject;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.cmp.CMPCertificate;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Object {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        if (aSN1Sequence.size() > 1) {
            this.caPubs = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n2++), true);
        }
        this.response = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n2));
    }

    public static CertRepMessage getInstance(Object object) {
        if (object instanceof CertRepMessage) {
            return (CertRepMessage)object;
        }
        if (object != null) {
            return new CertRepMessage(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertRepMessage(CMPCertificate[] cMPCertificateArray, CertResponse[] certResponseArray) {
        int n2;
        ASN1EncodableVector aSN1EncodableVector;
        if (certResponseArray == null) {
            throw new IllegalArgumentException("'response' cannot be null");
        }
        if (cMPCertificateArray != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            for (n2 = 0; n2 < cMPCertificateArray.length; ++n2) {
                aSN1EncodableVector.add(cMPCertificateArray[n2]);
            }
            this.caPubs = new DERSequence(aSN1EncodableVector);
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        for (n2 = 0; n2 < certResponseArray.length; ++n2) {
            aSN1EncodableVector.add(certResponseArray[n2]);
        }
        this.response = new DERSequence(aSN1EncodableVector);
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.caPubs.size()];
        for (int i2 = 0; i2 != cMPCertificateArray.length; ++i2) {
            cMPCertificateArray[i2] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i2));
        }
        return cMPCertificateArray;
    }

    public CertResponse[] getResponse() {
        CertResponse[] certResponseArray = new CertResponse[this.response.size()];
        for (int i2 = 0; i2 != certResponseArray.length; ++i2) {
            certResponseArray[i2] = CertResponse.getInstance(this.response.getObjectAt(i2));
        }
        return certResponseArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.caPubs != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.caPubs));
        }
        aSN1EncodableVector.add(this.response);
        return new DERSequence(aSN1EncodableVector);
    }
}

