/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.exceptions;

import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbBackupInUseException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbBackupNotFoundException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbConditionalCheckFailedException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbContinuousBackupsUnavailableException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbGlobalTableAlreadyExistsException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbGlobalTableNotFoundException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbIdempotentParameterMismatchException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbIndexNotFoundException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbInternalServerErrorException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbInvalidRestoreTimeException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbItemCollectionSizeLimitExceededException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbLimitExceededException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbPointInTimeRecoveryUnavailableException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbProvisionedThroughputExceededException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbReplicaAlreadyExistsException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbReplicaNotFoundException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbRequestLimitExceededException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbResourceInUseException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbResourceNotFoundException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbTableAlreadyExistsException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbTableInUseException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbTableNotFoundException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbTransactionCanceledException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbTransactionConflictException;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbTransactionInProgressException;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.BackupInUseException;
import software.amazon.awssdk.services.dynamodb.model.BackupNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.CancellationReason;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.IndexNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.InvalidRestoreTimeException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.ReplicaNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.TableInUseException;
import software.amazon.awssdk.services.dynamodb.model.TableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TransactionInProgressException;

public class CFDynamoDBExceptionHandler {
    public static CFDynamoDbException handleTransactionCanceledExceptions(TransactionCanceledException transactionCanceledException, List<CancellationReason> cancellationReasons, String apiName, Map options) {
        return new CFDynamoDbTransactionCanceledException((DynamoDbException)((Object)transactionCanceledException), cancellationReasons, apiName, options);
    }

    public static CFDynamoDbException handleExceptions(DynamoDbException dynamoDbException, String apiName) throws Exception {
        if (dynamoDbException instanceof ResourceNotFoundException) {
            return new CFDynamoDbResourceNotFoundException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof BackupInUseException) {
            return new CFDynamoDbBackupInUseException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof BackupNotFoundException) {
            return new CFDynamoDbBackupNotFoundException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof ConditionalCheckFailedException) {
            return new CFDynamoDbConditionalCheckFailedException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof ContinuousBackupsUnavailableException) {
            return new CFDynamoDbContinuousBackupsUnavailableException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof GlobalTableAlreadyExistsException) {
            return new CFDynamoDbGlobalTableAlreadyExistsException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof GlobalTableNotFoundException) {
            return new CFDynamoDbGlobalTableNotFoundException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof IdempotentParameterMismatchException) {
            return new CFDynamoDbIdempotentParameterMismatchException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof IndexNotFoundException) {
            return new CFDynamoDbIndexNotFoundException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof InternalServerErrorException) {
            return new CFDynamoDbInternalServerErrorException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof InvalidRestoreTimeException) {
            return new CFDynamoDbInvalidRestoreTimeException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof ItemCollectionSizeLimitExceededException) {
            return new CFDynamoDbItemCollectionSizeLimitExceededException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof LimitExceededException) {
            return new CFDynamoDbLimitExceededException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof PointInTimeRecoveryUnavailableException) {
            return new CFDynamoDbPointInTimeRecoveryUnavailableException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof ProvisionedThroughputExceededException) {
            return new CFDynamoDbProvisionedThroughputExceededException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof ReplicaAlreadyExistsException) {
            return new CFDynamoDbReplicaAlreadyExistsException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof ReplicaNotFoundException) {
            return new CFDynamoDbReplicaNotFoundException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof RequestLimitExceededException) {
            return new CFDynamoDbRequestLimitExceededException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof ResourceInUseException) {
            return new CFDynamoDbResourceInUseException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof TableAlreadyExistsException) {
            return new CFDynamoDbTableAlreadyExistsException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof TableInUseException) {
            return new CFDynamoDbTableInUseException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof TableNotFoundException) {
            return new CFDynamoDbTableNotFoundException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof TransactionCanceledException) {
            return new CFDynamoDbTransactionCanceledException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof TransactionConflictException) {
            return new CFDynamoDbTransactionConflictException(dynamoDbException, apiName);
        }
        if (dynamoDbException instanceof TransactionInProgressException) {
            return new CFDynamoDbTransactionInProgressException(dynamoDbException, apiName);
        }
        return new CFDynamoDbException(dynamoDbException, apiName);
    }
}

