/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.session.external;

import coldfusion.osgi.services.SessionStorageService;
import coldfusion.server.ServiceFactory;
import coldfusion.session.NodeDiscoveryManager;
import coldfusion.session.external.RedisConfig;
import coldfusion.session.external.RedisSessionStorage;
import java.io.IOException;

public class SessionStorageServiceImpl
implements SessionStorageService {
    public Object getRedisSessionStorage(String sessionStorageHost, int sessionStoragePort, String password, int sessionStorageTimeout) {
        NodeDiscoveryManager dm = null;
        try {
            dm = SessionStorageServiceImpl.createNodeDiscoveryManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RedisConfig redisConfig = new RedisConfig(sessionStorageHost, sessionStoragePort);
        if (null != password) {
            redisConfig.setPassword(password);
        }
        redisConfig.setTimeout(sessionStorageTimeout);
        redisConfig.setSSL(ServiceFactory.getRuntimeService().getSessionStorageSSLEnabled());
        return new RedisSessionStorage(redisConfig, dm);
    }

    public void testConnection(String host, int port, String password, boolean b, boolean ssl, Object object) {
        RedisSessionStorage.testConnection(host, port, password, false, ssl, null);
    }

    private static NodeDiscoveryManager createNodeDiscoveryManager() throws IOException {
        final NodeDiscoveryManager dm = new NodeDiscoveryManager();
        dm.startReceivingMessages();
        dm.startHeartBeat();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                dm.shutdown();
            }
        }));
        return dm;
    }
}

