/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.token;

import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.token.SATokenImpl;
import com.lotus.sametime.token.SATokenService;
import com.lotus.sametime.token.TokenEvent;
import com.lotus.sametime.token.TokenServiceListener;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SATokenComp
extends STComp
implements SATokenService {
    private Vector m_listenerList = new Vector();
    private SATokenImpl m_impl = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.token");

    public SATokenComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.token.SATokenComp", sTSession);
        this.m_impl = new SATokenImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public synchronized void addTokenServiceListener(TokenServiceListener tokenServiceListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.addElement(tokenServiceListener);
        this.m_listenerList = vector;
    }

    public synchronized void removeTokenServiceListener(TokenServiceListener tokenServiceListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.removeElement(tokenServiceListener);
        this.m_listenerList = vector;
    }

    public void generateToken(STUser sTUser) {
        this.sendEvent(new TokenEvent((Object)this, 2, sTUser));
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof TokenEvent) {
            this.processTokenEvent((TokenEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processTokenEvent(TokenEvent tokenEvent) {
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TokenServiceListener tokenServiceListener = (TokenServiceListener)enumeration.nextElement();
            switch (tokenEvent.getId()) {
                case -2147483646: {
                    tokenEvent.setSource(this);
                    tokenServiceListener.tokenGenerated(tokenEvent);
                    tokenEvent.setConsumed(true);
                    break;
                }
                case -2147483645: {
                    tokenEvent.setSource(this);
                    tokenServiceListener.generateTokenFailed(tokenEvent);
                    tokenEvent.setConsumed(true);
                }
            }
        }
    }
}

