/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.storage;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelListener;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.community.OTMEvent;
import com.lotus.sametime.community.OTMServiceListener;
import com.lotus.sametime.community.OneTimeMsgService;
import com.lotus.sametime.community.ServiceEvent;
import com.lotus.sametime.community.ServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompImpl;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.storage.StorageEvent;
import com.lotus.sametime.storage.StorageRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageImpl
extends STCompImpl
implements LoginListener,
ChannelListener,
ServiceListener,
OTMServiceListener {
    public static final short VPCONFIG_STORAGE_GET = 4;
    public static final short VPCONFIG_STORAGE_ONGET = 5;
    public static final short VPCONFIG_STORAGE_SET = 6;
    public static final short VPCONFIG_STORAGE_ONSET = 7;
    public static final short ST_OTM_STORAGE_SUBSCRIBE = -32767;
    public static final short ST_OTM_STORAGE_UNSUBSCRIBE = -32766;
    public static final short ST_OTM_STORAGE_CHANGED = -32765;
    private static final int ST_PROT_TYPE_ATTRIBUTES_SERVER = 38;
    private Hashtable m_sentRequests = new Hashtable();
    private Vector m_waitingRequests = new Vector();
    private ChannelService m_channelService;
    private CommunityService m_comm;
    private OneTimeMsgService m_otmService;
    private boolean m_serviceUp = false;
    protected boolean m_enableBuffering = false;
    private Channel m_channel;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.storage");

    public StorageImpl(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.storage.StorageComp", sTSession);
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_comm) {
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
        }
        this.m_otmService = (OneTimeMsgService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_otmService) {
            this.m_otmService.addOTMServiceListener(this);
        }
    }

    public void start() {
        Debug.stAssert(this.m_channelService != null);
        Debug.stAssert(this.m_comm != null);
    }

    public void stop() {
        this.destroyChannel();
        this.m_sentRequests.clear();
        this.m_waitingRequests.removeAllElements();
    }

    public void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_comm && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
            this.m_comm.addLoginListener(this);
            this.m_comm.addServiceListener(this);
            this.m_comm.senseService(24);
        }
        if (null == this.m_channelService && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
        }
        if (null == this.m_otmService && sTCompApi instanceof OneTimeMsgService) {
            this.m_otmService = (OneTimeMsgService)sTCompApi;
            this.m_otmService.addOTMServiceListener(this);
        }
    }

    public void channelOpened(ChannelEvent channelEvent) {
        if (this.m_waitingRequests.size() > 0) {
            this.sendWaitingRequests();
        } else {
            this.destroyChannel();
        }
    }

    public void channelMsgReceived(ChannelEvent channelEvent) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "channelMsgReceived", "StorageImp.channelMsgReceived : ChannelEvent received");
        }
        NdrInputStream ndrInputStream = new NdrInputStream(channelEvent.getData());
        try {
            int n = ndrInputStream.readInt();
            StorageRequest storageRequest = (StorageRequest)this.m_sentRequests.remove(new Integer(n));
            if (null != storageRequest) {
                storageRequest.readResponse(ndrInputStream);
                this.sendResponse(storageRequest);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.m_waitingRequests.isEmpty() && this.m_sentRequests.isEmpty()) {
            this.destroyChannel();
        }
    }

    public void channelClosed(ChannelEvent channelEvent) {
        this.channelDestroyed(channelEvent.getReason());
    }

    public void channelOpenFailed(ChannelEvent channelEvent) {
        this.channelDestroyed(channelEvent.getReason());
    }

    private void channelDestroyed(int n) {
        int n2;
        StorageRequest storageRequest;
        this.m_channel.removeChannelListener(this);
        this.m_channel = null;
        Enumeration<Object> enumeration = this.m_sentRequests.elements();
        while (enumeration.hasMoreElements()) {
            storageRequest = (StorageRequest)enumeration.nextElement();
            storageRequest.m_rc = Integer.MIN_VALUE;
            this.sendResponse(storageRequest);
        }
        this.m_sentRequests.clear();
        if (n == -2147483635) {
            n2 = -2147483635;
        } else {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "channelDestroyed", "Storage Impl, Channel destroyed reason:" + n);
            }
            n2 = Integer.MIN_VALUE;
        }
        enumeration = this.m_waitingRequests.elements();
        while (enumeration.hasMoreElements()) {
            storageRequest = (StorageRequest)enumeration.nextElement();
            storageRequest.m_rc = n2;
            this.sendResponse(storageRequest);
        }
        if (!this.m_enableBuffering) {
            this.m_waitingRequests.removeAllElements();
        }
        if (n == -2147483635) {
            this.m_serviceUp = false;
            StorageEvent storageEvent = new StorageEvent(this, 103);
            this.sendEvent(storageEvent);
            if (this.isServerSupportingStorage()) {
                this.m_comm.senseService(24);
            }
        }
    }

    public void loggedOut(LoginEvent loginEvent) {
        this.m_sentRequests.clear();
        this.m_waitingRequests.removeAllElements();
        this.m_serviceUp = false;
    }

    public String toString() {
        return "{StorageImpl}";
    }

    public void checkTimeout(int n) {
        Hashtable hashtable = (Hashtable)this.m_sentRequests.clone();
        long l = System.currentTimeMillis() - (long)n;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            StorageRequest storageRequest = (StorageRequest)enumeration.nextElement();
            if (storageRequest.m_issueTime <= l) continue;
            storageRequest.m_rc = Integer.MIN_VALUE;
            this.sendResponse(storageRequest);
            this.m_sentRequests.remove(storageRequest.m_requestId);
        }
    }

    public void set(Integer n, Vector vector, STUser sTUser) {
        StorageRequest storageRequest = new StorageRequest(n, 6, vector, sTUser);
        if (this.m_serviceUp || this.m_enableBuffering) {
            this.m_waitingRequests.addElement(storageRequest);
            if (this.m_serviceUp && null == this.m_channel) {
                this.createChannel();
            } else if (this.m_channel.isOpen()) {
                this.sendWaitingRequests();
            }
        }
        if (!this.m_serviceUp && !this.m_enableBuffering) {
            storageRequest.m_rc = -2147483635;
            this.sendResponse(storageRequest);
        }
    }

    public void get(Integer n, Vector vector, STUser sTUser) {
        StorageRequest storageRequest = new StorageRequest(n, 4, vector, sTUser);
        if (this.m_serviceUp || this.m_enableBuffering) {
            this.m_waitingRequests.addElement(storageRequest);
            if (this.m_serviceUp && null == this.m_channel) {
                this.createChannel();
            } else if (this.m_channel.isOpen()) {
                this.sendWaitingRequests();
            }
        }
        if (!this.m_serviceUp && !this.m_enableBuffering) {
            storageRequest.m_rc = -2147483635;
            this.sendResponse(storageRequest);
        }
    }

    private void createChannel() {
        Debug.stAssert(this.m_channel == null);
        this.m_channel = this.m_channelService.createChannel(24, 25, 1, EncLevel.ENC_LEVEL_NONE, null, null);
        this.m_channel.addChannelListener(this);
        this.m_channel.open();
    }

    private void sendRequest(StorageRequest storageRequest) {
        try {
            NdrOutputStream ndrOutputStream = new NdrOutputStream();
            storageRequest.writeToStream(ndrOutputStream);
            byte[] byArray = ndrOutputStream.toByteArray();
            this.m_channel.sendMsg(storageRequest.m_type, byArray, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void destroyChannel() {
        if (null != this.m_channel) {
            this.m_channel.close(0, null);
            this.m_channel.removeChannelListener(this);
            this.m_channel = null;
        }
    }

    private void sendResponse(StorageRequest storageRequest) {
        switch (storageRequest.m_type) {
            case 4: {
                this.sendOnGetResponse(storageRequest);
                break;
            }
            case 6: {
                this.sendOnSetResponse(storageRequest);
                break;
            }
            default: {
                System.err.println("StorageComp: Unhandled send response type");
            }
        }
    }

    private void sendOnGetResponse(StorageRequest storageRequest) {
        Vector vector = null;
        Vector vector2 = null;
        switch (storageRequest.m_rc) {
            case 0: {
                vector = storageRequest.m_response;
                break;
            }
            case 17: {
                vector = storageRequest.m_response;
                vector2 = this.generateDiffList(storageRequest.m_data, storageRequest.m_response);
                break;
            }
            default: {
                vector2 = storageRequest.m_data;
            }
        }
        StorageEvent storageEvent = new StorageEvent(this, 102, storageRequest.m_requestId, storageRequest.m_rc, vector, vector2, storageRequest.m_stUser);
        this.sendEvent(storageEvent);
    }

    private void sendOnSetResponse(StorageRequest storageRequest) {
        StorageEvent storageEvent = new StorageEvent(this, 101, storageRequest.m_requestId, storageRequest.m_rc, storageRequest.m_data, storageRequest.m_stUser);
        this.sendEvent(storageEvent);
    }

    private Vector generateDiffList(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            boolean bl = false;
            int n = e instanceof STAttribute ? ((STAttribute)e).getKey() : ((Integer)e).intValue();
            for (int i = 0; null != vector2 && i < vector2.size(); ++i) {
                int n2;
                Object e2 = vector2.elementAt(i);
                int n3 = n2 = e2 instanceof STAttribute ? ((STAttribute)e2).getKey() : ((Integer)e2).intValue();
                if (n != n2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector3.addElement(e);
        }
        return vector3;
    }

    public void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof StorageEvent) {
            StorageEvent storageEvent = (StorageEvent)sTEvent;
            switch (storageEvent.getId()) {
                case 2: {
                    this.get(storageEvent.m_requestId, storageEvent.m_requestList, storageEvent.getSTUser());
                    storageEvent.setConsumed(true);
                    break;
                }
                case 1: {
                    this.set(storageEvent.m_requestId, storageEvent.m_requestList, storageEvent.getSTUser());
                    storageEvent.setConsumed(true);
                    break;
                }
                case 3: {
                    this.checkTimeout(storageEvent.m_timeout);
                    storageEvent.setConsumed(true);
                }
            }
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    public void serviceAvailable(ServiceEvent serviceEvent) {
        if (!this.m_serviceUp && serviceEvent.getServiceType() == 24) {
            this.m_serviceUp = true;
            StorageEvent storageEvent = new StorageEvent(this, 104);
            this.sendEvent(storageEvent);
            if (this.m_waitingRequests.size() > 0) {
                this.createChannel();
                Enumeration enumeration = this.m_waitingRequests.elements();
                while (enumeration.hasMoreElements()) {
                    StorageRequest storageRequest = (StorageRequest)enumeration.nextElement();
                    storageRequest.m_issueTime = System.currentTimeMillis();
                }
            }
        }
    }

    public void loggedIn(LoginEvent loginEvent) {
        this.m_otmService.sendOTM(StorageImpl.getUniqueId(), new STId("", ""), -2147483610, 0, 0, (short)-32767, new byte[0]);
        if (this.isServerSupportingStorage()) {
            this.createChannel();
            this.m_comm.senseService(24);
        }
    }

    private void sendWaitingRequests() {
        if (null != this.m_channel && this.m_waitingRequests.size() > 0 && this.m_channel.isOpen()) {
            Enumeration enumeration = this.m_waitingRequests.elements();
            while (enumeration.hasMoreElements()) {
                StorageRequest storageRequest = (StorageRequest)enumeration.nextElement();
                this.sendRequest(storageRequest);
                this.m_sentRequests.put(storageRequest.m_requestId, storageRequest);
            }
            this.m_waitingRequests.removeAllElements();
        }
    }

    public void otmRecieved(OTMEvent oTMEvent) {
        if (oTMEvent.getServiceType() == -2147483610 && oTMEvent.getPrVersion() >= 0 && oTMEvent.getMsgType() == -32765) {
            try {
                NdrInputStream ndrInputStream = new NdrInputStream(oTMEvent.getData());
                int n = ndrInputStream.readInt();
                StorageEvent storageEvent = new StorageEvent(this, 105);
                storageEvent.m_updatedAttribList = new int[n];
                for (int i = 0; i < n; ++i) {
                    storageEvent.m_updatedAttribList[i] = ndrInputStream.readInt();
                }
                this.sendEvent(storageEvent);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private boolean isServerSupportingStorage() {
        boolean bl = false;
        int n = this.m_comm.getLogin().getServerVersion();
        short s = (short)(n >> 16);
        short s2 = (short)(n & 0xFFFF);
        if (s > 30 || s == 30 && s2 >= 25) {
            bl = true;
        }
        return bl;
    }

    public void sendOTMDenied(OTMEvent oTMEvent) {
    }

    protected boolean isServiceUp() {
        return this.m_serviceUp;
    }
}

