/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.lookup;

import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.lookup.LookupComp;
import com.lotus.sametime.lookup.ResolveEvent;
import com.lotus.sametime.lookup.ResolveListener;
import java.util.Enumeration;
import java.util.Vector;

public class Resolver {
    private LookupComp m_lookup;
    private boolean m_onlyUnique;
    private boolean m_exhaustiveLookup;
    private boolean m_resolveUsers;
    private boolean m_resolveGroups;
    private Vector m_listenerList = new Vector();

    protected Resolver(LookupComp lookupComp, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.m_lookup = lookupComp;
        this.m_onlyUnique = bl;
        this.m_exhaustiveLookup = bl2;
        this.m_resolveUsers = bl3;
        this.m_resolveGroups = bl4;
    }

    public synchronized void addResolveListener(ResolveListener resolveListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.addElement(resolveListener);
        this.m_listenerList = vector;
    }

    public synchronized void removeResolveListener(ResolveListener resolveListener) {
        Vector vector = (Vector)this.m_listenerList.clone();
        vector.removeElement(resolveListener);
        this.m_listenerList = vector;
    }

    public void resolve(String[] stringArray) {
        this.m_lookup.resolveNames(stringArray, this.m_onlyUnique, this.m_exhaustiveLookup, this.m_resolveUsers, this.m_resolveGroups, this);
    }

    public void resolve(String string) {
        String[] stringArray = new String[]{string};
        this.resolve(stringArray);
    }

    public boolean isOnlyUnique() {
        return this.m_onlyUnique;
    }

    public boolean isExhaustiveLookup() {
        return this.m_exhaustiveLookup;
    }

    public boolean isResolveUsers() {
        return this.m_resolveUsers;
    }

    public boolean isResolveGroups() {
        return this.m_resolveGroups;
    }

    protected void resolved(String string, STObject sTObject) {
        ResolveEvent resolveEvent = new ResolveEvent((Object)this, -2147483647, string, sTObject);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResolveListener resolveListener = (ResolveListener)enumeration.nextElement();
            resolveListener.resolved(resolveEvent);
        }
    }

    protected void resolveConflict(String string, STObject[] sTObjectArray) {
        ResolveEvent resolveEvent = new ResolveEvent((Object)this, -2147483645, string, sTObjectArray);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResolveListener resolveListener = (ResolveListener)enumeration.nextElement();
            resolveListener.resolveConflict(resolveEvent);
        }
    }

    protected void resolveFailed(String[] stringArray, int n) {
        ResolveEvent resolveEvent = new ResolveEvent((Object)this, -2147483646, stringArray, n);
        Vector vector = this.m_listenerList;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResolveListener resolveListener = (ResolveListener)enumeration.nextElement();
            resolveListener.resolveFailed(resolveEvent);
        }
    }
}

