/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.tree;

import com.lotus.sametime.guiutils.tree.TreeNode;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class CellData {
    public static final int NO_DATA = 0;
    public static final int DATA_IS_TEXT = 1;
    public static final int DATA_IS_ICON = 2;
    public static final int LEFT_ALIGN = 0;
    public static final int CENTER_ALIGN = 1;
    public static final int RIGHT_ALIGN = 1;
    private int m_dataType;
    protected Image m_image;
    protected String m_text;
    protected int m_alignment = 1;

    public CellData() {
        this.m_dataType = 0;
    }

    public CellData(Image image, int n) {
        this.m_image = image;
        this.m_alignment = n;
        this.m_dataType = 2;
    }

    public CellData(Image image) {
        this(image, 1);
    }

    public CellData(String string, int n) {
        this.m_text = string;
        this.m_alignment = n;
        this.m_dataType = 1;
    }

    public CellData(String string) {
        this(string, 0);
    }

    public Image getImage() {
        return this.m_image;
    }

    public String getText() {
        return this.m_text;
    }

    public int getDataType() {
        return this.m_dataType;
    }

    public void drawData(Graphics graphics, ImageObserver imageObserver, Rectangle rectangle) {
        if (this.m_dataType == 0) {
            return;
        }
        int n = rectangle.getLocation().x;
        int n2 = rectangle.getLocation().y;
        if (this.m_dataType == 2) {
            if (this.m_image != null) {
                if (this.m_alignment == 1) {
                    n += (rectangle.width - this.m_image.getWidth(null)) / 2;
                    n2 += (rectangle.height - this.m_image.getHeight(null)) / 2;
                }
                graphics.drawImage(this.m_image, n, n2, imageObserver);
            }
        } else if (this.m_text != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(TreeNode.FONT);
            if (this.m_alignment == 1) {
                int n3 = fontMetrics.stringWidth(this.m_text);
                n += (rectangle.width - n3) / 2;
            }
            graphics.drawString(this.m_text, n, n2 += fontMetrics.getAscent());
        }
    }
}

