/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.sttable;

import com.lotus.sametime.guiutils.sttable.StTable;
import com.lotus.sametime.guiutils.sttable.table.TableModel;

public class StTableC
extends StTable
implements TableModel {
    private Object[][] tableData;
    private String[] titles;

    public StTableC(String[] stringArray, Object[][] objectArray) {
        super(null);
        this.titles = stringArray;
        this.tableData = objectArray != null ? objectArray : new Object[0][0];
        this.setTableModel(this);
    }

    public StTableC(String[] stringArray) {
        this(stringArray, null);
    }

    public void addRow(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        this.addRowAt(objectArray, this.tableData.length);
    }

    public void addRows(Object[][] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        this.addRowsAt(objectArray, this.tableData.length);
    }

    public void addRowAt(Object[] objectArray, int n) {
        if (objectArray == null || n < 0 || n > this.tableData.length) {
            return;
        }
        this.addRowsAt(new Object[][]{objectArray}, n);
    }

    public void addRowsAt(Object[][] objectArray, int n) {
        if (objectArray == null || objectArray.length == 0 || n > this.tableData.length) {
            return;
        }
        Object[][] objectArrayArray = new Object[this.tableData.length + objectArray.length][];
        System.arraycopy(this.tableData, 0, objectArrayArray, 0, n);
        System.arraycopy(objectArray, 0, objectArrayArray, n, objectArray.length);
        System.arraycopy(this.tableData, n, objectArrayArray, n + objectArray.length, this.tableData.length - n);
        this.tableData = objectArrayArray;
        int n2 = this.getSelectedRow();
        if (n2 >= n) {
            this.setSelectedRow(n2 + objectArray.length);
        }
        this.resizeAndRepaint();
    }

    public void removeRows(int n, int n2) {
        if (n < 0 || n2 > this.tableData.length) {
            return;
        }
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        Object[][] objectArrayArray = new Object[this.tableData.length + n - n2][];
        System.arraycopy(this.tableData, 0, objectArrayArray, 0, n);
        System.arraycopy(this.tableData, n2, objectArrayArray, n, this.tableData.length - n2);
        this.tableData = objectArrayArray;
        int n4 = this.getSelectedRow();
        if (n4 >= n) {
            if (n4 < n2) {
                this.setSelectedRow(-1);
            } else {
                this.setSelectedRow(n4 + n - n2);
            }
        }
        this.resizeAndRepaint();
    }

    public void removeRow(int n) {
        if (n < 0 || n >= this.tableData.length) {
            return;
        }
        Object[][] objectArrayArray = new Object[this.tableData.length - 1][];
        System.arraycopy(this.tableData, 0, objectArrayArray, 0, n);
        System.arraycopy(this.tableData, n + 1, objectArrayArray, n, this.tableData.length - n - 1);
        this.tableData = objectArrayArray;
        int n2 = this.getSelectedRow();
        if (n2 == n) {
            this.setSelectedRow(-1);
        } else if (n2 > n) {
            this.setSelectedRow(n2 - 1);
        }
        this.resizeAndRepaint();
    }

    public void removeAllRows() {
        this.tableData = new Object[0][0];
        this.setSelectedRow(-1);
        this.resizeAndRepaint();
    }

    public Object[] getRowAt(int n) {
        if (n < 0 || n >= this.tableData.length) {
            return null;
        }
        return this.tableData[n];
    }

    public void setRowAt(Object[] objectArray, int n) {
        if (n < 0 || n > this.tableData.length || objectArray == null || objectArray.length == 0) {
            return;
        }
        if (n == this.tableData.length) {
            this.addRows(new Object[][]{objectArray});
            return;
        }
        this.tableData[n] = objectArray;
        this.repaintRow(n);
    }

    public int getRowCount() {
        return this.tableData.length;
    }

    public Object getValueAt(int n, int n2) {
        return this.tableData[n][n2];
    }

    public void setValueAt(Object object, int n, int n2) {
        this.tableData[n][n2] = object;
        this.repaintRow(n);
    }

    public String getColumnName(int n) {
        return this.titles[n];
    }

    public int getColumnCount() {
        return this.titles.length;
    }
}

