/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.misc;

import com.lotus.sametime.guiutils.helpers.TextHelpers;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.Vector;

public class TextPanel
extends Panel {
    private short MIN_CHARS = (short)15;
    private short MAX_CHARS = (short)35;
    private int m_HPadding = 10;
    private int m_VPadding = 10;
    private int m_width;
    private int m_height;
    private String[] m_text;

    public TextPanel(String[] stringArray) {
        this.m_text = stringArray;
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        this.calcDimension();
        this.setSize(this.m_width, this.m_height);
        this.setBackground(SystemColor.control);
    }

    public TextPanel(String[] stringArray, int n, int n2) {
        this.m_HPadding = n;
        this.m_VPadding = n2;
        this.m_text = stringArray;
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        this.calcDimension();
        this.setSize(this.m_width, this.m_height);
    }

    private void calcDimension() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_text.length; ++i) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.m_text[i]));
        }
        this.m_width = n2;
        this.m_width = Math.min(this.m_width, font.getSize() * this.MAX_CHARS + 2 * this.m_HPadding);
        this.m_width = Math.max(this.m_width, font.getSize() * this.MIN_CHARS + 2 * this.m_HPadding);
        for (int i = 0; i < this.m_text.length; ++i) {
            Vector vector = TextHelpers.alignParagraph(this.m_text[i], this.m_width - 2 * this.m_HPadding, fontMetrics);
            n += vector.size();
        }
        this.m_height = n * fontMetrics.getHeight() + 2 * this.m_VPadding;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight() * 1;
        int n2 = this.getBounds().width - this.m_HPadding;
        int n3 = this.m_HPadding;
        graphics.setColor(Color.black);
        graphics.setFont(this.getFont());
        for (int i = 0; i < this.m_text.length; ++i) {
            Vector vector = TextHelpers.alignParagraph(this.m_text[i], n2 - n3, fontMetrics);
            for (int j = 0; j < vector.size(); ++j) {
                String string = (String)vector.elementAt(j);
                graphics.drawString(string, n3, n);
                n += fontMetrics.getHeight();
            }
        }
    }

    public void setHGap(int n) {
        this.m_HPadding = n;
        this.calcDimension();
        this.repaint();
    }

    public void setVGap(int n) {
        this.m_VPadding = n;
        this.calcDimension();
        this.repaint();
    }
}

