/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.misc;

import com.lotus.sametime.core.util.StaticProps;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class ButtonsPanel
extends Panel {
    public static final short LEFT = 0;
    public static final short CENTER = 1;
    public static final short RIGHT = 2;
    private static final short PADDING = 1;
    private static final short GAP = 10;
    private static final short MIN_CHARS = 6;
    private static final int MIN_HEIGHT = 21;
    private Button[] m_buttons;
    private int m_minWidth = 50;
    private short m_allignment = (short)2;
    private ActionListener m_listener;

    public ButtonsPanel() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ButtonsPanel.this.componentResized(componentEvent);
            }
        });
        this.setLayout(null);
        if (StaticProps.m_bMacOSX) {
            this.setFont(Font.decode("Dialog"));
        } else {
            this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        }
    }

    public ButtonsPanel(String[] stringArray, ActionListener actionListener) {
        this(stringArray, actionListener, 1);
    }

    public ButtonsPanel(String[] stringArray, ActionListener actionListener, short s) {
        this();
        this.setButtons(stringArray, actionListener, s);
    }

    public void setButtons(String[] stringArray, ActionListener actionListener, short s) {
        this.m_allignment = s;
        this.m_listener = actionListener;
        Button[] buttonArray = new Button[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            buttonArray[i] = new Button(stringArray[i]);
            this.add(buttonArray[i]);
            buttonArray[i].addActionListener(actionListener);
        }
        this.m_buttons = buttonArray;
    }

    private void layoutButtons() {
        int n;
        int n2;
        if (null == this.m_buttons) {
            return;
        }
        int n3 = this.m_minWidth = this.getFont().getSize() * 6;
        for (n2 = 0; n2 < this.m_buttons.length; ++n2) {
            n = this.m_buttons[n2].getPreferredSize().width;
            n3 = Math.max(n3, n);
        }
        n2 = this.m_buttons.length * n3;
        int n4 = 0;
        Dimension dimension = this.getSize();
        switch (this.m_allignment) {
            case 1: {
                n4 = (dimension.width - (n2 + (this.m_buttons.length - 1) * 10)) / 2;
                break;
            }
            case 0: {
                n4 = 1;
                break;
            }
            case 2: {
                n4 = dimension.width - (n2 + (this.m_buttons.length - 1) * 10 + 1);
            }
        }
        int n5 = Math.min(dimension.height, this.m_buttons[0].getPreferredSize().height);
        n5 = Math.max(21, n5);
        int n6 = (dimension.height - n5) / 2;
        for (int i = 0; i < this.m_buttons.length; ++i) {
            n = this.m_buttons[i].getPreferredSize().width;
            this.m_buttons[i].setBounds(n4, n6, n3, n5);
            n4 += 10 + n3;
        }
    }

    public Button getButton(String string) {
        if (this.m_buttons == null) {
            return null;
        }
        Button button = null;
        for (int i = 0; i < this.m_buttons.length; ++i) {
            if (!this.m_buttons[i].getLabel().equals(string)) continue;
            button = this.m_buttons[i];
            break;
        }
        return button;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.m_minWidth = this.getFont().getSize() * 6;
    }

    public Dimension getMinimumSize() {
        this.m_minWidth = this.getFont().getSize() * 6;
        Dimension dimension = new Dimension();
        if (this.m_buttons != null) {
            dimension.width = 2 + this.m_minWidth * this.m_buttons.length + 10 * (this.m_buttons.length - 1);
            dimension.height = this.m_buttons[0].getPreferredSize().height;
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        int n = this.m_minWidth = this.getFont().getSize() * 6;
        Dimension dimension = new Dimension();
        if (this.m_buttons != null) {
            for (int i = 0; i < this.m_buttons.length; ++i) {
                Dimension dimension2 = this.m_buttons[i].getPreferredSize();
                n = n >= dimension2.width ? n : dimension2.width;
            }
            dimension.width = 2 + n * this.m_buttons.length + 10 * (this.m_buttons.length - 1);
            dimension.height = this.m_buttons[0].getPreferredSize().height;
        }
        return dimension;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.layoutButtons();
    }

    public void removeAll() {
        super.removeAll();
        for (int i = 0; null != this.m_buttons && i < this.m_buttons.length; ++i) {
            this.m_buttons[i].removeActionListener(this.m_listener);
        }
    }

    private void componentResized(ComponentEvent componentEvent) {
        this.layoutButtons();
        this.repaint();
    }
}

