/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.DirectSocketConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

class Socks5ConnectionImpl
extends DirectSocketConnection {
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_HANDSHAKE = 1;
    private static final int STATE_AUTHENTICATE = 2;
    private static final int STATE_CONNECT = 3;
    private static final int STATE_CONNECTED = 4;
    private static final int LENGTH_HANDSHAKE_RESPONSE = 2;
    private static final int LENGTH_AUTHENTICATION_RESPONSE = 2;
    private static final int LENGTH_CONNECT_RESPONSE = 10;
    private int m_state = 0;
    private Socket m_socket;
    private String m_proxyServer;
    private String m_proxyLogin;
    private String m_proxyPassword;
    private int m_proxyPort;
    private InetAddress m_hostAdd;
    private short m_resolveOption;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public Socks5ConnectionImpl(String string, int n, String string2, int n2, String string3, String string4, long l, short s, InetAddress inetAddress) {
        super(string, n, l);
        this.m_proxyServer = string2;
        this.m_proxyPort = n2;
        this.m_proxyLogin = string3 == null ? "" : string3;
        this.m_proxyPassword = string4 == null ? "" : string4;
        this.m_resolveOption = s;
        this.m_hostAdd = inetAddress;
        this.setTryAllIps(false);
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        String string2 = this.getHost();
        this.setHost(null);
        int n = this.getPort();
        this.setPort(this.m_proxyPort);
        this.setBytesToReceive(2);
        super.initializeConnection(this.m_proxyServer, connectionInitializer);
        this.setPort(n);
        this.setHost(string2 == null ? string : string2);
        if (null == this.m_hostAdd && this.m_resolveOption == 0) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "initializeConnection", "Socks5 Connection Failed to resolve name locally Terminating connection.");
            }
            this.close(-2147483129);
        } else {
            this.m_state = 1;
            this.sendHndShakeMsg();
        }
    }

    protected boolean isReadyForInitialSend() {
        return this.m_state == 4;
    }

    protected void sendHndShakeMsg() throws IOException {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        ndrOutputStream.writeByte(5);
        ndrOutputStream.writeByte(2);
        ndrOutputStream.writeByte(0);
        ndrOutputStream.writeByte(2);
        this.m_sender.send(ndrOutputStream.toByteArray());
    }

    protected void sendAuthRequest() throws IOException {
        this.setBytesToReceive(2);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        byte[] byArray = this.m_proxyLogin.getBytes();
        byte[] byArray2 = this.m_proxyPassword.getBytes();
        ndrOutputStream.writeByte(1);
        ndrOutputStream.writeByte(byArray.length);
        ndrOutputStream.write(byArray);
        ndrOutputStream.writeByte(byArray2.length);
        ndrOutputStream.write(byArray2);
        this.m_sender.send(ndrOutputStream.toByteArray());
    }

    protected void sendConnectRequest() throws IOException {
        this.setBytesToReceive(10);
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        ndrOutputStream.writeByte(5);
        ndrOutputStream.writeByte(1);
        ndrOutputStream.writeByte(0);
        if (this.m_hostAdd != null) {
            ndrOutputStream.writeByte(1);
            ndrOutputStream.write(this.m_hostAdd.getAddress());
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendConnectRequest", "Socks5Connection. host name resolved locally." + this.m_hostAdd);
            }
        } else {
            ndrOutputStream.writeByte(3);
            byte[] byArray = this.getHost().getBytes();
            ndrOutputStream.writeByte(byArray.length);
            ndrOutputStream.write(byArray);
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendConnectRequest", "Socks5Connection: host name resolved on server.");
            }
        }
        ndrOutputStream.writeShort(this.getPort());
        this.m_sender.send(ndrOutputStream.toByteArray());
    }

    void onReceive(byte[] byArray) {
        if (this.m_state == 4) {
            super.onReceive(byArray);
            return;
        }
        boolean bl = false;
        switch (this.m_state) {
            case 1: {
                bl = this.onInitialHShk(byArray);
                break;
            }
            case 2: {
                bl = this.onAuthenticate(byArray);
                break;
            }
            case 3: {
                bl = this.onConnect(byArray);
                break;
            }
            default: {
                Debug.stAssert(false);
            }
        }
        if (!bl) {
            this.close(-2147483126);
        }
    }

    boolean onInitialHShk(byte[] byArray) {
        block5: {
            Debug.stAssert(byArray.length == 2);
            try {
                if (byArray[0] != 5) {
                    return false;
                }
                if (byArray[1] == 0) {
                    this.m_state = 3;
                    this.sendConnectRequest();
                    break block5;
                }
                if (byArray[1] == 2) {
                    this.m_state = 2;
                    this.sendAuthRequest();
                    break block5;
                }
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    boolean onAuthenticate(byte[] byArray) {
        Debug.stAssert(byArray.length == 2);
        if (byArray[0] != 1 || byArray[1] != 0) {
            return false;
        }
        this.m_state = 3;
        try {
            this.sendConnectRequest();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    boolean onConnect(byte[] byArray) {
        Debug.stAssert(byArray.length == 10);
        if (byArray[0] != 5 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 1) {
            return false;
        }
        this.m_state = 4;
        this.setBytesToReceive(1);
        return true;
    }

    protected InetAddress getIp(String string, ConnectionInitializer connectionInitializer) {
        InetAddress inetAddress = null;
        try {
            inetAddress = this.safeGetByName(string, connectionInitializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inetAddress;
    }

    public String getProxyServer() {
        return this.m_proxyServer;
    }

    public String getProxyLogin() {
        return this.m_proxyLogin;
    }

    public String getProxyPassword() {
        return this.m_proxyPassword;
    }

    public int getProxyPort() {
        return this.m_proxyPort;
    }
}

