/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.DirectSocketConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

class Socks4ConnectionImpl
extends DirectSocketConnection {
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_HANDSHAKE = 1;
    private static final int STATE_CONNECTED = 2;
    private static final int LENGTH_HANDSHAKE_RESPONSE = 8;
    private int m_state = 0;
    private String m_proxyServer;
    private int m_proxyPort;
    private String m_userId;
    private short m_resolveOption;
    private InetAddress m_hostAddress;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public Socks4ConnectionImpl(String string, int n, String string2, int n2, String string3, long l, short s, InetAddress inetAddress) {
        super(string, n, l);
        this.m_proxyServer = string2;
        this.m_proxyPort = n2;
        this.m_userId = string3 == null ? "" : string3;
        this.m_resolveOption = s;
        this.m_hostAddress = inetAddress;
        this.setTryAllIps(false);
    }

    protected void initializeConnection(String string, ConnectionInitializer connectionInitializer) throws IOException {
        String string2 = this.getHost();
        this.setHost(null);
        int n = this.getPort();
        this.setPort(this.m_proxyPort);
        this.setBytesToReceive(8);
        super.initializeConnection(this.m_proxyServer, connectionInitializer);
        this.setHost(string2 == null ? string : string2);
        this.setPort(n);
        this.m_state = 1;
        if (null == this.m_hostAddress && this.m_resolveOption == 0) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "initializeConnection", "Socks4 Connection Failed to resolve name locally Terminating connection.");
            }
            this.close(-2147483129);
        } else {
            this.sendHndShakeMsg(string, this.m_hostAddress, n, this.m_userId);
        }
    }

    protected boolean isReadyForInitialSend() {
        return this.m_state == 2;
    }

    protected void sendHndShakeMsg(String string, InetAddress inetAddress, int n, String string2) throws IOException {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        ndrOutputStream.writeByte(4);
        ndrOutputStream.writeByte(1);
        ndrOutputStream.writeShort(n);
        if (null != inetAddress) {
            ndrOutputStream.write(inetAddress.getAddress());
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendHndShakeMsg", "Socks4Connection. host name resolved locally." + inetAddress);
            }
        } else {
            ndrOutputStream.writeByte(0);
            ndrOutputStream.writeByte(0);
            ndrOutputStream.writeByte(0);
            ndrOutputStream.writeByte(1);
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendHndShakeMsg", "Socks4Connection: host name resolved on server.");
            }
        }
        ndrOutputStream.writeBytes(string2);
        ndrOutputStream.writeByte(0);
        if (null == inetAddress) {
            ndrOutputStream.write(string.getBytes());
            ndrOutputStream.writeByte(0);
        }
        this.m_sender.send(ndrOutputStream.toByteArray());
    }

    void onReceive(byte[] byArray) {
        if (this.m_state == 2) {
            super.onReceive(byArray);
        } else {
            Debug.stAssert(byArray.length == 8);
            if (byArray[1] != 90) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "onReceive", "Proxy error occured");
                }
                this.close(-2147483126);
            }
            this.setBytesToReceive(1);
            this.m_state = 2;
        }
    }

    public String getProxyServer() {
        return this.m_proxyServer;
    }

    public int getProxyPort() {
        return this.m_proxyPort;
    }

    public String getUserId() {
        return this.m_userId;
    }
}

