/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.Receiver;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

class SocketReceiver
extends Receiver {
    private static final int NS_READ_TIMEOUT = 1000;
    private DataInputStream m_inStream = null;

    protected SocketReceiver(Socket socket, Connection connection) throws IOException {
        super(connection);
        if (StaticProps.m_bNSVendor) {
            socket.setSoTimeout(1000);
        }
        this.m_inStream = new DataInputStream(socket.getInputStream());
    }

    protected void initialize() throws IOException {
    }

    protected void cleanup() {
        this.m_inStream = null;
    }

    protected void interruptReading() {
        try {
            this.m_inStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void receive(byte[] byArray) throws IOException {
        this.readFully(this.m_inStream, byArray);
    }

    protected void readFully(DataInputStream dataInputStream, byte[] byArray) throws IOException {
        if (!StaticProps.m_bNSVendor) {
            dataInputStream.readFully(byArray);
        } else {
            try {
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    boolean bl;
                    do {
                        bl = false;
                        try {
                            n = dataInputStream.read();
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            bl = true;
                        }
                    } while (bl);
                    if (n < 0) {
                        throw new EOFException();
                    }
                    byArray[i] = (byte)n;
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException("stream closed");
            }
        }
    }
}

