/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.Connection;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class Receiver
implements Runnable {
    private static final String THREAD_NAME = "Aunt Zelma's VP Listener ";
    private static final int DEFAULT_BYTES_TO_READ = 1;
    private static int c_threadCount = 0;
    private Connection m_connection = null;
    private boolean m_stopped = false;
    private Thread m_thread = null;
    private int m_bytesToRead;
    private byte[] m_buffer;
    private int m_bufferPosition;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected Receiver(Connection connection) throws IOException {
        this.m_connection = connection;
        this.m_bytesToRead = 1;
        this.m_bufferPosition = 0;
        this.m_buffer = new byte[this.m_bytesToRead];
    }

    public void run() {
        block6: {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "run", "Receiver: run started");
            }
            try {
                while (!this.m_stopped) {
                    this.receive(this.m_buffer);
                    if (this.m_logger.isLoggable(Level.FINEST)) {
                        String string = new String(this.m_buffer);
                        this.m_logger.logp(Level.FINEST, this.getClass().getName(), "run", "Data Received: " + string);
                    }
                    this.m_connection.onReceive(this.m_buffer);
                }
            }
            catch (Throwable throwable) {
                if (!this.m_logger.isLoggable(Level.FINEST)) break block6;
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "run", "Exception on Receiver: ", throwable);
            }
        }
        this.closeReceiver();
        this.m_thread = null;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "run", "Receiver: run exiting.");
        }
    }

    void stopReceiver() {
        if (this.m_stopped) {
            return;
        }
        this.m_stopped = true;
        this.interruptReading();
        this.m_bytesToRead = 1;
        this.m_bufferPosition = 0;
        this.m_buffer = new byte[this.m_bytesToRead];
    }

    public void startReceiver() throws IOException {
        Debug.stAssert(this.m_thread == null);
        if (this.m_thread != null) {
            return;
        }
        this.m_thread = new Thread((Runnable)this, THREAD_NAME + ++c_threadCount);
        this.initialize();
        this.m_thread.start();
    }

    protected abstract void initialize() throws IOException;

    protected abstract void cleanup();

    protected abstract void receive(byte[] var1) throws IOException;

    protected abstract void interruptReading();

    protected void setBytesToReceive(int n) {
        this.m_buffer = new byte[n];
        this.m_bytesToRead = n;
        this.m_bufferPosition = 0;
    }

    protected void closeReceiver() {
        if (this.m_connection == null) {
            return;
        }
        this.m_connection.onReceiverStopped();
        this.cleanup();
        this.m_connection = null;
    }
}

