/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.logging.TkLogger;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.ClosedListener;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.DataListener;
import com.lotus.sametime.core.util.connection.RC2Connection;
import com.lotus.sametime.core.util.connection.Receiver;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class RC2Receiver
extends Receiver
implements ClosedListener,
DataListener {
    private static final byte KEEP_ALIVE_MASK = -128;
    private static final byte[] KEEP_ALIVE_MESSAGE = new byte[]{-128};
    private static final int LENGTH_BYTES = 4;
    private static final int STATE_RECEIVE_FIRST_BYTE = 0;
    private static final int STATE_RECEIVE_LENGTH = 1;
    private static final int STATE_RECEIVE_MESSAGE = 2;
    private Connection m_realConn;
    private RC2Connection m_parentConn;
    private byte[] m_key;
    private RC2Cipher m_decCipher;
    private PipedOutputStream m_pipeOut;
    private DataInputStream m_pipeIn;
    private byte m_firstByte;
    private int m_receiveState = 0;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected RC2Receiver(Connection connection, byte[] byArray, RC2Connection rC2Connection) throws IOException {
        super(rC2Connection);
        this.m_realConn = connection;
        this.m_parentConn = rC2Connection;
        this.m_decCipher = new RC2Cipher();
        this.m_decCipher.init(1, byArray);
        try {
            this.m_pipeOut = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(this.m_pipeOut);
            this.m_pipeIn = new DataInputStream(pipedInputStream);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
    }

    protected void initialize() throws IOException {
        this.m_receiveState = 0;
        this.m_realConn.setBytesToReceive(1);
        this.m_realConn.setClosedListener(this);
        this.m_realConn.setDataListener(this);
    }

    protected void cleanup() {
        this.m_realConn.setClosedListener(null);
        this.m_realConn.setDataListener(null);
    }

    protected void receive(byte[] byArray) throws IOException {
        this.m_pipeIn.readFully(byArray);
    }

    protected void interruptReading() {
        try {
            this.m_pipeOut.close();
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
    }

    public void onReceive(byte[] byArray, Connection connection) {
        switch (this.m_receiveState) {
            case 0: {
                Debug.stAssert(byArray.length == 1);
                if ((byArray[0] & 0xFFFFFF80) != 0) break;
                this.m_firstByte = byArray[0];
                this.m_receiveState = 1;
                this.m_realConn.setBytesToReceive(3);
                break;
            }
            case 1: {
                Debug.stAssert(byArray.length == 3);
                int n = this.m_firstByte & 0xFF;
                for (int i = 0; i < byArray.length; ++i) {
                    n = n << 8 | byArray[i] & 0xFF;
                }
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, this.getClass().getName(), "onReceive", "Expected message length = " + n);
                }
                this.m_receiveState = 2;
                this.m_realConn.setBytesToReceive(n);
                break;
            }
            case 2: {
                this.m_receiveState = 0;
                this.m_realConn.setBytesToReceive(1);
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onReceive", "RC2Receiver: encrypted message = ");
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "onReceive", TkLogger.formatBytes(byArray));
                }
                byte[] byArray2 = this.m_decCipher.doFinal(byArray);
                try {
                    this.m_pipeOut.write(byArray2);
                    this.m_pipeOut.flush();
                }
                catch (IOException iOException) {
                    Debug.stAssert(false);
                }
                break;
            }
            default: {
                Debug.stAssert(false);
            }
        }
    }

    public void onConnectionClosed(int n, Connection connection) {
        try {
            this.m_pipeOut.close();
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
    }
}

