/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.logging.TkLogger;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrOutputStream;
import com.lotus.sametime.core.util.RandomGenerator;
import com.lotus.sametime.core.util.connection.Sender;
import com.lotus.sametime.core.util.enc.DiffieHellman;
import com.lotus.sametime.core.util.enc.RC2Cipher;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class PollingSender
extends Sender {
    private static final long INITIAL_POLLING_RATE = 1000L;
    private static final int RETRIES_COUNT = 5;
    private static final int RETRIES_WAIT = 3000;
    private static final String POLLING_URL_FILE = "/CommunityCBR/CC." + Integer.toHexString(53) + '.';
    private static final int MASTER_CNL_LENGTH = 4;
    private static final int CONTROL_MSG_POLLING_INTERVAL = 1;
    private static final int RC2_KEY_LENGTH = 16;
    private static final byte[] EMPTY_KEEPALIVE_MESSAGE = new byte[0];
    private static final int ENCRYPTED_SERVER_VERSION = 1;
    private static final int CLIENT_VERSION = 1;
    private String m_host = null;
    private int m_port = 0;
    private URL m_hostUrl = null;
    PipedOutputStream m_receivedOutputStream;
    PipedInputStream m_receivedInputStream;
    private byte[] m_masterCnlId = null;
    private byte[] m_requestId = null;
    private String m_saLoginId = "";
    DiffieHellman m_keyGenerator;
    byte[] m_privateKey;
    RC2Cipher m_signCipher;
    RC2Cipher m_encryptCipher;
    RC2Cipher m_decryptCipher;
    int m_serverVersion;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected PollingSender(String string, int n, URL uRL) {
        this.m_host = string;
        this.m_port = n;
        this.m_hostUrl = uRL;
        try {
            this.m_receivedInputStream = new PipedInputStream(){
                {
                    this.buffer = new byte[65536];
                }
            };
            this.m_receivedOutputStream = new PipedOutputStream(this.m_receivedInputStream);
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        this.m_keyGenerator = new DiffieHellman(DiffieHellman.Default_Modulus, DiffieHellman.Default_Base);
        Random random = RandomGenerator.getRandomGenerator();
        this.m_privateKey = this.m_keyGenerator.generatePrivateKey(random);
        this.setPollingRate(1000L);
    }

    public void setKeepAliveParams(long l, byte[] byArray) {
    }

    public void setPollingRate(long l) {
        super.setKeepAliveParams(l, EMPTY_KEEPALIVE_MESSAGE);
    }

    public long getPollingRate() {
        return super.getKeepAliveRate();
    }

    protected InputStream getPolledInputStream() {
        return this.m_receivedInputStream;
    }

    protected void initialize() {
    }

    protected void cleanup() {
    }

    protected boolean sendKeepAlive() {
        try {
            this.send(null);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected synchronized void send(byte[] byArray) throws IOException {
        boolean bl = false;
        int n = 5;
        if (this.m_masterCnlId == null) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "send", "send: sending empty message");
            }
            this.sendWithoutChecking(null);
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "send", "send: sending real");
        }
        this.sendWithoutChecking(byArray);
    }

    protected synchronized void sendWithoutChecking(byte[] byArray) throws IOException {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithoutChecking", "sendWithoutChecking: sending");
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithoutChecking", TkLogger.formatBytes(byArray));
        }
        boolean bl = false;
        int n = 5;
        if (this.m_serverVersion >= 1 && byArray != null && byArray.length != 0) {
            Debug.stAssert(this.m_encryptCipher != null);
            byArray = this.m_encryptCipher.doFinal(byArray);
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithoutChecking", "sendWithoutChecking: encrypted messages");
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithoutChecking", TkLogger.formatBytes(byArray));
            }
        }
        n = 5;
        while (n > 0) {
            try {
                this.sendOnce(byArray);
                bl = true;
                break;
            }
            catch (IOException iOException) {
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithoutChecking", "Exception on trying to connect: ", iOException);
                }
                if (--n <= 0) continue;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!bl) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendWithoutChecking", "send: exceeded the maximum number of retries...");
            }
            try {
                this.m_receivedOutputStream.flush();
                this.m_receivedOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("Exceeded the maximum number of retries.");
        }
    }

    protected synchronized void sendOnce(byte[] byArray) throws IOException {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "PollingSender: polling at " + new Date());
            if (byArray != null) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", TkLogger.formatBytes(byArray));
            }
        }
        URLConnection uRLConnection = this.createURLConnection();
        DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
        if (this.m_masterCnlId == null) {
            this.writeInitialMsg(byArray, dataOutputStream);
        } else {
            this.writeRegularMsg(byArray, dataOutputStream);
        }
        if (dataOutputStream.size() % 4096 == 0) {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        DataInputStream dataInputStream = new DataInputStream(this.safeGetInputStream(uRLConnection));
        int n = uRLConnection.getContentLength();
        if (n < 0) {
            throw new IOException("Unknown message length");
        }
        byte[] byArray2 = new byte[n];
        dataInputStream.readFully(byArray2);
        dataInputStream.close();
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "Received HTTP message:");
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", TkLogger.formatBytes(byArray2));
        }
        dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
        byte[] byArray3 = this.m_masterCnlId == null ? this.readInitialResponse(dataInputStream) : this.readRegularResponse(dataInputStream);
        if (this.m_serverVersion >= 1 && byArray3.length != 0) {
            Debug.stAssert(this.m_decryptCipher != null);
            byArray3 = this.m_decryptCipher.doFinal(byArray3);
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", "receivedMsg = ");
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "sendOnce", TkLogger.formatBytes(byArray3));
        }
        if (byArray3 != null) {
            try {
                this.m_receivedOutputStream.write(byArray3);
            }
            catch (IOException iOException) {
                Debug.stAssert(false);
            }
        }
    }

    protected URLConnection createURLConnection() throws IOException {
        String string = POLLING_URL_FILE + this.encodeURL(this.m_saLoginId) + '/';
        String string2 = this.m_hostUrl == null ? "http://" + this.m_host + ":" + this.m_port + string : this.m_hostUrl.toString() + string;
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "createURLConnection", "Trying to connect to " + string2);
        }
        URL uRL = new URL(string2);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Pragma", "No-Cache");
        uRLConnection.setRequestProperty("Content-Type", "Application/Octet-Stream");
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        return uRLConnection;
    }

    protected void writeInitialMsg(byte[] byArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(1);
        byte[] byArray2 = this.m_keyGenerator.generatePublicKey(this.m_privateKey);
        this.writeBytes(dataOutputStream, byArray2);
        if (byArray != null) {
            dataOutputStream.write(byArray);
        }
    }

    protected void writeRegularMsg(byte[] byArray, DataOutputStream dataOutputStream) throws IOException {
        Debug.stAssert(this.m_masterCnlId != null);
        dataOutputStream.write(this.m_masterCnlId);
        this.writeBytes(dataOutputStream, this.m_requestId);
        if (byArray != null) {
            dataOutputStream.write(byArray);
        }
    }

    private byte[] readInitialResponse(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = new byte[4];
        long l = this.getPollingRate();
        this.readFully(dataInputStream, byArray2);
        String string = dataInputStream.readUTF();
        this.m_serverVersion = 0;
        if (string.length() == 0) {
            this.m_serverVersion = dataInputStream.readInt();
            string = dataInputStream.readUTF();
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", "m_serverVersion = " + this.m_serverVersion);
        }
        byte[] byArray3 = this.readBytes(dataInputStream);
        byArray = this.readBytes(dataInputStream);
        int n = this.readByte(dataInputStream);
        while (n-- > 0) {
            int n2 = this.readByte(dataInputStream);
            if (n2 != 1) continue;
            l = dataInputStream.readInt();
        }
        byte[] byArray4 = new byte[dataInputStream.available()];
        this.readFully(dataInputStream, byArray4);
        this.m_masterCnlId = byArray2;
        this.m_saLoginId = string;
        this.setPollingRate(l);
        byte[] byArray5 = this.m_keyGenerator.generateAgreedValue(this.m_privateKey, byArray3);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", "agreed key = ");
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "readInitialResponse", TkLogger.formatBytes(byArray5));
        }
        this.createCiphers(byArray5, 16);
        this.m_requestId = this.m_signCipher.doFinal(byArray);
        return byArray4;
    }

    private byte[] readRegularResponse(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = null;
        long l = this.getPollingRate();
        byArray = this.readBytes(dataInputStream);
        int n = this.readByte(dataInputStream);
        while (n-- > 0) {
            int n2 = this.readByte(dataInputStream);
            if (n2 != 1) continue;
            l = dataInputStream.readInt();
        }
        byte[] byArray2 = new byte[dataInputStream.available()];
        this.readFully(dataInputStream, byArray2);
        this.setPollingRate(l);
        Debug.stAssert(this.m_signCipher != null);
        this.m_requestId = this.m_signCipher.doFinal(byArray);
        return byArray2;
    }

    protected void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        try {
            int n = byArray.length;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; i += n3) {
                n3 = inputStream.read(byArray, n2 + i, n - i);
                if (n3 > 0) continue;
                throw new EOFException();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("stream closed");
        }
    }

    int readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    protected InputStream safeGetInputStream(URLConnection uRLConnection) throws IOException {
        try {
            return uRLConnection.getInputStream();
        }
        catch (SecurityException securityException) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "safeGetInputStream", "Requesting privilage fo HTTP connection.");
            }
            return uRLConnection.getInputStream();
        }
    }

    public byte[] readBytes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        this.readFully(dataInputStream, byArray);
        return byArray;
    }

    public void writeBytes(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        if (byArray != null) {
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private String encodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(URLEncoder.encode(string), "+");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append("%20");
        }
        return stringBuffer.toString();
    }

    public void createCiphers(byte[] byArray, int n) {
        int n2;
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "createCiphers", "createCiphers called");
        }
        byte[] byArray2 = new byte[n];
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray2[n2] = 0;
        }
        n2 = n >= byArray.length ? 0 : byArray.length - n;
        int n3 = n < byArray.length ? n : byArray.length;
        System.arraycopy(byArray, n2, byArray2, n - n3, n3);
        this.m_signCipher = new RC2Cipher();
        this.m_signCipher.init(0, byArray2);
        this.m_encryptCipher = new RC2Cipher();
        this.m_encryptCipher.init(0, byArray2);
        this.m_decryptCipher = new RC2Cipher();
        this.m_decryptCipher.init(1, byArray2);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "createCiphers", "out of createCiphers");
        }
    }

    public byte[] buildCompoundMessage() throws IOException {
        NdrOutputStream ndrOutputStream = new NdrOutputStream();
        while (!this.m_queue.isEmpty()) {
            ndrOutputStream.write((byte[])this.m_queue.getNext());
        }
        return ndrOutputStream.toByteArray();
    }
}

