/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

class InterruptibleSocketInputStream
extends FilterInputStream {
    private static final int READ_TIMEOUT = 250;
    private boolean m_interrupted = false;

    public InterruptibleSocketInputStream(Socket socket) throws IOException {
        super(socket.getInputStream());
        socket.setSoTimeout(250);
    }

    public void interrupt() {
        this.m_interrupted = true;
    }

    public int read() throws IOException {
        boolean bl = false;
        int n = 0;
        do {
            try {
                n = this.in.read();
                bl = true;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!this.m_interrupted) continue;
                this.m_interrupted = false;
                throw new IOException("Interrupted while reading");
            }
        } while (!bl);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        do {
            try {
                n3 += this.in.read(byArray, n + n3, n2 - n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.m_interrupted) {
                    this.m_interrupted = false;
                    throw new IOException("Interrupted while reading");
                }
                n3 += interruptedIOException.bytesTransferred;
            }
        } while (n3 < n2);
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }
}

