/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.Receiver;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

class HttpReceiver
extends Receiver {
    protected String m_host = null;
    protected int m_port = 0;
    protected URL m_hostUrl = null;
    protected InputStream m_inStream = null;
    protected byte[] m_masterId = null;
    protected ConnectionInitializer m_initializer = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected HttpReceiver(String string, int n, URL uRL, Connection connection) throws IOException {
        super(connection);
        this.m_host = string;
        this.m_port = n;
        this.m_hostUrl = uRL;
    }

    protected void initialize() throws IOException {
        URL uRL = this.m_hostUrl == null ? new URL("http", this.m_host, this.m_port, "/communityCBR/") : new URL(this.m_hostUrl.toString() + "/communityCBR/");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Pragma", "No-Cache");
        uRLConnection.setRequestProperty("Content-Type", "Application/Octet-Stream");
        this.m_inStream = this.safeGetInputStream(uRLConnection);
        DataInputStream dataInputStream = new DataInputStream(this.m_inStream);
        dataInputStream.readByte();
        short s = dataInputStream.readShort();
        this.m_masterId = new byte[s];
        dataInputStream.readFully(this.m_masterId);
        dataInputStream.readInt();
        dataInputStream.readShort();
    }

    protected void cleanup() {
        this.interruptReading();
    }

    protected void interruptReading() {
        if (this.m_inStream != null) {
            try {
                this.m_inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_inStream = null;
        }
    }

    protected void receive(byte[] byArray) throws IOException {
        try {
            int n = byArray.length;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; i += n3) {
                n3 = this.m_inStream.read(byArray, n2 + i, n - i);
                if (n3 > 0) continue;
                throw new EOFException();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("stream closed");
        }
    }

    public byte[] getMasterId() {
        return this.m_masterId;
    }

    public void setInitializer(ConnectionInitializer connectionInitializer) {
        this.m_initializer = connectionInitializer;
    }

    protected InputStream safeGetInputStream(URLConnection uRLConnection) throws IOException {
        try {
            return uRLConnection.getInputStream();
        }
        catch (SecurityException securityException) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "safeGetInputStream", "Requesting privilage to create an HTTP connection.");
            }
            return uRLConnection.getInputStream();
        }
    }
}

