/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.SocketConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectSocketConnection
extends SocketConnection {
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public DirectSocketConnection(String string, int n, long l) {
        super(string, n, l);
    }

    public DirectSocketConnection(int n, long l) {
        this(null, n, l);
    }

    protected Socket safeGetSocket(String string, int n, ConnectionInitializer connectionInitializer) throws IOException {
        Socket socket = null;
        this.removeProxySettings();
        socket = super.safeGetSocket(string, n, connectionInitializer);
        return socket;
    }

    protected InetAddress safeGetByName(String string, ConnectionInitializer connectionInitializer) throws IOException {
        return InetAddress.getByName(string);
    }

    void removeProxySettings() throws SecurityException {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "removeProxySettings", "removeProxySettings called");
        }
        Properties properties = System.getProperties();
        properties.remove("socksProxyHost");
        properties.remove("socksProxyPort");
        System.setProperties(properties);
    }

    public ConnectionInfo getConnectionInfo() {
        return new ConnectionInfo(1, this.getPort(), null, 0, null, null, false, this.getHost(), null);
    }
}

