/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.connection.ClosedListener;
import com.lotus.sametime.core.util.connection.ConnectionInfo;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.DataListener;
import com.lotus.sametime.core.util.connection.Receiver;
import com.lotus.sametime.core.util.connection.Sender;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Connection {
    protected DataListener m_dataListener;
    protected ClosedListener m_closedListener;
    protected Receiver m_receiver;
    protected Sender m_sender;
    boolean m_closeRequested = false;
    int m_closeReason = 0;
    long m_timeout;
    private boolean m_isReady = false;
    private String m_host = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected Connection(long l) {
        this.m_timeout = l;
    }

    protected abstract void initializeConnection(String var1, ConnectionInitializer var2) throws IOException;

    protected boolean isReady() {
        return this.m_isReady;
    }

    public abstract ConnectionInfo getConnectionInfo();

    protected boolean isReadyForInitialSend() {
        return this.m_sender != null && this.m_receiver != null;
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public String getHost() {
        return this.m_host;
    }

    protected void setHost(String string) {
        this.m_host = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDataListener(DataListener dataListener) {
        Connection connection = this;
        synchronized (connection) {
            this.m_dataListener = dataListener;
            this.notifyAll();
        }
    }

    protected void setClosedListener(ClosedListener closedListener) {
        this.m_closedListener = closedListener;
    }

    protected DataListener getDataListener() {
        return this.m_dataListener;
    }

    protected ClosedListener getClosedListener() {
        return this.m_closedListener;
    }

    public void sendMessage(byte[] byArray, byte by) {
        block2: {
            try {
                this.m_sender.queueMessage(byArray, by);
            }
            catch (Exception exception) {
                if (!this.m_logger.isLoggable(Level.FINER)) break block2;
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "sendMessage", "Connection: Unable to send message.", exception);
            }
        }
    }

    public void close() {
        this.m_closeRequested = true;
        if (this.m_sender != null) {
            this.m_sender.stopSender();
        }
        if (this.m_receiver != null) {
            this.m_receiver.stopReceiver();
        }
    }

    public void close(int n) {
        this.m_closeReason = n;
        this.close();
    }

    public void setKeepAliveParams(long l, byte[] byArray) {
        if (this.m_sender != null) {
            this.m_sender.setKeepAliveParams(l, byArray);
        }
    }

    public void setBytesToReceive(int n) {
        if (this.m_receiver != null) {
            this.m_receiver.setBytesToReceive(n);
        }
    }

    synchronized void onReceive(byte[] byArray) {
        this.m_isReady = true;
        while (this.m_dataListener == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_dataListener.onReceive(byArray, this);
    }

    void onReceiverStopped() {
        if (this.m_sender != null) {
            this.m_sender.stopSender();
        }
        this.m_receiver = null;
        this.m_sender = null;
        this.m_isReady = false;
        this.m_dataListener = null;
        if (this.m_closedListener != null) {
            int n = this.m_closeRequested ? this.m_closeReason : -2147483623;
            this.m_closeReason = 0;
            this.m_closeRequested = false;
            this.m_closedListener.onConnectionClosed(n, this);
        }
    }

    public String toString() {
        return this.getConnectionInfo().toString();
    }
}

