/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class MarkableByteOutputStream
extends ByteArrayOutputStream {
    private static Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util");

    MarkableByteOutputStream() {
    }

    public void writeMark(int n, int n2) throws IOException {
        byte[] byArray = MarkableByteOutputStream.intToByteArray(n2);
        for (int i = 0; i < byArray.length; ++i) {
            this.buf[n + i] = byArray[i];
        }
    }

    public int position() {
        return this.count;
    }

    static byte[] intToByteArray(int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.logp(Level.FINER, MarkableByteOutputStream.class.getName(), "intToByteArray", "Error convertion int to NDR: " + iOException);
            }
            return null;
        }
    }
}

