/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.types;

import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STLoginId;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class STUserInstance
extends STUser
implements Cloneable {
    public static final short LT_USER_JAVA_COMP = 4097;
    public static final short LT_USER_JAVA_APP = 4099;
    public static final short LT_ANON_MASK = 2048;
    public static final short LT_SERVER_APP_MASK = 8192;
    public static final short LT_MUX_APP_MASK = 16384;
    public static final short LT_SERVER_APP = 8192;
    public static final short LT_MUX_APP = 24576;
    public static final short LT_LIGHT_CLIENT_USER = 4106;
    private STLoginId m_loginId;
    private short m_loginType;
    private STServer m_server;
    private InetAddress m_ip;

    public STUserInstance(STLoginId sTLoginId, short s, STId sTId, String string, String string2, InetAddress inetAddress, STServer sTServer) {
        super(sTId, string, string2);
        this.m_loginId = sTLoginId;
        this.m_loginType = s;
        this.m_ip = inetAddress;
        this.m_server = sTServer;
    }

    public STUserInstance(NdrInputStream ndrInputStream) throws IOException {
        super(null, "", "");
        String string = ndrInputStream.readUTF();
        this.m_loginType = ndrInputStream.readShort();
        String string2 = ndrInputStream.readUTF();
        this.setName(ndrInputStream.readUTF());
        String string3 = ndrInputStream.readUTF();
        this.setId(new STId(string2, string3));
        this.m_loginId = new STLoginId(string, string3);
        boolean bl = ndrInputStream.readBoolean();
        if (bl) {
            this.setDesc(ndrInputStream.readUTF());
            this.m_ip = ndrInputStream.readInetAddress();
            String string4 = ndrInputStream.readUTF();
            STId sTId = new STId(string4, "");
            this.m_server = new STServer(sTId, "", "");
        } else {
            this.setDesc("");
            this.m_ip = null;
            this.m_server = null;
        }
    }

    public void dump(NdrOutputStream ndrOutputStream, boolean bl) throws IOException {
        ndrOutputStream.writeUTF(this.m_loginId.getId());
        ndrOutputStream.writeShort(this.m_loginType);
        ndrOutputStream.writeUTF(this.getId().getId());
        ndrOutputStream.writeUTF(this.getName());
        ndrOutputStream.writeUTF(this.getId().getCommunityName());
        ndrOutputStream.writeBoolean(bl);
        if (bl) {
            ndrOutputStream.writeUTF(this.getDesc());
            ndrOutputStream.writeInetAddress(this.m_ip);
            ndrOutputStream.writeUTF(this.m_server.getId().getId());
        }
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        this.dump(ndrOutputStream, false);
    }

    public Object clone() {
        return new STUserInstance(this.m_loginId, this.m_loginType, this.getId(), this.getName(), this.getDesc(), this.m_ip, this.m_server);
    }

    public short getLoginType() {
        return this.m_loginType;
    }

    public boolean isAnon() {
        return (this.m_loginType & 0x800) == 2048;
    }

    public void setName(String string) {
        super.setName(string);
    }

    public String getCommunityName() {
        return this.getId().getCommunityName();
    }

    public STServer getServerId() {
        return this.m_server;
    }

    public STLoginId getLoginId() {
        return this.m_loginId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(super.toString());
        stringBuffer.append("loginId = ");
        stringBuffer.append(this.m_loginId.toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

